/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.provider.ChunkProviderType;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveGeneration;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.random.BedrockCheckedRandom;
import mod.bluestaggo.modernerbeta.util.random.BedrockChunkRandom;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.biome.injector.BiomeInjector;
import mod.bluestaggo.modernerbeta.world.carver.BetaCaveCarverConfig;
import mod.bluestaggo.modernerbeta.world.carver.configured.ModernBetaConfiguredCarvers;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkNoiseSampler;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaGenerationStep;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;

public class ModernBetaChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<ModernBetaChunkGenerator> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(generator -> generator.biomeSource), (App)RegistryOps.retrieveGetter(ModernBetaRegistryKeys.SETTINGS_PRESET), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(generator -> generator.settings), (App)CompoundTag.CODEC.fieldOf("provider_settings").forGetter(generator -> generator.chunkSettings)).apply((Applicative)instance, instance.stable(ModernBetaChunkGenerator::new)));
    private final HolderGetter<ModernBetaSettingsPreset> presetRegistry;
    private final Holder<NoiseGeneratorSettings> settings;
    private final CompoundTag chunkSettings;
    private final Supplier<BiomeInjector> biomeInjector;
    private boolean useSurfaceRules;
    private CaveGeneration caveSettings = CaveGeneration.DEFAULT;
    private ChunkProvider chunkProvider;

    public ModernBetaChunkGenerator(BiomeSource biomeSource, HolderGetter<ModernBetaSettingsPreset> presetRegistry, Holder<NoiseGeneratorSettings> settings, CompoundTag chunkProviderSettings) {
        super(biomeSource, settings);
        this.settings = settings;
        this.presetRegistry = presetRegistry;
        this.chunkSettings = chunkProviderSettings;
        this.biomeInjector = Suppliers.memoize(() -> {
            BiomeInjector biomeInjector;
            BiomeSource patt0$temp = this.biomeSource;
            if (patt0$temp instanceof ModernBetaBiomeSource) {
                ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)patt0$temp;
                biomeInjector = new BiomeInjector(this, modernBetaBiomeSource);
            } else {
                biomeInjector = null;
            }
            return biomeInjector;
        });
        BiomeSource biomeSource2 = this.biomeSource;
        if (biomeSource2 instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource2;
            modernBetaBiomeSource.setChunkGenerator(this);
        }
    }

    public void initProvider(long seed) {
        ModernBetaSettings chunkSettings = ModernBetaSettings.fromCompound(this.chunkSettings).mapPreset(this.presetRegistry, ModernBetaSettingsPreset::chunkSettings);
        this.chunkProvider = ((ChunkProviderType)ModernBetaRegistries.CHUNK.getValue(chunkSettings.getProvider())).apply(this, seed);
        this.chunkProvider.initForestOctaveNoise();
        this.useSurfaceRules = chunkSettings.getOrDefault(SettingsComponentTypes.USE_SURFACE_RULES);
        this.caveSettings = chunkSettings.getOrDefault(SettingsComponentTypes.CAVE_GENERATION);
    }

    public CompletableFuture<ChunkAccess> createBiomes(RandomState noiseConfig, Blender blender, StructureManager structureAccessor, ChunkAccess chunk) {
        return CompletableFuture.supplyAsync(Util.name(() -> {
            NoiseChunk noiseSampler = chunk.getOrCreateNoiseChunk(c -> this.createNoiseChunk((ChunkAccess)c, structureAccessor, blender, noiseConfig));
            chunk.fillBiomesFromNoise((BiomeResolver)this.biomeSource, noiseSampler.cachedClimateSampler(noiseConfig.router(), ((NoiseGeneratorSettings)this.settings.value()).spawnTarget()));
            return chunk;
        }, () -> "init_biomes"), (Executor)Util.backgroundExecutor());
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState noiseConfig, StructureManager structureAccessor, ChunkAccess chunk) {
        return this.chunkProvider.provideChunk(Blender.empty(), structureAccessor, chunk, noiseConfig);
    }

    public void buildSurface(WorldGenRegion chunkRegion, StructureManager structureAccessor, RandomState noiseConfig, ChunkAccess chunk) {
        this.injectBiomes(chunk, noiseConfig.sampler(), BiomeInjector.BiomeInjectionStep.PRE);
        if (!this.chunkProvider.skipChunk(chunk.getPos().x, chunk.getPos().z, ModernBetaGenerationStep.SURFACE)) {
            BiomeSource biomeSource = this.biomeSource;
            if (biomeSource instanceof ModernBetaBiomeSource) {
                ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
                if (this.useSurfaceRules) {
                    this.buildDefaultSurface(chunkRegion, structureAccessor, noiseConfig, chunk);
                    this.chunkProvider.provideSurfaceExtra(chunkRegion, structureAccessor, chunk, modernBetaBiomeSource, noiseConfig);
                } else {
                    this.chunkProvider.provideSurface(chunkRegion, structureAccessor, chunk, modernBetaBiomeSource, noiseConfig);
                }
            } else {
                super.buildSurface(chunkRegion, structureAccessor, noiseConfig, chunk);
            }
        }
        this.injectBiomes(chunk, noiseConfig.sampler(), BiomeInjector.BiomeInjectionStep.POST);
    }

    public void buildDefaultSurface(WorldGenRegion chunkRegion, StructureManager structureAccessor, RandomState noiseConfig, ChunkAccess chunk) {
        super.buildSurface(chunkRegion, structureAccessor, noiseConfig, chunk);
    }

    public void applyCarvers(WorldGenRegion chunkRegion, long seed, RandomState noiseConfig, BiomeManager biomeAccess, StructureManager structureAccessor, ChunkAccess chunk) {
        if (this.chunkProvider.skipChunk(chunk.getPos().x, chunk.getPos().z, ModernBetaGenerationStep.CARVERS)) {
            return;
        }
        BiomeManager biomeAccessWithSource = biomeAccess.withDifferentSource((biomeX, biomeY, biomeZ) -> this.biomeSource.getNoiseBiome(biomeX, biomeY, biomeZ, noiseConfig.sampler()));
        ChunkPos chunkPos = chunk.getPos();
        int mainChunkX = chunkPos.x;
        int mainChunkZ = chunkPos.z;
        Aquifer aquiferSampler = this.chunkProvider.getAquiferSampler(chunk, noiseConfig);
        NoiseChunk chunkNoiseSampler = chunk.getOrCreateNoiseChunk(c -> this.createNoiseChunk((ChunkAccess)c, structureAccessor, Blender.of((WorldGenRegion)chunkRegion), noiseConfig));
        Registry configuredCarverRegistry = chunkRegion.registryAccess().lookupOrThrow(Registries.CONFIGURED_CARVER);
        CarvingContext carverContext = new CarvingContext((NoiseBasedChunkGenerator)this, chunkRegion.registryAccess(), chunk.getHeightAccessorForGeneration(), chunkNoiseSampler, noiseConfig, ((NoiseGeneratorSettings)this.settings.value()).surfaceRule());
        CarvingMask carvingMask = ((ProtoChunk)chunk).getOrCreateCarvingMask();
        CaveGeneration.SeedMethod seedMethod = this.caveSettings.seedMethod();
        WorldgenRandom random = switch (seedMethod) {
            case CaveGeneration.SeedMethod.MODERN -> new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.generateUniqueSeed()));
            case CaveGeneration.SeedMethod.BEDROCK -> new BedrockChunkRandom((RandomSource)new BedrockCheckedRandom((int)RandomSupport.generateUniqueSeed()));
            default -> new SingleThreadedRandomSource(seed);
        };
        long saltX = switch (seedMethod) {
            default -> throw new MatchException(null, null);
            case CaveGeneration.SeedMethod.BETA -> random.nextLong() / 2L * 2L + 1L;
            case CaveGeneration.SeedMethod.EARLY_RELEASE -> random.nextLong();
            case CaveGeneration.SeedMethod.MODERN, CaveGeneration.SeedMethod.BEDROCK -> 0L;
        };
        long saltZ = switch (seedMethod) {
            default -> throw new MatchException(null, null);
            case CaveGeneration.SeedMethod.BETA -> random.nextLong() / 2L * 2L + 1L;
            case CaveGeneration.SeedMethod.EARLY_RELEASE -> random.nextLong();
            case CaveGeneration.SeedMethod.MODERN, CaveGeneration.SeedMethod.BEDROCK -> 0L;
        };
        for (int chunkX = mainChunkX - 8; chunkX <= mainChunkX + 8; ++chunkX) {
            for (int chunkZ = mainChunkZ - 8; chunkZ <= mainChunkZ + 8; ++chunkZ) {
                ChunkPos carverPos = new ChunkPos(chunkX, chunkZ);
                ChunkAccess carverChunk = chunkRegion.getChunk(carverPos.x, carverPos.z);
                BiomeGenerationSettings genSettings = carverChunk.carverBiome(() -> this.getBiomeGenerationSettings(this.biomeSource.getNoiseBiome(QuartPos.fromBlock((int)carverPos.getMinBlockX()), 0, QuartPos.fromBlock((int)carverPos.getMinBlockZ()), noiseConfig.sampler())));
                Iterable carverList = genSettings.getCarvers();
                int salt = 0;
                for (Holder carverEntry : carverList) {
                    ResourceKey carverKey;
                    ConfiguredWorldCarver configuredCarver = (ConfiguredWorldCarver)carverEntry.value();
                    if (random instanceof WorldgenRandom) {
                        WorldgenRandom chunkRandom = random;
                        chunkRandom.setLargeFeatureSeed(seed + (long)salt, chunkX, chunkZ);
                    } else {
                        random.setSeed((long)chunkX * saltX + (long)chunkZ * saltZ ^ seed);
                    }
                    if ((this.caveSettings.forceBetaCaves() || this.caveSettings.forceBetaCanyons()) && (carverKey = (ResourceKey)carverEntry.unwrapKey().orElse(null)) != null) {
                        ConfiguredWorldCarver replacementCarver = null;
                        if (this.caveSettings.forceBetaCaves()) {
                            if (carverKey.equals(Carvers.CAVE)) {
                                replacementCarver = (ConfiguredWorldCarver)configuredCarverRegistry.getValue(ModernBetaConfiguredCarvers.BETA_CAVE);
                            } else if (carverKey.equals(Carvers.CAVE_EXTRA_UNDERGROUND)) {
                                replacementCarver = (ConfiguredWorldCarver)configuredCarverRegistry.getValue(ModernBetaConfiguredCarvers.BETA_CAVE_DEEP);
                            }
                        }
                        if (this.caveSettings.forceBetaCanyons() && carverKey.equals(Carvers.CANYON)) {
                            replacementCarver = (ConfiguredWorldCarver)configuredCarverRegistry.getValue(ModernBetaConfiguredCarvers.BETA_CANYON);
                        }
                        if (replacementCarver != null) {
                            configuredCarver = replacementCarver;
                        }
                    }
                    if (configuredCarver.isStartChunk((RandomSource)random)) {
                        CarverConfiguration carverConfiguration = configuredCarver.config();
                        if (carverConfiguration instanceof BetaCaveCarverConfig) {
                            BetaCaveCarverConfig betaCaveCarverConfig = (BetaCaveCarverConfig)carverConfiguration;
                            betaCaveCarverConfig.useFixedCaves = Optional.of(this.caveSettings.fixCaveBorders());
                            betaCaveCarverConfig.useSurfaceRules = Optional.of(this.useSurfaceRules);
                        }
                        configuredCarver.carve(carverContext, chunk, arg_0 -> ((BiomeManager)biomeAccessWithSource).getBiome(arg_0), (RandomSource)random, aquiferSampler, carverPos, carvingMask);
                    }
                    if (seedMethod == CaveGeneration.SeedMethod.BEDROCK) continue;
                    ++salt;
                }
            }
        }
    }

    public void applyBiomeDecoration(WorldGenLevel world, ChunkAccess chunk, StructureManager structureAccessor) {
        ChunkPos pos = chunk.getPos();
        if (this.chunkProvider.skipChunk(pos.x, pos.z, ModernBetaGenerationStep.FEATURES)) {
            return;
        }
        super.applyBiomeDecoration(world, chunk, structureAccessor);
    }

    public void spawnOriginalMobs(WorldGenRegion region) {
        ChunkPos pos = region.getCenter();
        if (this.chunkProvider.skipChunk(pos.x, pos.z, ModernBetaGenerationStep.ENTITY_SPAWN)) {
            return;
        }
        super.spawnOriginalMobs(region);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor world, RandomState noiseConfig) {
        return this.chunkProvider.getHeight(world, x, z, type);
    }

    public int getHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor world) {
        return this.chunkProvider.getHeight(world, x, z, type);
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor world, RandomState noiseConfig) {
        int height = this.chunkProvider.getHeight(world, x, z, Heightmap.Types.OCEAN_FLOOR_WG);
        int worldHeight = this.chunkProvider.getWorldHeight();
        int minY = this.chunkProvider.getWorldMinY();
        BlockState[] column = new BlockState[worldHeight];
        for (int y = worldHeight - 1; y >= 0; --y) {
            int worldY = y + minY;
            if (worldY > height) {
                if (worldY > this.getSeaLevel()) {
                    column[y] = BlockStates.AIR;
                    continue;
                }
                column[y] = ((NoiseGeneratorSettings)this.settings.value()).defaultFluid();
                continue;
            }
            column[y] = ((NoiseGeneratorSettings)this.settings.value()).defaultBlock();
        }
        return new NoiseColumn(minY, column);
    }

    public int getGenDepth() {
        if (this.chunkProvider == null) {
            return ((NoiseGeneratorSettings)this.getGeneratorSettings().value()).noiseSettings().height();
        }
        return this.chunkProvider.getWorldHeight();
    }

    public int getMinY() {
        if (this.chunkProvider == null) {
            return ((NoiseGeneratorSettings)this.getGeneratorSettings().value()).noiseSettings().minY();
        }
        return this.chunkProvider.getWorldMinY();
    }

    public int getSeaLevel() {
        return this.chunkProvider.getSeaLevel();
    }

    protected NoiseChunk createNoiseChunk(ChunkAccess chunk, StructureManager world, Blender blender, RandomState noiseConfig) {
        return ModernBetaChunkNoiseSampler.create(chunk, noiseConfig, (NoiseGeneratorSettings)this.settings.value(), this.chunkProvider.getFluidLevelSampler(), this.chunkProvider);
    }

    public Holder<NoiseGeneratorSettings> getGeneratorSettings() {
        return this.settings;
    }

    public HolderGetter<ModernBetaSettingsPreset> getPresetRegistry() {
        return this.presetRegistry;
    }

    public ChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public CompoundTag getChunkSettings() {
        return this.chunkSettings;
    }

    public BiomeInjector getBiomeInjector() {
        return this.biomeInjector.get();
    }

    public boolean allowSurfaceRules() {
        return this.useSurfaceRules;
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    private void injectBiomes(ChunkAccess chunk, Climate.Sampler noiseSampler, BiomeInjector.BiomeInjectionStep step) {
        BiomeInjector biomeInjector = this.biomeInjector.get();
        if (biomeInjector != null) {
            biomeInjector.injectBiomes(chunk, noiseSampler, step);
        }
    }

    public static void register(IRegistryHandler<?> handler) {
        IRegistryHandler<?> registryHandler = handler;
        registryHandler.register(ModernerBeta.createId("moderner_beta"), CODEC);
    }
}

