/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk;

import java.util.List;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.mixin.AccessorDensityFunctions;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaShapeConfigs;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class ModernBetaChunkGeneratorSettings {
    private static boolean useModernBetaSurfaceRules;
    public static final ResourceKey<NoiseGeneratorSettings> BETA;
    public static final ResourceKey<NoiseGeneratorSettings> ALPHA;
    public static final ResourceKey<NoiseGeneratorSettings> SKYLANDS;
    public static final ResourceKey<NoiseGeneratorSettings> INFDEV_611;
    public static final ResourceKey<NoiseGeneratorSettings> INFDEV_420;
    public static final ResourceKey<NoiseGeneratorSettings> INFDEV_415;
    public static final ResourceKey<NoiseGeneratorSettings> INFDEV_227;
    public static final ResourceKey<NoiseGeneratorSettings> INDEV;
    public static final ResourceKey<NoiseGeneratorSettings> CLASSIC_0_30;
    public static final ResourceKey<NoiseGeneratorSettings> PE;
    public static final ResourceKey<NoiseGeneratorSettings> EARLY_RELEASE;
    public static final ResourceKey<NoiseGeneratorSettings> MAJOR_RELEASE;
    public static final ResourceKey<NoiseGeneratorSettings> EARLY_BEDROCK;

    public static void bootstrap(BootstrapContext<NoiseGeneratorSettings> settingsRegisterable) {
        settingsRegisterable.register(BETA, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.BETA, 64, true));
        settingsRegisterable.register(ALPHA, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.ALPHA, 64, true));
        settingsRegisterable.register(SKYLANDS, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.SKYLANDS, 0, false));
        settingsRegisterable.register(INFDEV_611, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.INFDEV_611, 64, true));
        settingsRegisterable.register(INFDEV_420, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.INFDEV_420, 64, true));
        settingsRegisterable.register(INFDEV_415, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.INFDEV_415, 64, true));
        settingsRegisterable.register(INFDEV_227, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.INFDEV_227, 64, true));
        settingsRegisterable.register(INDEV, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.INDEV, 64, false));
        settingsRegisterable.register(CLASSIC_0_30, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.CLASSIC_0_30, 64, false));
        settingsRegisterable.register(PE, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.PE, 64, true));
        settingsRegisterable.register(EARLY_RELEASE, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.EARLY_RELEASE, 63, true));
        settingsRegisterable.register(MAJOR_RELEASE, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.MAJOR_RELEASE, 63, true));
        settingsRegisterable.register(EARLY_BEDROCK, (Object)ModernBetaChunkGeneratorSettings.createGeneratorSettings(settingsRegisterable, ModernBetaShapeConfigs.EARLY_BEDROCK, 63, true));
    }

    private static NoiseRouter createDensityFunctions(HolderGetter<DensityFunction> densityFunctionLookup, HolderGetter<NormalNoise.NoiseParameters> noiseParametersLookup) {
        Holder.Reference aquiferBarrier = noiseParametersLookup.getOrThrow(Noises.AQUIFER_BARRIER);
        Holder.Reference aquiferFloodedness = noiseParametersLookup.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_FLOODEDNESS);
        Holder.Reference aquiferSpread = noiseParametersLookup.getOrThrow(Noises.AQUIFER_FLUID_LEVEL_SPREAD);
        Holder.Reference aquiferLava = noiseParametersLookup.getOrThrow(Noises.AQUIFER_LAVA);
        Holder.Reference caveEntranceNoise = noiseParametersLookup.getOrThrow(Noises.CAVE_ENTRANCE);
        DensityFunction functionAquiferBarrier = DensityFunctions.noise((Holder)aquiferBarrier, (double)0.5);
        DensityFunction functionAquiferFloodedness = DensityFunctions.noise((Holder)aquiferFloodedness, (double)0.67);
        DensityFunction functionAquiferSpread = DensityFunctions.noise((Holder)aquiferSpread, (double)0.7142857142857143);
        DensityFunction functionAquiferLava = DensityFunctions.noise((Holder)aquiferLava);
        DensityFunction functionCaveEntranceNoise = DensityFunctions.noise((Holder)caveEntranceNoise);
        DensityFunction functionSlopedCheeseEstimate = DensityFunctions.add((DensityFunction)DensityFunctions.yClampedGradient((int)0, (int)64, (double)3.0, (double)1.0), (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)-0.5), (DensityFunction)functionCaveEntranceNoise));
        DensityFunction functionCaveEntrances = DensityFunctions.min((DensityFunction)functionSlopedCheeseEstimate, (DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.constant((double)5.0), (DensityFunction)new DensityFunctions.HolderHolder((Holder)densityFunctionLookup.getOrThrow(AccessorDensityFunctions.getCavesEntrancesOverworldKey()))));
        DensityFunction functionCaves = DensityFunctions.rangeChoice((DensityFunction)functionSlopedCheeseEstimate, (double)-1000000.0, (double)1.5625, (DensityFunction)functionCaveEntrances, (DensityFunction)AccessorDensityFunctions.invokeCreateCavesFunction(densityFunctionLookup, noiseParametersLookup, functionSlopedCheeseEstimate));
        DensityFunction functionCavesWithNoodles = DensityFunctions.min((DensityFunction)AccessorDensityFunctions.invokeApplyBlendDensity(AccessorDensityFunctions.invokeApplySurfaceSlides(false, functionCaves)), (DensityFunction)new DensityFunctions.HolderHolder((Holder)densityFunctionLookup.getOrThrow(AccessorDensityFunctions.getCavesNoodleOverworldKey())));
        return new NoiseRouter(functionAquiferBarrier, functionAquiferFloodedness, functionAquiferSpread, functionAquiferLava, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero(), functionCavesWithNoodles, DensityFunctions.zero(), DensityFunctions.zero(), DensityFunctions.zero());
    }

    private static NoiseGeneratorSettings createGeneratorSettings(BootstrapContext<NoiseGeneratorSettings> settingsRegisterable, NoiseSettings shapeConfig, int seaLevel, boolean useAquifers) {
        HolderGetter densityFunctionLookup = settingsRegisterable.lookup(Registries.DENSITY_FUNCTION);
        HolderGetter noiseParametersLookup = settingsRegisterable.lookup(Registries.NOISE);
        useModernBetaSurfaceRules = true;
        SurfaceRules.RuleSource materialRule = SurfaceRuleData.overworld();
        useModernBetaSurfaceRules = false;
        return new NoiseGeneratorSettings(shapeConfig, BlockStates.STONE, BlockStates.WATER, ModernBetaChunkGeneratorSettings.createDensityFunctions((HolderGetter<DensityFunction>)densityFunctionLookup, (HolderGetter<NormalNoise.NoiseParameters>)noiseParametersLookup), materialRule, List.of(), seaLevel, false, useAquifers, false, true);
    }

    public static boolean useModernBetaSurfaceRules() {
        return useModernBetaSurfaceRules;
    }

    static {
        BETA = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.BETA.id);
        ALPHA = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.ALPHA.id);
        SKYLANDS = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.SKYLANDS.id);
        INFDEV_611 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.INFDEV_611.id);
        INFDEV_420 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.INFDEV_420.id);
        INFDEV_415 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.INFDEV_415.id);
        INFDEV_227 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.INFDEV_227.id);
        INDEV = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.INDEV.id);
        CLASSIC_0_30 = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.CLASSIC_0_30.id);
        PE = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.PE.id);
        EARLY_RELEASE = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id);
        MAJOR_RELEASE = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.MAJOR_RELEASE.id);
        EARLY_BEDROCK = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ModernBetaBuiltInTypes.Chunk.EARLY_BEDROCK.id);
    }
}

