/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk.provider;

import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderFinite;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.FiniteBeaches;
import mod.bluestaggo.modernerbeta.settings.component.FiniteCaveGeneration;
import mod.bluestaggo.modernerbeta.settings.component.FiniteNoise;
import mod.bluestaggo.modernerbeta.settings.component.FinitePools;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoiseCombined;
import mod.bluestaggo.modernerbeta.world.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;

public class ChunkProviderClassic030
extends ChunkProviderFinite {
    private PerlinOctaveNoiseCombined minHeightOctaveNoise;
    private PerlinOctaveNoiseCombined maxHeightOctaveNoise;
    private PerlinOctaveNoise mainHeightOctaveNoise;
    private PerlinOctaveNoise dirtOctaveNoise;
    private PerlinOctaveNoiseCombined erodeOctaveNoise0;
    private PerlinOctaveNoiseCombined erodeOctaveNoise1;
    private PerlinOctaveNoise sandOctaveNoise;
    private PerlinOctaveNoise gravelOctaveNoise;
    private final int waterLevel;

    public ChunkProviderClassic030(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.waterLevel = this.levelHeight / 2;
    }

    @Override
    protected void pregenerateTerrain() {
        this.generateHeightmap(this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_NOISE));
        this.erodeTerrain();
        this.soilTerrain();
        this.carveTerrain(this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_CAVE_GENERATION));
        FinitePools poolSettings = this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_POOLS);
        this.floodFluid(poolSettings);
        this.floodLava(poolSettings);
        this.growSurface(this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_BEACHES));
    }

    @Override
    protected void generateBorder(ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    pos.set(x, y, z);
                    if (y < this.waterLevel - 2) {
                        VersionCompat.setBlockState(chunk, (BlockPos)pos, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y >= this.waterLevel) continue;
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, this.defaultFluid);
                }
            }
        }
    }

    @Override
    protected BlockState postProcessTerrainState(Block block, BlockSourceRules blockSources, ChunkProviderFinite.TerrainState terrainState, BlockPos pos, int topY) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        BlockState blockState = block.defaultBlockState();
        BlockState modifiedBlockState = blockSources.apply(x, y, z);
        boolean inFluid = modifiedBlockState.isAir() || modifiedBlockState.is(this.getLevelFluidBlock());
        int runDepth = terrainState.getRunDepth();
        if (!blockState.equals((Object)modifiedBlockState)) {
            terrainState.terrainModified();
        }
        if (terrainState.isTerrainModified() && !inFluid) {
            if (runDepth == 0) {
                BlockState blockState2 = modifiedBlockState = y >= this.waterLevel - 1 ? BlockStates.GRASS_BLOCK : BlockStates.DIRT;
            }
            if (runDepth == 1) {
                modifiedBlockState = BlockStates.DIRT;
            }
            terrainState.incrementRunDepth();
        }
        return modifiedBlockState;
    }

    @Override
    protected void generateBedrock(ChunkAccess chunk, Block block, BlockPos pos) {
        int y = pos.getY();
        if (y == 0) {
            VersionCompat.setBlockState(chunk, pos, BlockStates.BEDROCK);
        }
    }

    @Override
    protected BlockState postProcessSurfaceState(BlockState blockState, SurfaceConfig surfaceConfig, BlockPos pos, boolean isCold) {
        BlockState topBlock = surfaceConfig.normal().topBlock();
        BlockState fillerBlock = surfaceConfig.normal().fillerBlock();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (blockState.is(BlockStates.GRASS_BLOCK.getBlock())) {
            blockState = topBlock;
        } else if (blockState.is(BlockStates.DIRT.getBlock())) {
            blockState = fillerBlock;
        }
        if (!this.inWorldBounds(x, z)) {
            if (y == this.waterLevel) {
                if (isCold && blockState.equals((Object)topBlock)) {
                    blockState = (BlockState)topBlock.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true));
                }
            } else if (y == this.waterLevel - 1 && isCold && blockState.equals((Object)BlockStates.WATER)) {
                blockState = BlockStates.ICE;
            }
        }
        return blockState;
    }

    private void generateHeightmap(FiniteNoise noiseScale) {
        this.setPhase("Raising");
        this.minHeightOctaveNoise = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        this.maxHeightOctaveNoise = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        this.mainHeightOctaveNoise = new PerlinOctaveNoise(this.random, noiseScale.selectorOctaves(), false);
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                double heightResult;
                double heightLow = this.minHeightOctaveNoise.sample((float)x * noiseScale.heightNoiseScale(), (float)z * noiseScale.heightNoiseScale()) / (double)noiseScale.minHeightDamp() + (double)noiseScale.minHeightBoost();
                double heightHigh = this.maxHeightOctaveNoise.sample((float)x * noiseScale.heightNoiseScale(), (float)z * noiseScale.heightNoiseScale()) / (double)noiseScale.maxHeightDamp() + (double)noiseScale.maxHeightBoost();
                double heightSelector = this.mainHeightOctaveNoise.sampleXY((float)x * noiseScale.selectorScale(), (float)z * noiseScale.selectorScale()) / 8.0;
                if (heightSelector > 0.0) {
                    heightHigh = heightLow;
                }
                if ((heightResult = Math.max(heightLow, heightHigh) / 2.0) < 0.0) {
                    heightResult /= (double)noiseScale.heightUnderDamp();
                }
                this.heightmap[x + z * this.levelWidth] = (int)heightResult;
            }
        }
    }

    private void erodeTerrain() {
        this.setPhase("Eroding");
        this.erodeOctaveNoise0 = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        this.erodeOctaveNoise1 = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                int erodeNoise;
                double erodeSelector = this.erodeOctaveNoise0.sample(x << 1, z << 1) / 8.0;
                int n = erodeNoise = this.erodeOctaveNoise1.sample(x << 1, z << 1) > 0.0 ? 1 : 0;
                if (!(erodeSelector > 2.0)) continue;
                int heightResult = this.heightmap[x + z * this.levelWidth];
                this.heightmap[x + z * this.levelWidth] = heightResult = ((heightResult - erodeNoise) / 2 << 1) + erodeNoise;
            }
        }
    }

    private void soilTerrain() {
        this.setPhase("Soiling");
        this.dirtOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                int dirtThickness = (int)(this.dirtOctaveNoise.sampleXY(x, z) / 24.0) - 4;
                int dirtThreshold = this.heightmap[x + z * this.levelWidth] + this.waterLevel;
                int stoneThreshold = dirtThickness + dirtThreshold;
                this.heightmap[x + z * this.levelWidth] = Math.max(dirtThreshold, stoneThreshold);
                if (this.heightmap[x + z * this.levelWidth] > this.levelHeight - 2) {
                    this.heightmap[x + z * this.levelWidth] = this.levelHeight - 2;
                }
                if (this.heightmap[x + z * this.levelWidth] < 1) {
                    this.heightmap[x + z * this.levelWidth] = 1;
                }
                for (int y = 0; y < this.levelHeight; ++y) {
                    Block block = Blocks.AIR;
                    if (y <= dirtThreshold) {
                        block = Blocks.DIRT;
                    }
                    if (y <= stoneThreshold) {
                        block = Blocks.STONE;
                    }
                    if (y == 1) {
                        block = Blocks.LAVA;
                    }
                    this.setLevelBlock(x, y, z, block);
                }
            }
        }
    }

    private void carveTerrain(FiniteCaveGeneration caveSettings) {
        if (!caveSettings.useCaves()) {
            return;
        }
        this.setPhase("Carving");
        int caveCount = this.levelWidth * this.levelLength * this.levelHeight / caveSettings.rarity();
        for (int i = 0; i < caveCount; ++i) {
            float caveX = this.random.nextFloat() * (float)this.levelWidth;
            float caveY = this.random.nextFloat() * (float)this.levelHeight;
            float caveZ = this.random.nextFloat() * (float)this.levelLength;
            int caveLen = (int)((this.random.nextFloat() + this.random.nextFloat()) * caveSettings.length());
            float theta = this.random.nextFloat() * (float)Math.PI * 2.0f;
            float deltaTheta = 0.0f;
            float phi = this.random.nextFloat() * (float)Math.PI * 2.0f;
            float deltaPhi = 0.0f;
            float caveRadius = this.random.nextFloat() * this.random.nextFloat() * this.caveRadius;
            for (int len = 0; len < caveLen; ++len) {
                caveX += Mth.sin((float)theta) * Mth.cos((float)phi);
                caveZ += Mth.cos((float)theta) * Mth.cos((float)phi);
                caveY += Mth.sin((float)phi);
                theta += deltaTheta * 0.2f;
                deltaTheta = deltaTheta * 0.9f + (this.random.nextFloat() - this.random.nextFloat());
                if (caveSettings.use14aCaves()) {
                    phi = phi * 0.5f + deltaPhi * 0.5f;
                    deltaPhi = deltaPhi * 0.9f + (this.random.nextFloat() - this.random.nextFloat());
                    float radius = Mth.sin((float)((float)len * (float)Math.PI / (float)caveLen)) * 2.5f + 1.0f;
                    this.fillOblateSpheroid(caveX, caveY, caveZ, radius, Blocks.AIR);
                    continue;
                }
                phi = phi * 0.5f + deltaPhi * 0.25f;
                deltaPhi = deltaPhi * 0.75f + (this.random.nextFloat() - this.random.nextFloat());
                if (!(this.random.nextFloat() >= 0.25f)) continue;
                float centerX = caveX + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerY = caveY + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerZ = caveZ + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float radius = ((float)this.levelHeight - centerY) / (float)this.levelHeight;
                radius = 1.2f + (radius * 3.5f + 1.0f) * caveRadius;
                this.fillOblateSpheroid(centerX, centerY, centerZ, radius *= Mth.sin((float)((float)len * (float)Math.PI / (float)caveLen)), Blocks.AIR);
            }
        }
    }

    private void floodFluid(FinitePools poolSettings) {
        this.setPhase("Watering");
        Block fluid = this.defaultFluid.getBlock();
        for (int x = 0; x < this.levelWidth; ++x) {
            this.flood(x, this.waterLevel - 1, 0, fluid);
            this.flood(x, this.waterLevel - 1, this.levelLength - 1, fluid);
        }
        for (int z = 0; z < this.levelLength; ++z) {
            this.flood(this.levelWidth - 1, this.waterLevel - 1, z, fluid);
            this.flood(0, this.waterLevel - 1, z, fluid);
        }
        int waterSourceCount = this.levelWidth * this.levelLength / poolSettings.waterRarity();
        for (int i = 0; i < waterSourceCount; ++i) {
            int randX = this.random.nextInt(this.levelWidth);
            int randZ = this.random.nextInt(this.levelLength);
            int randY = this.waterLevel - 1 - this.random.nextInt(poolSettings.uniformLavaHeights() ? 3 : 2);
            this.flood(randX, randY, randZ, fluid);
        }
    }

    private void floodLava(FinitePools poolSettings) {
        this.setPhase("Melting");
        int lavaSourceCount = this.levelWidth * this.levelLength / poolSettings.lavaRarity();
        for (int i = 0; i < lavaSourceCount; ++i) {
            int randX = this.random.nextInt(this.levelWidth);
            int randZ = this.random.nextInt(this.levelLength);
            int randY = poolSettings.uniformLavaHeights() ? this.random.nextInt(this.waterLevel - 4) : (int)((float)(this.waterLevel - 3) * this.random.nextFloat() * this.random.nextFloat());
            this.flood(randX, randY, randZ, Blocks.LAVA);
        }
    }

    private void growSurface(FiniteBeaches beachSettings) {
        this.setPhase("Growing");
        this.sandOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        this.gravelOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                boolean genSand = this.sandOctaveNoise.sampleXY(x, z) > (double)beachSettings.sandThreshold();
                boolean genGravel = this.gravelOctaveNoise.sampleXY(x, z) > (double)beachSettings.gravelThreshold();
                int heightResult = this.heightmap[x + z * this.levelWidth];
                Block blockUp = this.getLevelBlock(x, heightResult + 1, z);
                genSand &= heightResult <= this.waterLevel - 1 && (beachSettings.sandUnderAir() && blockUp == Blocks.AIR || beachSettings.sandUnderFluid() && blockUp == this.defaultFluid.getBlock());
                if ((genGravel &= heightResult <= this.waterLevel - 1 && (beachSettings.gravelUnderAir() && blockUp == Blocks.AIR || beachSettings.gravelUnderFluid() && blockUp == this.defaultFluid.getBlock())) && beachSettings.prioritizeGravelBeaches()) {
                    genSand = false;
                }
                Block surfaceBlock = genSand ? Blocks.SAND : (genGravel ? Blocks.GRAVEL : (blockUp == this.defaultFluid.getBlock() ? Blocks.DIRT : Blocks.GRASS_BLOCK));
                this.setLevelBlock(x, heightResult, z, surfaceBlock);
            }
        }
    }
}

