/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk.provider;

import java.util.Random;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceBlocks;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.spawn.SpawnLocatorBeta;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;

public class ChunkProviderInfdev415
extends ChunkProviderNoise {
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise beachOctaveNoise;
    private final PerlinOctaveNoise surfaceOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;

    public ChunkProviderInfdev415(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        this.beachOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        this.surfaceOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        new PerlinOctaveNoise(this.random, 5, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 5, true);
    }

    @Override
    public SpawnLocator getSpawnLocator() {
        return new SpawnLocatorBeta(this, this.beachOctaveNoise, new Random(this.seed));
    }

    @Override
    public void provideSurface(WorldGenRegion region, StructureManager structureAccessor, ChunkAccess chunk, ModernBetaBiomeSource biomeSource, RandomState noiseConfig) {
        double scale = 0.03125;
        ChunkPos chunkPos = chunk.getPos();
        int chunkX = chunkPos.x;
        int chunkZ = chunkPos.z;
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        Random bedrockRand = this.createSurfaceRandom(chunkX, chunkZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Aquifer aquiferSampler = this.getAquiferSampler(chunk, noiseConfig);
        ChunkHeightmap heightmapChunk = this.getChunkHeightmap((LevelHeightAccessor)region, chunkX, chunkZ);
        SimpleNoisePos noisePos = new SimpleNoisePos();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG).getFirstAvailable(localX, localZ) - 1;
                int surfaceMinY = this.hasNoisePostProcessor() ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) - 8 : this.worldMinY;
                boolean genSandBeach = this.beachOctaveNoise.sample((double)x * scale, (double)z * scale, 0.0) + rand.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.beachOctaveNoise.sample((double)z * scale, 109.0134, (double)x * scale) + rand.nextDouble() * 0.2 > 3.0;
                double surfaceNoise = this.surfaceOctaveNoise.sampleXY((double)x * scale * 2.0, (double)z * scale * 2.0);
                int surfaceDepth = (int)(surfaceNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int runDepth = -1;
                Holder<Biome> biome = biomeSource.getBiomeForSurfaceGen(region, (BlockPos)pos.set(x, surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                BlockState topBlock = surfaceConfig.normal().topBlock();
                BlockState fillerBlock = surfaceConfig.normal().fillerBlock();
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    pos.set(localX, y, localZ);
                    BlockState blockState = chunk.getBlockState((BlockPos)pos);
                    if (y <= this.bedrockFloor + bedrockRand.nextInt(5)) {
                        VersionCompat.setBlockState(chunk, (BlockPos)pos, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y < surfaceMinY) continue;
                    if (blockState.isAir()) {
                        runDepth = -1;
                        continue;
                    }
                    if (!blockState.is(this.defaultBlock.getBlock())) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        } else if (y >= this.seaLevel - 4 && y <= this.seaLevel + 1) {
                            topBlock = surfaceConfig.normal().topBlock();
                            fillerBlock = surfaceConfig.normal().fillerBlock();
                            if (genGravelBeach) {
                                topBlock = surfaceConfig.beachGravel().topBlock();
                                fillerBlock = surfaceConfig.beachGravel().fillerBlock();
                            }
                            if (genSandBeach) {
                                topBlock = surfaceConfig.beachSand().topBlock();
                                fillerBlock = surfaceConfig.beachSand().fillerBlock();
                            }
                        }
                        runDepth = surfaceDepth;
                        if (y < this.seaLevel && topBlock.isAir()) {
                            BlockState fluidBlock = aquiferSampler.computeSubstance((DensityFunction.FunctionContext)noisePos.set(x, y, z), 0.0);
                            boolean isAir = fluidBlock == null;
                            topBlock = isAir ? BlockStates.AIR : fluidBlock;
                            this.scheduleFluidTick(chunk, aquiferSampler, (BlockPos)pos, topBlock);
                        }
                        blockState = y >= this.seaLevel - 1 || y < this.seaLevel - 1 && chunk.getBlockState(pos.above()).isAir() ? topBlock : fillerBlock;
                        VersionCompat.setBlockState(chunk, (BlockPos)pos, blockState);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    --runDepth;
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, fillerBlock);
                }
            }
        }
    }

    @Override
    public void provideSurfaceExtra(WorldGenRegion region, StructureManager structureAccessor, ChunkAccess chunk, ModernBetaBiomeSource biomeSource, RandomState noiseConfig) {
        double scale = 0.03125;
        ChunkPos chunkPos = chunk.getPos();
        int chunkX = chunkPos.x;
        int chunkZ = chunkPos.z;
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        ChunkHeightmap heightmapChunk = this.hasNoisePostProcessor() ? this.getChunkHeightmap((LevelHeightAccessor)region, chunkX, chunkZ) : null;
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                SurfaceBlocks beach;
                pos.set(localX, 0, localZ);
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = heightmapChunk != null ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) : chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG).getFirstAvailable(localX, localZ);
                boolean genSandBeach = this.beachOctaveNoise.sample((double)x * scale, (double)z * scale, 0.0) + rand.nextDouble() * 0.2 > 0.0;
                boolean genGravelBeach = this.beachOctaveNoise.sample((double)z * scale, 109.0134, (double)x * scale) + rand.nextDouble() * 0.2 > 3.0;
                int surfaceDepth = (int)(this.surfaceOctaveNoise.sampleXY((double)x * scale * 2.0, (double)z * scale * 2.0) / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                Holder<Biome> biome = biomeSource.getBiomeForSurfaceGen(region, (BlockPos)pos.set(x, --surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                int y = surfaceTopY;
                pos.setY(y);
                if (!this.isBlockSuitableForSurface(chunk.getBlockState((BlockPos)pos))) continue;
                if (surfaceDepth <= 0) {
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, y < this.seaLevel ? this.defaultFluid : BlockStates.AIR);
                    pos.setY(--y);
                    while (this.isBlockSuitableForSurface(chunk.getBlockState((BlockPos)pos))) {
                        VersionCompat.setBlockState(chunk, (BlockPos)pos, this.defaultBlock);
                        pos.setY(--y);
                    }
                    continue;
                }
                if (surfaceTopY < this.seaLevel - 4 || surfaceTopY >= this.seaLevel + 1) continue;
                SurfaceBlocks surfaceBlocks = genSandBeach ? surfaceConfig.beachSand() : (beach = genGravelBeach ? surfaceConfig.beachGravel() : null);
                if (beach == null) continue;
                if (beach.topBlock().isAir() && y < this.seaLevel) {
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, this.defaultFluid);
                } else {
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, beach.topBlock());
                }
                pos.setY(--y);
                while (this.isBlockSuitableForSurface(chunk.getBlockState((BlockPos)pos))) {
                    VersionCompat.setBlockState(chunk, (BlockPos)pos, beach.fillerBlock());
                    pos.setY(--y);
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] primaryBuffer, double[] heightmapBuffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double islandOffset = this.getIslandOffset(noiseX, noiseZ);
        double coordinateScale = this.noiseScale.coordinate();
        double heightScale = this.noiseScale.height();
        double mainNoiseScaleX = this.noiseScale.mainNoiseX();
        double mainNoiseScaleY = this.noiseScale.mainNoiseY();
        double mainNoiseScaleZ = this.noiseScale.mainNoiseZ();
        double lowerLimitScale = this.noiseScale.lowerLimit();
        double upperLimitScale = this.noiseScale.upperLimit();
        for (int y = 0; y < primaryBuffer.length; ++y) {
            double density;
            int noiseY = y + this.noiseMinY;
            double densityOffset = this.getOffset(noiseY);
            double mainNoiseVal = this.mainOctaveNoise.sample((double)noiseX * coordinateScale / mainNoiseScaleX, (double)noiseY * coordinateScale / mainNoiseScaleY, (double)noiseZ * coordinateScale / mainNoiseScaleZ) / 2.0;
            if (mainNoiseVal < -1.0) {
                density = this.minLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / lowerLimitScale;
                density -= densityOffset;
                density += islandOffset;
                density = this.clampNoise(density);
            } else if (mainNoiseVal > 1.0) {
                density = this.maxLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / upperLimitScale;
                density -= densityOffset;
                density += islandOffset;
                density = this.clampNoise(density);
            } else {
                double minLimitVal = this.minLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / lowerLimitScale;
                double maxLimitVal = this.maxLimitOctaveNoise.sample((double)noiseX * coordinateScale, (double)noiseY * heightScale, (double)noiseZ * coordinateScale) / upperLimitScale;
                minLimitVal -= densityOffset;
                maxLimitVal -= densityOffset;
                minLimitVal += islandOffset;
                maxLimitVal += islandOffset;
                minLimitVal = this.clampNoise(minLimitVal);
                maxLimitVal = this.clampNoise(maxLimitVal);
                double delta = (mainNoiseVal + 1.0) / 2.0;
                density = minLimitVal + (maxLimitVal - minLimitVal) * delta;
            }
            double heightmapDensity = density;
            density = this.sampleNoisePostProcessor(density, noiseX, noiseY, noiseZ);
            density = this.applySlides(density, y);
            heightmapDensity = this.applySlides(heightmapDensity, y);
            primaryBuffer[y] = density;
            heightmapBuffer[y] = heightmapDensity;
        }
    }

    @Override
    protected PerlinOctaveNoise getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    private double clampNoise(double density) {
        if (this.hasNoisePostProcessor()) {
            return density;
        }
        return Mth.clamp((double)density, (double)-10.0, (double)10.0);
    }

    private double getOffset(int noiseY) {
        double offset = (double)(noiseY * this.noiseResolutionVertical) - (double)this.seaLevel;
        if (offset < 0.0) {
            offset *= 3.0;
        }
        return offset;
    }
}

