/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.feature;

import com.mojang.serialization.Codec;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.mixin.AccessorBiome;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class BetaFreezeTopLayerFeature
extends Feature<NoneFeatureConfiguration> {
    public BetaFreezeTopLayerFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        BiomeSource biomeSource = chunkGenerator.getBiomeSource();
        BetaFreezeTopLayerFeature.setFreezeTopLayer(world, pos, biomeSource, false);
        return true;
    }

    public static void setFreezeTopLayer(WorldGenLevel world, BlockPos pos, BiomeSource biomeSource, boolean modernHeightSnow) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableDown = new BlockPos.MutableBlockPos();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = pos.getX() + localX;
                int z = pos.getZ() + localZ;
                int y = world.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
                mutable.set(x, y, z);
                mutableDown.set((Vec3i)mutable).move(Direction.DOWN, 1);
                TemperatureHeightScaling heightType = TemperatureHeightScaling.NONE;
                double temp = ((Biome)world.getBiome((BlockPos)mutable).value()).getBaseTemperature();
                double coldThreshold = 0.15;
                Biome.TemperatureModifier temperatureModifier = ((AccessorBiome)world.getBiome((BlockPos)mutable).value()).getWeather().temperatureModifier();
                if (biomeSource instanceof ModernBetaBiomeSource) {
                    ClimateSampler climateSampler;
                    ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)biomeSource;
                    heightType = modernBetaBiomeSource.getBiomeProvider().getTemperatureHeightScaling();
                    BiomeProvider biomeProvider = modernBetaBiomeSource.getBiomeProvider();
                    if (biomeProvider instanceof ClimateSampler && (climateSampler = (ClimateSampler)((Object)biomeProvider)).useBiomeFeature()) {
                        temp = climateSampler.sampleModifiedTemperature((BlockPos)mutable, temperatureModifier);
                        coldThreshold = climateSampler.getSnowThreshold();
                    } else if (heightType.supportsModifier(temperatureModifier)) {
                        temp = temperatureModifier.modifyTemperature((BlockPos)mutable, (float)temp);
                    }
                }
                if (modernHeightSnow) {
                    heightType = TemperatureHeightScaling.MAJOR_RELEASE;
                }
                if (BetaFreezeTopLayerFeature.canSetIce((LevelReader)world, (BlockPos)mutableDown, false, temp, coldThreshold, heightType)) {
                    world.setBlock((BlockPos)mutableDown, Blocks.ICE.defaultBlockState(), 2);
                }
                if (!BetaFreezeTopLayerFeature.canSetSnow((LevelReader)world, (BlockPos)mutable, temp, coldThreshold, heightType)) continue;
                world.setBlock((BlockPos)mutable, Blocks.SNOW.defaultBlockState(), 2);
                BlockState blockState = world.getBlockState((BlockPos)mutableDown);
                if (!blockState.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                world.setBlock((BlockPos)mutableDown, (BlockState)blockState.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public static boolean canSetIce(LevelReader worldView, BlockPos blockPos, boolean doWaterCheck, double temp, double coldThreshold, TemperatureHeightScaling heightType) {
        if (heightType.modifyTemperature(blockPos, temp) >= coldThreshold) {
            return false;
        }
        if (blockPos.getY() >= worldView.getMinY() && blockPos.getY() < VersionCompat.getTopYExclusive((LevelHeightAccessor)worldView) && worldView.getBrightness(LightLayer.BLOCK, blockPos) < 10) {
            BlockState blockState = worldView.getBlockState(blockPos);
            FluidState fluidState = worldView.getFluidState(blockPos);
            if (fluidState.getType() == Fluids.WATER && blockState.getBlock() instanceof LiquidBlock) {
                boolean submerged;
                if (!doWaterCheck) {
                    return true;
                }
                boolean bl = submerged = worldView.isWaterAt(blockPos.west()) && worldView.isWaterAt(blockPos.east()) && worldView.isWaterAt(blockPos.north()) && worldView.isWaterAt(blockPos.south());
                if (!submerged) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean canSetSnow(LevelReader worldView, BlockPos blockPos, double temp, double coldThreshold, TemperatureHeightScaling heightType) {
        BlockState blockState;
        if (heightType.modifyTemperature(blockPos, temp) >= coldThreshold) {
            return false;
        }
        return blockPos.getY() >= 0 && blockPos.getY() < 256 && worldView.getBrightness(LightLayer.BLOCK, blockPos) < 10 && (blockState = worldView.getBlockState(blockPos)).isAir() && Blocks.SNOW.defaultBlockState().canSurvive(worldView, blockPos);
    }
}

