/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.feature.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.feature.ModernBetaFoliagePlacers;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class Oak14a08FoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<Oak14a08FoliagePlacer> CODEC = VersionCompat.createMaybeMapCodec(instance -> Oak14a08FoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(placer -> placer.height)).apply((Applicative)instance, Oak14a08FoliagePlacer::new));
    private final int height;

    public Oak14a08FoliagePlacer(IntProvider radius, IntProvider offset, int height) {
        super(radius, offset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return ModernBetaFoliagePlacers.OAK_14A_08_FOLIAGE_PLACER;
    }

    protected void createFoliage(LevelSimulatedReader world, FoliagePlacer.FoliageSetter placer, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment treeNode, int foliageHeight, int radius, int offset) {
        for (int y = offset; y >= offset - foliageHeight; --y) {
            this.placeLeavesRow(world, placer, random, config, treeNode.pos(), radius, y, treeNode.doubleTrunk());
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return y == 0 && Math.abs(dx) + Math.abs(dz) >= radius * 2;
    }
}

