/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.feature.placed;

import java.util.List;
import mod.bluestaggo.modernerbeta.world.feature.configured.ModernBetaOreConfiguredFeatures;
import mod.bluestaggo.modernerbeta.world.feature.placed.ModernBetaPlacedFeatures;
import mod.bluestaggo.modernerbeta.world.feature.placement.Infdev325CavePlacementModifier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModernBetaOrePlacedFeatures {
    public static final ResourceKey<PlacedFeature> ORE_CLAY = ModernBetaPlacedFeatures.of("ore_clay");
    public static final ResourceKey<PlacedFeature> ORE_EMERALD_Y95 = ModernBetaPlacedFeatures.of("ore_emerald_y95");
    public static final ResourceKey<PlacedFeature> CAVE_INFDEV_325 = ModernBetaPlacedFeatures.of("cave_infdev_325");

    public static void bootstrap(BootstrapContext<PlacedFeature> featureRegisterable) {
        HolderGetter registryConfigured = featureRegisterable.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference oreClay = registryConfigured.getOrThrow(ModernBetaOreConfiguredFeatures.ORE_CLAY);
        Holder.Reference oreEmeraldY95 = registryConfigured.getOrThrow(ModernBetaOreConfiguredFeatures.ORE_EMERALD_Y95);
        Holder.Reference caveInfdev325 = registryConfigured.getOrThrow(ModernBetaOreConfiguredFeatures.CAVE_INFDEV_325);
        PlacementUtils.register(featureRegisterable, ORE_CLAY, (Holder)oreClay, ModernBetaOrePlacedFeatures.modifiersWithCount(33, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)127))));
        PlacementUtils.register(featureRegisterable, ORE_EMERALD_Y95, (Holder)oreEmeraldY95, ModernBetaOrePlacedFeatures.modifiersWithCount(11, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)95), (VerticalAnchor)VerticalAnchor.top())));
        PlacementUtils.register(featureRegisterable, CAVE_INFDEV_325, (Holder)caveInfdev325, (PlacementModifier[])new PlacementModifier[]{Infdev325CavePlacementModifier.of(-4, 15), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.allOf((BlockPredicate[])new BlockPredicate[]{BlockPredicate.noFluid((Vec3i)new Vec3i(0, 0, 0)), BlockPredicate.noFluid((Vec3i)new Vec3i(4, 4, 4)), BlockPredicate.noFluid((Vec3i)new Vec3i(4, 4, -4)), BlockPredicate.noFluid((Vec3i)new Vec3i(-4, 4, 4)), BlockPredicate.noFluid((Vec3i)new Vec3i(-4, 4, -4)), BlockPredicate.noFluid((Vec3i)new Vec3i(4, -4, 4)), BlockPredicate.noFluid((Vec3i)new Vec3i(4, -4, -4)), BlockPredicate.noFluid((Vec3i)new Vec3i(-4, -4, 4)), BlockPredicate.noFluid((Vec3i)new Vec3i(-4, -4, -4))})), BiomeFilter.biome()});
    }

    private static List<PlacementModifier> modifiers(PlacementModifier first, PlacementModifier second) {
        return List.of(first, InSquarePlacement.spread(), second, BiomeFilter.biome());
    }

    private static List<PlacementModifier> modifiersWithCount(int count, PlacementModifier modifier) {
        return ModernBetaOrePlacedFeatures.modifiers((PlacementModifier)CountPlacement.of((int)count), modifier);
    }
}

