/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.feature.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.feature.placement.ModernBetaPlacementTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightmapSpreadDoublePlacementModifier
extends PlacementModifier {
    public static final MapCodec<HeightmapSpreadDoublePlacementModifier> MODIFIER_CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(arg -> arg.heightmap)).apply((Applicative)instance, HeightmapSpreadDoublePlacementModifier::of));
    private final Heightmap.Types heightmap;

    private HeightmapSpreadDoublePlacementModifier(Heightmap.Types heightmap) {
        this.heightmap = heightmap;
    }

    public static HeightmapSpreadDoublePlacementModifier of(Heightmap.Types heightmap) {
        return new HeightmapSpreadDoublePlacementModifier(heightmap);
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        int z;
        int x = pos.getX();
        int y = context.getHeight(this.heightmap, x, z = pos.getZ());
        if (y == context.getMinY()) {
            return Stream.of(new BlockPos[0]);
        }
        return Stream.of(new BlockPos(x, context.getMinY() + random.nextInt((y - context.getMinY()) * 2), z));
    }

    public PlacementModifierType<?> type() {
        return ModernBetaPlacementTypes.HEIGHTMAP_SPREAD_DOUBLE;
    }
}

