/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.feature.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.feature.ModernBetaTrunkPlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BetaLargeOakTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BetaLargeOakTrunkPlacer> CODEC = VersionCompat.createMaybeMapCodec(instance -> BetaLargeOakTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).and((App)Codec.BOOL.fieldOf("rotate_logs").forGetter(p -> p.rotateLogs)).apply((Applicative)instance, BetaLargeOakTrunkPlacer::new));
    private final boolean rotateLogs;
    private static final double HEIGHT_SCALE = 0.618;
    private static final double CLUSTER_DENSITY = 1.382;
    private static final double BRANCH_SLOPE = 0.381;
    private static final double BRANCH_LENGTH = 0.328;

    public BetaLargeOakTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, boolean rotateLogs) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.rotateLogs = rotateLogs;
    }

    protected TrunkPlacerType<?> type() {
        return ModernBetaTrunkPlacers.BETA_LARGE_OAK_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int height, BlockPos basePos, TreeConfiguration config) {
        int foliageHeight = 5;
        double branchDensity = 1.0;
        BetaLargeOakTrunkPlacer.setDirtAt((LevelSimulatedReader)world, replacer, (RandomSource)random, (BlockPos)basePos.below(), (TreeConfiguration)config);
        int treeHeight = Mth.floor((double)((double)height * 0.618));
        if (treeHeight >= height) {
            treeHeight = height - 1;
        }
        int foliageBlobCount = Math.min(1, (int)(1.382 + Math.pow(branchDensity * (double)height / 13.0, 2.0)));
        int foliageBaseY = basePos.getY() + height - foliageHeight;
        int treeTopY = basePos.getY() + treeHeight;
        int treeRelY = foliageBaseY - basePos.getY();
        ArrayList list = Lists.newArrayList();
        list.add(new BranchPosition(basePos.atY(foliageBaseY), treeTopY));
        --foliageBaseY;
        while (treeRelY >= 0) {
            float foliageDistance = this.getFoliageDistance(treeRelY, height);
            if (foliageDistance >= 0.0f) {
                for (int currentBlobCount = 0; currentBlobCount < foliageBlobCount; ++currentBlobCount) {
                    BlockPos endPos;
                    int randZ;
                    double randAngle;
                    double randRadius = branchDensity * (double)foliageDistance * ((double)random.nextFloat() + 0.328);
                    int randX = Mth.floor((double)(randRadius * Math.sin(randAngle = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5));
                    BlockPos startPos = basePos.offset(randX, treeRelY - 1, randZ = Mth.floor((double)(randRadius * Math.cos(randAngle) + 0.5)));
                    if (!this.makeOrCheckBranch(world, replacer, random, startPos, endPos = startPos.above(foliageHeight), false, config)) continue;
                    int xLength = Math.abs(basePos.getX() - startPos.getX());
                    int zLength = Math.abs(basePos.getZ() - startPos.getZ());
                    double distance = (double)startPos.getY() - Math.sqrt(xLength * xLength + zLength * zLength) * 0.381;
                    int endY = distance > (double)treeTopY ? treeTopY : (int)distance;
                    endPos = new BlockPos(basePos.getX(), endY, basePos.getZ());
                    if (!this.makeOrCheckBranch(world, replacer, random, endPos, startPos, false, config)) continue;
                    list.add(new BranchPosition(startPos, endPos.getY()));
                }
            }
            --foliageBaseY;
            --treeRelY;
        }
        this.makeOrCheckBranch(world, replacer, random, basePos, basePos.above(treeHeight), true, config);
        this.makeBranches(world, replacer, random, height, basePos, list, config);
        ArrayList nodes = Lists.newArrayList();
        for (BranchPosition branchPosition : list) {
            nodes.add(branchPosition.node);
        }
        return nodes;
    }

    public int getTreeHeight(RandomSource random) {
        return this.baseHeight + random.nextInt(this.heightRandA + 1);
    }

    private boolean makeOrCheckBranch(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, BlockPos startPos, BlockPos branchPos, boolean make, TreeConfiguration config) {
        if (!make && Objects.equals(startPos, branchPos)) {
            return true;
        }
        BlockPos startMinus = branchPos.offset(-startPos.getX(), -startPos.getY(), -startPos.getZ());
        int longestSide = this.getLongestSide(startMinus);
        float xM = (float)startMinus.getX() / (float)longestSide;
        float yM = (float)startMinus.getY() / (float)longestSide;
        float zM = (float)startMinus.getZ() / (float)longestSide;
        for (int i = 0; i <= longestSide; ++i) {
            BlockPos offset = startPos.offset(Mth.floor((float)((float)i * xM)), Mth.floor((float)((float)i * yM)), Mth.floor((float)((float)i * zM)));
            if (make) {
                this.placeLog(world, replacer, random, offset, config, state -> this.rotateLogs ? (BlockState)state.trySetValue((Property)RotatedPillarBlock.AXIS, (Comparable)this.getLogAxis(startPos, offset)) : state);
                continue;
            }
            if (this.isFree(world, offset)) continue;
            return false;
        }
        return true;
    }

    private int getLongestSide(BlockPos offset) {
        int x = Mth.abs((int)offset.getX());
        int y = Mth.abs((int)offset.getY());
        int z = Mth.abs((int)offset.getZ());
        return Math.max(x, Math.max(y, z));
    }

    private Direction.Axis getLogAxis(BlockPos branchStart, BlockPos branchEnd) {
        int distanceZ;
        Direction.Axis axis = Direction.Axis.Y;
        int distanceX = Math.abs(branchEnd.getX() - branchStart.getX());
        int maxDistance = Math.max(distanceX, distanceZ = Math.abs(branchEnd.getZ() - branchStart.getZ()));
        if (maxDistance > 0) {
            axis = distanceX == maxDistance ? Direction.Axis.X : Direction.Axis.Z;
        }
        return axis;
    }

    private boolean isHighEnough(int treeHeight, int height) {
        return (double)height >= (double)treeHeight * 0.2;
    }

    private void makeBranches(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int treeHeight, BlockPos startPos, List<BranchPosition> branchPositions, TreeConfiguration config) {
        for (BranchPosition branchPosition : branchPositions) {
            int endY = branchPosition.endY;
            BlockPos blockPos = new BlockPos(startPos.getX(), endY, startPos.getZ());
            if (blockPos.equals((Object)branchPosition.node.pos()) || !this.isHighEnough(treeHeight, endY - startPos.getY())) continue;
            this.makeOrCheckBranch(world, replacer, random, blockPos, branchPosition.node.pos(), true, config);
        }
    }

    private float getFoliageDistance(int treeRelY, int treeHeight) {
        if ((float)treeRelY < (float)treeHeight * 0.3f) {
            return -1.618f;
        }
        float radius = (float)treeHeight / 2.0f;
        float distFromRadius = radius - (float)treeRelY;
        float distance = Mth.sqrt((float)(radius * radius - distFromRadius * distFromRadius));
        if (distFromRadius == 0.0f) {
            distance = radius;
        } else if (Math.abs(distFromRadius) >= radius) {
            return 0.0f;
        }
        return distance * 0.5f;
    }

    record BranchPosition(FoliagePlacer.FoliageAttachment node, int endY) {
        public BranchPosition(BlockPos pos, int endY) {
            this(new FoliagePlacer.FoliageAttachment(pos, 0, false), endY);
        }
    }
}

