/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.preset;

import java.util.Map;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGeneratorSettings;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;

public class ModernBetaWorldPresets {
    public static final ResourceKey<WorldPreset> MODERN_BETA = ModernBetaWorldPresets.keyOf(ModernerBeta.createId("moderner_beta"));

    public static void bootstrap(BootstrapContext<WorldPreset> presetRegisterable) {
        HolderGetter registryDimensionType = presetRegisterable.lookup(Registries.DIMENSION_TYPE);
        HolderGetter registrySettings = presetRegisterable.lookup(Registries.NOISE_SETTINGS);
        HolderGetter registryBiome = presetRegisterable.lookup(Registries.BIOME);
        HolderGetter registryPreset = presetRegisterable.lookup(ModernBetaRegistryKeys.SETTINGS_PRESET);
        HolderGetter registryParameters = presetRegisterable.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST);
        LevelStem overworld = ModernBetaWorldPresets.createOverworldOptions((HolderGetter<DimensionType>)registryDimensionType, (HolderGetter<NoiseGeneratorSettings>)registrySettings, (HolderGetter<Biome>)registryBiome, (HolderGetter<ModernBetaSettingsPreset>)registryPreset);
        LevelStem nether = ModernBetaWorldPresets.createNetherOptions((HolderGetter<DimensionType>)registryDimensionType, (HolderGetter<NoiseGeneratorSettings>)registrySettings, (HolderGetter<MultiNoiseBiomeSourceParameterList>)registryParameters);
        LevelStem end = ModernBetaWorldPresets.createEndOptions((HolderGetter<DimensionType>)registryDimensionType, (HolderGetter<NoiseGeneratorSettings>)registrySettings, (HolderGetter<Biome>)registryBiome);
        presetRegisterable.register(MODERN_BETA, (Object)new WorldPreset(Map.of(LevelStem.OVERWORLD, overworld, LevelStem.NETHER, nether, LevelStem.END, end)));
    }

    private static LevelStem createOverworldOptions(HolderGetter<DimensionType> registryDimensionType, HolderGetter<NoiseGeneratorSettings> registrySettings, HolderGetter<Biome> registryBiome, HolderGetter<ModernBetaSettingsPreset> registryPreset) {
        Holder.Reference dimensionType = registryDimensionType.getOrThrow(BuiltinDimensionTypes.OVERWORLD);
        Holder.Reference settings = registrySettings.getOrThrow(ModernBetaChunkGeneratorSettings.BETA);
        ModernBetaSettingsPreset defaultPreset = ModernBetaSettingsPreset.referenced(ModernBetaSettings.DEFAULT_PRESET_ID);
        return new LevelStem((Holder)dimensionType, (ChunkGenerator)new ModernBetaChunkGenerator(new ModernBetaBiomeSource(registryBiome, registryPreset, defaultPreset.biomeSettings().toCompound(), defaultPreset.caveBiomeSettings().toCompound()), registryPreset, (Holder<NoiseGeneratorSettings>)settings, defaultPreset.chunkSettings().toCompound()));
    }

    private static LevelStem createNetherOptions(HolderGetter<DimensionType> registryDimensionType, HolderGetter<NoiseGeneratorSettings> registrySettings, HolderGetter<MultiNoiseBiomeSourceParameterList> registryParameters) {
        Holder.Reference dimensionType = registryDimensionType.getOrThrow(BuiltinDimensionTypes.NETHER);
        Holder.Reference settings = registrySettings.getOrThrow(NoiseGeneratorSettings.NETHER);
        Holder.Reference parameters = registryParameters.getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER);
        return new LevelStem((Holder)dimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)MultiNoiseBiomeSource.createFromPreset((Holder)parameters), (Holder)settings));
    }

    private static LevelStem createEndOptions(HolderGetter<DimensionType> registryDimensionType, HolderGetter<NoiseGeneratorSettings> registrySettings, HolderGetter<Biome> registryBiome) {
        Holder.Reference dimensionType = registryDimensionType.getOrThrow(BuiltinDimensionTypes.END);
        Holder.Reference settings = registrySettings.getOrThrow(NoiseGeneratorSettings.END);
        return new LevelStem((Holder)dimensionType, (ChunkGenerator)new NoiseBasedChunkGenerator((BiomeSource)TheEndBiomeSource.create(registryBiome), (Holder)settings));
    }

    private static ResourceKey<WorldPreset> keyOf(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (ResourceLocation)id);
    }
}

