/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.spawn;

import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderFinite;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.event.Level;

public class SpawnLocatorIndev
implements SpawnLocator {
    private final ChunkProviderFinite chunkProvider;

    public SpawnLocatorIndev(ChunkProviderFinite chunkProvider) {
        this.chunkProvider = chunkProvider;
    }

    @Override
    public Optional<BlockPos> locateSpawn(LevelHeightAccessor world) {
        int spawnZ;
        int spawnX;
        int spawnY;
        Random random = new Random();
        int attempts = 0;
        int width = this.chunkProvider.getLevelWidth();
        int length = this.chunkProvider.getLevelLength();
        do {
            spawnX = random.nextInt(width / 2) + width / 4;
            spawnZ = random.nextInt(length / 2) + length / 4;
            spawnY = this.chunkProvider.getHeight(world, spawnX - width / 2, spawnZ - length / 2, Heightmap.Types.OCEAN_FLOOR_WG) + 1;
            if (attempts >= 1000000) {
                ModernerBeta.log(Level.INFO, "[Indev] Exceeded spawn attempts, spawning anyway..");
                break;
            }
            ++attempts;
        } while (spawnY < 4 || spawnY <= this.chunkProvider.getSeaLevel() || this.nearSolidBlocks(spawnX, spawnY, spawnZ) || this.nearSolidBlocks2(spawnX, spawnY, spawnZ));
        return Optional.of(new BlockPos(spawnX - width / 2, spawnY - 1, spawnZ - length / 2));
    }

    private boolean nearSolidBlocks(int spawnX, int spawnY, int spawnZ) {
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int y = spawnY - 1; y <= spawnY + 2; ++y) {
                for (int z = spawnZ - 3 - 2; z <= spawnZ + 3; ++z) {
                    Block block = this.chunkProvider.getLevelBlock(x, y, z);
                    if (block.equals(Blocks.AIR) || block.equals(this.chunkProvider.getLevelFluidBlock())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean nearSolidBlocks2(int spawnX, int spawnY, int spawnZ) {
        int y = spawnY - 2;
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int z = spawnZ - 3 - 2; z <= spawnZ + 3; ++z) {
                Block block = this.chunkProvider.getLevelBlock(x, y, z);
                if (!block.equals(Blocks.AIR) && !block.equals(this.chunkProvider.getLevelFluidBlock())) continue;
                return true;
            }
        }
        return false;
    }
}

