/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.spawn;

import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.random.mersenne.MTRandom;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.event.Level;

public class SpawnLocatorPE
implements SpawnLocator {
    private final Random rand;
    private final ChunkProvider chunkProvider;
    private final PerlinOctaveNoise beachOctaveNoise;

    public SpawnLocatorPE(ChunkProvider chunkProvider, PerlinOctaveNoise beachOctaveNoise, MTRandom rand) {
        this.rand = rand;
        this.chunkProvider = chunkProvider;
        this.beachOctaveNoise = beachOctaveNoise;
    }

    @Override
    public Optional<BlockPos> locateSpawn(LevelHeightAccessor world) {
        int n;
        ChunkProvider chunkProvider;
        ModernerBeta.log(Level.INFO, "Setting a PE beach spawn..");
        int x = 0;
        int z = 0;
        int attempts = 0;
        while (!this.isSandAt(world, x, z)) {
            if (attempts > 10000) {
                ModernerBeta.log(Level.INFO, "Exceeded spawn attempts, spawning anyway at 128,128..");
                x = 128;
                z = 128;
                break;
            }
            z += this.rand.nextInt(32) - this.rand.nextInt(32);
            if ((x += this.rand.nextInt(32) - this.rand.nextInt(32)) < 4) {
                x += 32;
            }
            if (x >= 251) {
                x -= 32;
            }
            if (z < 4) {
                z += 32;
            }
            if (z >= 251) {
                z -= 32;
            }
            ++attempts;
        }
        if ((chunkProvider = this.chunkProvider) instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(world, x, z, Heightmap.Types.WORLD_SURFACE_WG);
        }
        int y = n;
        return Optional.of(new BlockPos(x, y, z));
    }

    private boolean isSandAt(LevelHeightAccessor world, int x, int z) {
        Holder<Biome> holder;
        int n;
        double eighth = 0.03125;
        int seaLevel = this.chunkProvider.getSeaLevel();
        ChunkProvider chunkProvider = this.chunkProvider;
        if (chunkProvider instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(world, x, z, Heightmap.Types.OCEAN_FLOOR_WG);
        }
        int y = n;
        BiomeSource biomeSource = this.chunkProvider.getChunkGenerator().getBiomeSource();
        if (biomeSource instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource oldBiomeSource = (ModernBetaBiomeSource)biomeSource;
            holder = oldBiomeSource.getBiomeForSpawn(x, y, z);
        } else {
            holder = this.chunkProvider.getBiome(x >> 2, y >> 2, z >> 2, null);
        }
        Holder<Biome> biome = holder;
        return biome.is(ModernBetaBiomeTags.SURFACE_CONFIG_SAND) && y >= seaLevel || this.beachOctaveNoise.sample((double)x * eighth, (double)z * eighth, 0.0) > 0.0 && y >= seaLevel && y <= seaLevel + 2;
    }
}

