/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.spawn;

import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.event.Level;

public class SpawnLocatorRelease
implements SpawnLocator {
    private final Random rand;
    private final ChunkProvider chunkProvider;
    private final BiomeSource biomeSource;

    public SpawnLocatorRelease(ChunkProvider chunkProvider, Random rand) {
        this.rand = rand;
        this.chunkProvider = chunkProvider;
        this.biomeSource = chunkProvider.getChunkGenerator().getBiomeSource();
    }

    @Override
    public Optional<BlockPos> locateSpawn(LevelHeightAccessor world) {
        int n;
        ChunkProvider chunkProvider;
        ModernerBeta.log(Level.INFO, "Setting a grass spawn..");
        int x = 0;
        int z = 0;
        int attempts = 0;
        BlockPos suitableBiomeLocation = this.getSuitableBiomeLocation(0, 0, 256);
        if (suitableBiomeLocation != null) {
            x = suitableBiomeLocation.getX();
            z = suitableBiomeLocation.getZ();
        } else {
            ModernerBeta.log(Level.INFO, "Unable to find spawn biome");
        }
        while (!this.isGrassAt(world, x, z)) {
            if (attempts > 10000) {
                ModernerBeta.log(Level.INFO, "Exceeded spawn attempts, spawning anyway at 0,0..");
                x = 0;
                z = 0;
                break;
            }
            x += this.rand.nextInt(64) - this.rand.nextInt(64);
            z += this.rand.nextInt(64) - this.rand.nextInt(64);
            ++attempts;
        }
        if ((chunkProvider = this.chunkProvider) instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(world, x, z, Heightmap.Types.WORLD_SURFACE_WG);
        }
        int y = n;
        return Optional.of(new BlockPos(x, y, z));
    }

    private BlockPos getSuitableBiomeLocation(int x, int z, int radius) {
        int minX = x - radius >> 2;
        int minZ = z - radius >> 2;
        int maxX = x + radius >> 2;
        int maxZ = z + radius >> 2;
        int width = maxX - minX + 1;
        int length = maxZ - minZ + 1;
        BlockPos position = null;
        int choiceChance = 1;
        for (int i = 0; i < width * length; ++i) {
            int biomeX = minX + i % width;
            int biomeZ = minZ + i / width;
            Holder biome = this.biomeSource.getNoiseBiome(biomeX, 16, biomeZ, null);
            if (!biome.is(ModernBetaBiomeTags.IS_RELEASE_SPAWN) || position != null && this.rand.nextInt(choiceChance) != 0) continue;
            position = new BlockPos(biomeX << 2, 0, biomeZ << 2);
            ++choiceChance;
        }
        return position;
    }

    private boolean isGrassAt(LevelHeightAccessor world, int x, int z) {
        int n;
        int seaLevel = this.chunkProvider.getSeaLevel();
        ChunkProvider chunkProvider = this.chunkProvider;
        if (chunkProvider instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(world, x, z, Heightmap.Types.OCEAN_FLOOR_WG);
        }
        int y = n;
        return y >= seaLevel;
    }
}

