/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInProviders;
import mod.bluestaggo.modernerbeta.network.INetworkHelper;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.CodecUtil;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ConfiguredLayers;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicateType;
import mod.bluestaggo.modernerbeta.world.carver.ModernBetaCarvers;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.feature.ModernBetaFeatures;
import mod.bluestaggo.modernerbeta.world.feature.ModernBetaFoliagePlacers;
import mod.bluestaggo.modernerbeta.world.feature.ModernBetaTrunkPlacers;
import mod.bluestaggo.modernerbeta.world.feature.placement.ModernBetaPlacementTypes;
import mod.bluestaggo.modernerbeta.world.structure.ModernBetaStructurePieceTypes;
import mod.bluestaggo.modernerbeta.world.structure.ModernBetaStructureTypes;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ModernerBeta {
    public static final String MOD_ID = "moderner_beta";
    public static final String MOD_NAME = "Moderner Beta";
    public static boolean DEV_ENV;
    private static final Logger LOGGER;
    public static final List<String> BUILT_IN_PACKS;
    public static final List<class_3545<class_2378<?>, Consumer<IRegistryHandler<?>>>> REGISTRY_HANDLERS;
    public static List<class_3545<class_2378<?>, Consumer<IRegistryHandler<?>>>> CUSTOM_REGISTRY_HANDLERS;
    public static List<class_3545<class_5321<?>, Codec<?>>> CUSTOM_DYNAMIC_REGISTRIES;
    public static INetworkHelper networkHelper;
    public static ModernBetaSettings config;

    public static void init() {
        ModernerBeta.log(Level.INFO, "Initializing Moderner Beta...");
    }

    public static void setupCustomRegistryHandlers() {
        CUSTOM_REGISTRY_HANDLERS = List.of(new class_3545(ModernBetaRegistries.SETTINGS_COMPONENT_TYPE, SettingsComponentTypes::init), new class_3545(ModernBetaRegistries.CHUNK, ModernBetaBuiltInProviders::registerChunkProviders), new class_3545(ModernBetaRegistries.BIOME, ModernBetaBuiltInProviders::registerBiomeProviders), new class_3545(ModernBetaRegistries.CAVE_BIOME, ModernBetaBuiltInProviders::registerCaveBiomeProviders), new class_3545(ModernBetaRegistries.SURFACE_CONFIG, ModernBetaBuiltInProviders::registerSurfaceConfigs), new class_3545(ModernBetaRegistries.HEIGHT_CONFIG, ModernBetaBuiltInProviders::registerHeightConfigs), new class_3545(ModernBetaRegistries.BLOCKSOURCE, ModernBetaBuiltInProviders::registerBlockSources), new class_3545(ModernBetaRegistries.FRACTAL_LAYER, LayerType::init), new class_3545(ModernBetaRegistries.BIOME_PREDICATE, BiomePredicateType::init));
    }

    public static void setupCustomDynamicRegistries() {
        CUSTOM_DYNAMIC_REGISTRIES = List.of(new class_3545(ModernBetaRegistryKeys.SETTINGS_PRESET, ModernBetaSettingsPreset.CODEC), new class_3545(ModernBetaRegistryKeys.SETTINGS_PRESET_CATEGORY, ModernBetaSettingsPresetCategory.CODEC));
    }

    public static class_2960 createId(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void log(Level level, String message) {
        LOGGER.atLevel(level).log("[Moderner Beta] {}", (Object)message);
    }

    public static void log(String message) {
        ModernerBeta.log(Level.INFO, message);
    }

    public static GsonBuilder getSettingsGson() {
        GsonBuilder gson = new GsonBuilder();
        CodecUtil.registerTypeAdapter(gson, ConfiguredLayers.class, ConfiguredLayers.CODEC);
        CodecUtil.registerTypeAdapter(gson, class_2960.class, class_2960.field_25139);
        return gson;
    }

    public static void loadConfig(Path configDir) {
        Path configFile = configDir.resolve("moderner_beta.json");
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            config = (ModernBetaSettings)ModernBetaSettings.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)ModernerBeta.getSettingsGson().create().fromJson((Reader)reader, JsonElement.class))).result().orElseGet(() -> Pair.of((Object)ModernBetaSettings.empty(), null)).getFirst();
        }
        catch (NoSuchFileException exception) {
            config = ModernBetaSettings.builder().addDefault(SettingsComponentTypes.CONFIG_BETA_CLIMATIC_COLORS, SettingsComponentTypes.CONFIG_PE_CLIMATIC_COLORS, SettingsComponentTypes.CONFIG_BETA_FRACTAL_CLIMATIC_COLORS, SettingsComponentTypes.CONFIG_BIOME_PREVIEW_COLORS, SettingsComponentTypes.CONFIG_MISCELLANEOUS).build();
            ModernerBeta.saveConfig(configDir);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            config = ModernBetaSettings.empty();
        }
    }

    public static void saveConfig(Path configDir) {
        Path configFile = configDir.resolve("moderner_beta.json");
        DataResult encodedConfig = ModernBetaSettings.CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
        if (encodedConfig.result().isEmpty()) {
            ModernerBeta.log(Level.WARN, "Failed to serialize config to JSON: " + String.valueOf(encodedConfig));
            return;
        }
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                ModernerBeta.getSettingsGson().setPrettyPrinting().create().toJson((JsonElement)encodedConfig.result().get(), (Appendable)writer);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_NAME);
        BUILT_IN_PACKS = List.of("reduced_height", "deepslate_blobs");
        REGISTRY_HANDLERS = List.of(new class_3545((Object)class_7923.field_41150, ModernBetaFoliagePlacers::register), new class_3545((Object)class_7923.field_41151, ModernBetaTrunkPlacers::register), new class_3545((Object)class_7923.field_41148, ModernBetaPlacementTypes::register), new class_3545((Object)class_7923.field_41147, ModernBetaStructureTypes::register), new class_3545((Object)class_7923.field_41146, ModernBetaStructurePieceTypes::register), new class_3545((Object)class_7923.field_41144, ModernBetaFeatures::register), new class_3545((Object)class_7923.field_41143, ModernBetaCarvers::register), new class_3545((Object)class_7923.field_41156, ModernBetaBiomeSource::register), new class_3545((Object)class_7923.field_41157, ModernBetaChunkGenerator::register));
    }
}

