/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import mod.bluestaggo.modernerbeta.api.world.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5817;
import net.minecraft.class_6910;

public interface ChunkProviderNoiseImitable {
    default public BlockSource getBaseBlockSource(class_5817 weightSampler, SimpleNoisePos noisePos, BlockHolder blockHolder, class_2248 defaultBlock, class_2248 defaultFluid) {
        return (x, y, z) -> {
            class_2248 originalBlock = blockHolder.getBlock();
            boolean isFluid = originalBlock == defaultFluid;
            boolean isAir = originalBlock == class_2246.field_10124;
            boolean isSolid = !isFluid && !isAir;
            double density = !isSolid ? -25.0 : 25.0;
            double clampedDensity = class_3532.method_15350((double)(density / 200.0), (double)-1.0, (double)1.0);
            clampedDensity = clampedDensity / 2.0 - clampedDensity * clampedDensity * clampedDensity / 24.0;
            clampedDensity += weightSampler.method_40464((class_6910.class_6912)noisePos.set(x, y, z));
            class_2680 blockState = BlockStates.AIR;
            if (clampedDensity > 0.0) {
                blockState = null;
                if (!isSolid) {
                    blockState = defaultBlock.method_9564();
                }
            } else if (clampedDensity <= 0.0) {
                if (isFluid) {
                    blockState = null;
                }
                if (isSolid) {
                    blockState = BlockStates.AIR;
                }
            }
            return blockState;
        };
    }

    default public BlockSource getActualBlockSource(BlockHolder blockHolder) {
        return (x, y, z) -> blockHolder.getBlock().method_9564();
    }

    public static class BlockHolder {
        private class_2248 block = class_2246.field_10124;

        public class_2248 getBlock() {
            return this.block;
        }

        public void setBlock(class_2248 block) {
            this.block = block;
        }
    }
}

