/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client;

import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ExtendedBiomeIdToColorMapScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ExtendedBiomeIdToHeightConfigMapScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalCompoundSettingsScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.ModernBetaGraphicalProviderSettingsScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.VoronoiPointBiomeListScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.config.VoronoiPointCaveBiomeListScreen;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.settings.component.CaveGeneration;
import mod.bluestaggo.modernerbeta.world.chunk.provider.indev.IndevTheme;
import mod.bluestaggo.modernerbeta.world.chunk.provider.indev.IndevType;
import mod.bluestaggo.modernerbeta.world.chunk.provider.island.IslandShape;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_353;
import net.minecraft.class_7172;

@Environment(value=EnvType.CLIENT)
public class ModernBetaClientBuiltInProviders {
    private static void addAll(class_353 list, class_7172<?> ... options) {
        list.method_20408(options);
    }

    public static void registerSettingsComponentTypeGuis(IRegistryHandler<?> handler) {
        IRegistryHandler<?> registryHandler = handler;
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.DEEPSLATE_GENERATION.id, (screen, options) -> {
            int minY = -64;
            int maxY = 320;
            if (screen instanceof ModernBetaGraphicalProviderSettingsScreen) {
                ModernBetaGraphicalProviderSettingsScreen providerSettingsScreen = (ModernBetaGraphicalProviderSettingsScreen)screen;
                minY = providerSettingsScreen.worldMinY;
                maxY = providerSettingsScreen.worldMaxY;
            }
            ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("enabled"), screen.blockOption("block"), screen.intRangeOption("minY", minY, maxY), screen.intRangeOption("maxY", minY, maxY));
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.USE_SURFACE_RULES.id, (screen, options) -> options.method_20406(screen.booleanOption("self")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.SEA_LEVEL_OFFSET.id, (screen, options) -> {
            int minY = -64;
            int maxY = 320;
            if (screen instanceof ModernBetaGraphicalProviderSettingsScreen) {
                ModernBetaGraphicalProviderSettingsScreen providerSettingsScreen = (ModernBetaGraphicalProviderSettingsScreen)screen;
                minY = providerSettingsScreen.worldMinY;
                maxY = providerSettingsScreen.worldMaxY;
            }
            options.method_20406(screen.intRangeOption("self", minY - 64, maxY - 64));
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CAVE_GENERATION.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("useCarvers"), screen.booleanOption("useNoiseCaves"), screen.booleanOption("fixCaveBorders"), screen.booleanOption("forceBetaCaves"), screen.booleanOption("forceBetaCanyons"), screen.selectionOption("seedMethod", CaveGeneration.SeedMethod::values)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.NOISE_SCALE.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.floatRangeOption("mainNoiseX", 1.0f, 5000.0f), screen.floatRangeOption("mainNoiseY", 1.0f, 5000.0f), screen.floatRangeOption("mainNoiseZ", 1.0f, 5000.0f), screen.floatRangeOption("depthNoiseX", 1.0f, 2000.0f), screen.floatRangeOption("depthNoiseZ", 1.0f, 2000.0f), screen.floatRangeOption("baseSize", 1.0f, 25.0f), screen.floatRangeOption("coordinate", 1.0f, 6000.0f), screen.floatRangeOption("height", 1.0f, 6000.0f), screen.floatRangeOption("stretchY", 0.01f, 50.0f), screen.floatRangeOption("upperLimit", 1.0f, 5000.0f), screen.floatRangeOption("lowerLimit", 1.0f, 5000.0f), screen.booleanOption("farlands")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.NOISE_SLIDE.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.intRangeOption("topTarget", -50, 0), screen.intRangeOption("bottomTarget", 0, 50), screen.intRangeOption("topSize", 0, 50), screen.intRangeOption("bottomSize", 0, 50), screen.intRangeOption("topOffset", -10, 10), screen.intRangeOption("bottomOffset", -10, 10)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FORCED_BIOME_HEIGHT.id, (screen, options) -> {
            options.method_20406(screen.mapEditButton((class_2561)screen.getText("heightOverrides"), "heightOverrides", ExtendedBiomeIdToHeightConfigMapScreen::new));
            ModernBetaClientBuiltInProviders.addAll(options, screen.floatRangeOption("depthWeight", 1.0f, 20.0f), screen.floatRangeOption("depthOffset", 0.0f, 20.0f), screen.floatRangeOption("scaleWeight", 1.0f, 20.0f), screen.floatRangeOption("scaleOffset", 0.0f, 20.0f), screen.booleanOption("modifyOnlyPositiveDepth"));
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.INFDEV_227_STRUCTURES.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("brickPyramids"), screen.booleanOption("obsidianWalls")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FINITE_LEVEL_PROPERTIES.id, (screen, options) -> {
            int minY = -64;
            int maxY = 320;
            if (screen instanceof ModernBetaGraphicalProviderSettingsScreen) {
                ModernBetaGraphicalProviderSettingsScreen providerSettingsScreen = (ModernBetaGraphicalProviderSettingsScreen)screen;
                minY = providerSettingsScreen.worldMinY;
                maxY = providerSettingsScreen.worldMaxY;
            }
            ModernBetaClientBuiltInProviders.addAll(options, screen.selectionOption("type", IndevType::values), screen.selectionOption("theme", IndevTheme::values), screen.intRangeOption("width", 64, 1024, 64), screen.intRangeOption("length", 64, 1024, 64), screen.intRangeOption("height", 64, maxY - minY, 64));
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FINITE_CAVE_GENERATION.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("useCarvers"), screen.booleanOption("use14aCaves"), screen.intRangeOption("rarity", 1024, 40960, 1024), screen.floatRangeOption("radius", 0.01f, 5.0f), screen.floatRangeOption("length", 0.0f, 500.0f)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FINITE_NOISE.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.floatRangeOption("heightNoiseScale", 0.01f, 10.0f), screen.floatRangeOption("selectorScale", 0.01f, 10.0f), screen.floatRangeOption("minHeightDamp", 0.01f, 25.0f), screen.floatRangeOption("minHeightBoost", -50.0f, 50.0f), screen.floatRangeOption("maxHeightDamp", 0.01f, 25.0f), screen.floatRangeOption("maxHeightBoost", -50.0f, 50.0f), screen.intRangeOption("selectorOctaves", 1, 16), screen.floatRangeOption("heightUnderDamp", 0.01f, 5.0f)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FINITE_BEACHES.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.floatRangeOption("sandThreshold", -32.0f, 32.0f), screen.booleanOption("sandUnderAir"), screen.booleanOption("sandUnderFluid"), screen.floatRangeOption("gravelThreshold", -32.0f, 32.0f), screen.booleanOption("gravelUnderAir"), screen.booleanOption("gravelUnderFluid"), screen.booleanOption("prioritizeGravelBeaches")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FINITE_POOLS.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.intRangeOption("waterRarity", 1000, 50000, 1000), screen.intRangeOption("lavaRarity", 1000, 50000, 1000), screen.booleanOption("uniformLavaHeights")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.SPAWN_INDEV_HOUSE.id, (screen, options) -> options.method_20406(screen.booleanOption("self")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.ISLES_PROPERTIES.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("useIslands"), screen.booleanOption("useOuterIslands"), screen.floatRangeOption("oceanSlideTarget", -1000.0f, 0.0f), screen.selectionOption("centerIslandShape", IslandShape::values), screen.intRangeOption("centerIslandRadius", 1, 100), screen.intRangeOption("centerIslandFalloffDistance", 1, 100), screen.intRangeOption("centerOceanRadius", 1, 100), screen.intRangeOption("centerOceanFalloffDistance", 1, 100), screen.floatRangeOption("outerIslandNoiseScale", 0.01f, 5000.0f), screen.floatRangeOption("outerIslandNoiseOffset", -1.0f, 1.0f)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.SINGLE_BIOME.id, (screen, options) -> options.method_20406(screen.biomeOption("self", false)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CLIMATE_SCALE.id, (screen, options) -> {
            options.method_20406(screen.floatRangeOption("temp", 0.001f, 1.0f));
            options.method_20406(screen.floatRangeOption("rain", 0.001f, 1.0f));
            options.method_20406(screen.floatRangeOption("detail", 0.001f, 1.0f));
            options.method_20406(screen.floatRangeOption("weird", 0.001f, 1.0f));
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CLIMATE_MAPPINGS.id, (screen, options) -> {
            String[] climateMappingTargets;
            for (String target : climateMappingTargets = new String[]{"desert", "forest", "ice_desert", "plains", "rainforest", "savanna", "shrubland", "seasonal_forest", "swampland", "taiga", "tundra"}) {
                options.method_20406(screen.headerOption((class_2561)screen.getText(target).method_27692(class_124.field_1067)));
                ModernBetaClientBuiltInProviders.addAll(options, screen.headerOption((class_2561)screen.getText("biome")), screen.biomeOption(target + ".biome", false), screen.headerOption((class_2561)screen.getText("oceanBiome")), screen.biomeOption(target + ".oceanBiome", false), screen.headerOption((class_2561)screen.getText("deepOceanBiome")), screen.biomeOption(target + ".deepOceanBiome", false));
            }
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CLIMATE_DISTRIBUTION.id, (screen, options) -> ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("fuzzyGrass"), screen.booleanOption("smoothBorders")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.TEMPERATURE_HEIGHT_SCALING.id, (screen, options) -> options.method_20406(screen.selectionOption("self", TemperatureHeightScaling::values)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.VORONOI_POINTS.id, (screen, options) -> options.method_20406(screen.listEditButton((class_2561)screen.getText("self"), "self", 10, VoronoiPointBiomeListScreen::new)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.FRACTAL_LAYERS.id, (screen, options) -> options.method_20406(screen.headerOption((class_2561)screen.getText("self").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}))));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.USE_OCEAN_BIOMES.id, (screen, options) -> options.method_20406(screen.booleanOption("self")));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CAVE_BIOME_VORONOI.id, (screen, options) -> {
            int minY = -64;
            int maxY = 320;
            if (screen instanceof ModernBetaGraphicalProviderSettingsScreen) {
                ModernBetaGraphicalProviderSettingsScreen providerSettingsScreen = (ModernBetaGraphicalProviderSettingsScreen)screen;
                minY = providerSettingsScreen.worldMinY;
                maxY = providerSettingsScreen.worldMaxY;
            }
            ModernBetaClientBuiltInProviders.addAll(options, screen.floatRangeOption("horizontalScale", 0.001f, 100.0f), screen.floatRangeOption("verticalScale", 0.001f, 100.0f), screen.intRangeOption("depthMinY", minY, maxY), screen.intRangeOption("depthMaxY", minY, maxY));
            options.method_20406(screen.listEditButton((class_2561)screen.getText("points"), "points", 10, VoronoiPointCaveBiomeListScreen::new));
        });
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CONFIG_BETA_CLIMATIC_COLORS.id, ModernBetaClientBuiltInProviders::addClimaticColorOptions);
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CONFIG_PE_CLIMATIC_COLORS.id, ModernBetaClientBuiltInProviders::addClimaticColorOptions);
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CONFIG_BETA_FRACTAL_CLIMATIC_COLORS.id, ModernBetaClientBuiltInProviders::addClimaticColorOptions);
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CONFIG_BIOME_PREVIEW_COLORS.id, (screen, options) -> options.method_20406(screen.mapEditButton((class_2561)screen.getText("self"), "self", ExtendedBiomeIdToColorMapScreen::new)));
        registryHandler.register(ModernBetaBuiltInTypes.SettingsComponentType.CONFIG_MISCELLANEOUS.id, (screen, options) -> {
            options.method_20406(screen.booleanOption("oldFogColorWeighting"));
            ModernBetaClientBuiltInProviders.addAll(options, screen.headerOption((class_2561)screen.getText("defaultSettingsPreset")), screen.extendedBiomeIdOption("defaultSettingsPreset"));
        });
    }

    private static void addClimaticColorOptions(ModernBetaGraphicalCompoundSettingsScreen screen, class_353 options) {
        ModernBetaClientBuiltInProviders.addAll(options, screen.booleanOption("sky"), screen.booleanOption("vegetation"), screen.booleanOption("water"));
    }
}

