/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import java.util.List;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaWorldScreen;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class ModernBetaSettingsPresetScreen
extends ModernBetaScreen {
    private static final String TEXT_TITLE = "createWorld.customize.modern_beta.title.preset";
    private static final String TEXT_PRESET_NAME = "createWorld.customize.modern_beta.preset.name";
    private static final String TEXT_PRESET_DESC = "createWorld.customize.modern_beta.preset.desc";
    private static final String TEXT_PRESET_CATEGORY_NAME = "createWorld.customize.modern_beta.preset_category.name";
    private static final String TEXT_PRESET_CATEGORY_DESC = "createWorld.customize.modern_beta.preset_category.desc";
    private static final class_2960 TEXTURE_PRESET_CUSTOM = ModernBetaSettingsPresetScreen.createTextureId(ModernerBeta.createId("custom"));
    private final ModernBetaWorldScreen worldScreen;
    private final List<class_2960> presets;
    private final boolean displayCategories;
    private final class_2378<ModernBetaSettingsPreset> presetRegistry;
    private final class_2378<ModernBetaSettingsPresetCategory> presetCategoryRegistry;
    private ModernBetaSettingsPreset preset;
    private PresetsListWidget listWidget;
    private class_4185 selectPresetButton;

    public ModernBetaSettingsPresetScreen(ModernBetaScreen parent, class_2378<ModernBetaSettingsPreset> presetRegistry, class_2378<ModernBetaSettingsPresetCategory> presetCategoryRegistry, List<class_2960> presets, ModernBetaSettingsPreset preset, boolean displayCategories) {
        super((class_2561)class_2561.method_43471((String)TEXT_TITLE), parent);
        this.presets = presets;
        this.preset = preset;
        this.displayCategories = displayCategories;
        this.presetRegistry = presetRegistry;
        this.presetCategoryRegistry = presetCategoryRegistry;
        ModernBetaScreen worldScreen = parent;
        while (!(worldScreen instanceof ModernBetaWorldScreen)) {
            if (!(worldScreen instanceof ModernBetaScreen)) {
                worldScreen = null;
                break;
            }
            ModernBetaScreen modernBetaScreen = worldScreen;
            worldScreen = modernBetaScreen.parent;
        }
        this.worldScreen = (ModernBetaWorldScreen)worldScreen;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.listWidget = new PresetsListWidget(this.presets);
        this.method_25429((class_364)this.listWidget);
        this.selectPresetButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.customize.presets.select"), onPress -> {
            this.worldScreen.setPreset(this.preset);
            this.field_22787.method_1507(this.parent);
        }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 26, 150, 20).method_46431());
        this.selectPresetButton.field_22763 = !this.displayCategories;
        this.method_37063((class_364)class_4185.method_46430((class_2561)(this.displayCategories ? class_5244.field_24335 : class_5244.field_24339), button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 26, 150, 20).method_46431());
        this.updateSelectButton(this.listWidget.method_25334() instanceof PresetsListWidget.PresetEntry);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.listWidget.method_25394(context, mouseX, mouseY, delta);
    }

    private void updateSelectButton(boolean hasSelected) {
        this.selectPresetButton.field_22763 = hasSelected;
    }

    private static class_2960 createTextureId(class_2960 id) {
        return id.method_45136("textures/gui/moderner_beta_settings_preset/" + id.method_12832() + ".png");
    }

    private static class_2960 createPresetTextureId(class_2960 id) {
        class_2960 idObj = ModernBetaSettingsPresetScreen.createTextureId(id);
        return class_310.method_1551().method_1478().method_14486(idObj).isPresent() ? idObj : TEXTURE_PRESET_CUSTOM;
    }

    private class PresetsListWidget
    extends class_4280<AbstractPresetEntry> {
        private static final int ITEM_HEIGHT = 60;
        private static final int ICON_SIZE = 56;
        private static final int SCROLLBAR_X_OFFSET = 30;

        public PresetsListWidget(List<class_2960> presets) {
            super(ModernBetaSettingsPresetScreen.this.field_22787, ModernBetaSettingsPresetScreen.this.field_22789, ModernBetaSettingsPresetScreen.this.field_22790 - 64, 32, 60);
            if (ModernBetaSettingsPresetScreen.this.displayCategories) {
                presets.forEach(key -> this.method_25321((class_350.class_351)new PresetCategoryEntry((class_2960)key, (ModernBetaSettingsPresetCategory)ModernBetaSettingsPresetScreen.this.presetCategoryRegistry.method_63535(key))));
            } else {
                presets.forEach(key -> this.method_25321((class_350.class_351)new PresetEntry((class_2960)key)));
            }
        }

        public void setSelected(AbstractPresetEntry entry) {
            super.method_25313((class_350.class_351)entry);
            ModernBetaSettingsPresetScreen.this.updateSelectButton(entry instanceof PresetEntry);
        }

        protected int method_65507() {
            return super.method_65507() + 30;
        }

        public int method_25322() {
            return super.method_25322() + 85;
        }

        private class PresetEntry
        extends AbstractPresetEntry {
            private final class_2960 key;

            public PresetEntry(class_2960 presetName) {
                super(presetName);
                this.key = presetName;
            }

            @Override
            protected void setPreset() {
                PresetsListWidget.this.setSelected(this);
                ModernBetaSettingsPresetScreen.this.preset = ModernBetaSettingsPreset.referenced(this.key);
            }

            @Override
            protected void selectPreset() {
                class_437 class_4372;
                ModernBetaSettingsPresetScreen presetScreen = ModernBetaSettingsPresetScreen.this;
                class_310 minecraftClient = presetScreen.field_22787;
                minecraftClient.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                presetScreen.worldScreen.setPreset(ModernBetaSettingsPreset.referenced(this.key));
                while ((class_4372 = minecraftClient.field_1755) instanceof ModernBetaSettingsPresetScreen) {
                    ModernBetaSettingsPresetScreen subPresetScreen = (ModernBetaSettingsPresetScreen)class_4372;
                    minecraftClient.method_1507(subPresetScreen.parent);
                }
            }
        }

        private abstract class AbstractPresetEntry
        extends class_4280.class_4281<AbstractPresetEntry> {
            private static final class_2960 TEXTURE_JOIN = VersionCompat.vanillaId("world_list/join");
            private static final class_2960 TEXTURE_JOIN_HIGHLIGHTED = VersionCompat.vanillaId("world_list/join_highlighted");
            private static final int TEXT_SPACING = 11;
            private static final int TEXT_LENGTH = 240;
            private final class_2960 presetTexture;
            private final class_5250 presetName;
            private final class_5250 presetDesc;
            private long time;

            public AbstractPresetEntry(class_2960 presetName) {
                this.presetTexture = this.getPresetTexture(presetName);
                this.presetName = this.getPresetName(presetName);
                this.presetDesc = this.getPresetDesc(presetName);
            }

            protected abstract void setPreset();

            protected abstract void selectPreset();

            protected class_2960 getPresetTexture(class_2960 presetName) {
                return ModernBetaSettingsPresetScreen.createPresetTextureId(presetName);
            }

            protected class_5250 getPresetName(class_2960 presetName) {
                return class_2561.method_43471((String)("createWorld.customize.modern_beta.preset.name." + presetName.method_42094()));
            }

            protected class_5250 getPresetDesc(class_2960 presetName) {
                return class_2561.method_43471((String)("createWorld.customize.modern_beta.preset.desc." + presetName.method_42094()));
            }

            protected class_124 getTextFormatting() {
                return class_124.field_1054;
            }

            public class_2561 method_37006() {
                return class_2561.method_43473();
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                class_5250 presetNameText = this.presetName.method_27692(this.getTextFormatting());
                List<class_5481> presetDescTexts = this.splitText(ModernBetaSettingsPresetScreen.this.field_22793, (class_2561)this.presetDesc);
                int textStartX = x + 56 + 3;
                int textStartY = 1;
                context.method_51439(ModernBetaSettingsPresetScreen.this.field_22793, (class_2561)presetNameText, textStartX, y + textStartY, -1, false);
                int descSpacing = 11 + textStartY + 1;
                for (class_5481 line : presetDescTexts) {
                    context.method_51430(ModernBetaSettingsPresetScreen.this.field_22793, line, textStartX, y + descSpacing, -8355712, false);
                    descSpacing += 11;
                }
                this.draw(context, x, y, this.presetTexture);
                if (PresetsListWidget.this.field_22740 != null && ((Boolean)((PresetsListWidget)PresetsListWidget.this).field_22740.field_1690.method_42446().method_41753()).booleanValue() || hovered) {
                    boolean isMouseHovering = mouseX - x < 56;
                    context.method_25294(x, y, x + 56, y + 56, -1601138544);
                    class_2960 texture = isMouseHovering ? TEXTURE_JOIN_HIGHLIGHTED : TEXTURE_JOIN;
                    context.method_52706(class_10799.field_56883, texture, x, y, 56, 56);
                }
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (button != 0) {
                    return false;
                }
                this.setPreset();
                if (mouseX - (double)PresetsListWidget.this.method_25342() <= 56.0) {
                    this.selectPreset();
                }
                if (class_156.method_658() - this.time < 250L) {
                    this.selectPreset();
                }
                this.time = class_156.method_658();
                return true;
            }

            private void draw(class_332 context, int x, int y, class_2960 textureId) {
                context.method_25290(class_10799.field_56883, textureId, x, y, 0.0f, 0.0f, 56, 56, 56, 56);
            }

            private List<class_5481> splitText(class_327 textRenderer, class_2561 text) {
                return textRenderer.method_1728((class_5348)text, 240);
            }
        }

        private class PresetCategoryEntry
        extends AbstractPresetEntry {
            private final ModernBetaSettingsPresetCategory presetCategory;

            public PresetCategoryEntry(class_2960 presetName, ModernBetaSettingsPresetCategory presetCategory) {
                super(presetName);
                this.presetCategory = presetCategory;
            }

            @Override
            protected class_2960 getPresetTexture(class_2960 presetName) {
                presetName = ((ModernBetaSettingsPresetCategory)ModernBetaSettingsPresetScreen.this.presetCategoryRegistry.method_63535(presetName)).defaultIcon();
                return super.getPresetTexture(presetName);
            }

            @Override
            protected class_5250 getPresetName(class_2960 presetName) {
                return class_2561.method_43471((String)("createWorld.customize.modern_beta.preset_category.name." + presetName.method_42094()));
            }

            @Override
            protected class_5250 getPresetDesc(class_2960 presetName) {
                return class_2561.method_43471((String)("createWorld.customize.modern_beta.preset_category.desc." + presetName.method_42094()));
            }

            @Override
            protected class_124 getTextFormatting() {
                return class_124.field_1075;
            }

            @Override
            protected void setPreset() {
                PresetsListWidget.this.setSelected(this);
            }

            @Override
            protected void selectPreset() {
                assert (PresetsListWidget.this.field_22740 != null);
                PresetsListWidget.this.field_22740.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                PresetsListWidget.this.field_22740.method_1507((class_437)new ModernBetaSettingsPresetScreen(ModernBetaSettingsPresetScreen.this, ModernBetaSettingsPresetScreen.this.presetRegistry, ModernBetaSettingsPresetScreen.this.presetCategoryRegistry, this.presetCategory.presets(), ModernBetaSettingsPresetScreen.this.preset, false));
            }
        }
    }
}

