/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.longs.Long2DoubleLinkedOpenHashMap;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.imixin.ModernBetaWorld;
import mod.bluestaggo.modernerbeta.mixin.AccessorBiome;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1937.class})
public abstract class MixinWorld
implements ModernBetaWorld {
    @Unique
    private static final int MODERNER_BETA$TEMPERATURE_CACHE_CAPACITY = 128;
    @Unique
    private boolean modernerBeta$isModded;
    @Unique
    private ClimateSampler modernerBeta$climateSampler;
    @Unique
    private TemperatureHeightScaling modernerBeta$temperatureHeightScaling;
    @Unique
    private final ThreadLocal<Long2DoubleLinkedOpenHashMap> modernerBeta$temperatureCache = ThreadLocal.withInitial(() -> {
        Long2DoubleLinkedOpenHashMap map = new Long2DoubleLinkedOpenHashMap(128);
        map.defaultReturnValue(Double.NaN);
        return map;
    });

    @Override
    public boolean modernerBeta$isModded() {
        return this.modernerBeta$isModded;
    }

    @Override
    public void modernerBeta$setModded(boolean toggle) {
        this.modernerBeta$isModded = toggle;
    }

    @Override
    public ClimateSampler modernerBeta$getClimateSampler() {
        return this.modernerBeta$climateSampler;
    }

    @Override
    public void modernerBeta$setClimateSampler(ClimateSampler climateSampler) {
        this.modernerBeta$climateSampler = climateSampler;
    }

    @Override
    public TemperatureHeightScaling modernerBeta$getTemperatureHeightScaling() {
        return this.modernerBeta$temperatureHeightScaling;
    }

    @Override
    public void modernerBeta$setTemperatureHeightScaling(TemperatureHeightScaling temperatureHeightScaling) {
        this.modernerBeta$temperatureHeightScaling = temperatureHeightScaling;
    }

    @Override
    public double modernerBeta$sampleTemperature(class_1959 biome, class_2338 pos) {
        long coord;
        Long2DoubleLinkedOpenHashMap temperatureCache = this.modernerBeta$temperatureCache.get();
        double temperature = temperatureCache.get(coord = pos.method_10063());
        if (!Double.isNaN(temperature)) {
            return temperature;
        }
        temperature = this.modernerBeta$generateTemperature(biome, pos);
        if (temperatureCache.size() == 128) {
            temperatureCache.removeFirstDouble();
        }
        temperatureCache.put(coord, temperature);
        return temperature;
    }

    @Unique
    private double modernerBeta$generateTemperature(class_1959 biome, class_2338 pos) {
        class_1959.class_5484 temperatureModifier;
        AccessorBiome biomeAccessor = (AccessorBiome)biome;
        assert (biomeAccessor != null);
        ClimateSampler climateSampler = this.modernerBeta$getClimateSampler();
        TemperatureHeightScaling temperatureHeightScaling = this.modernerBeta$getTemperatureHeightScaling();
        if (climateSampler == null && temperatureHeightScaling == null) {
            return biomeAccessor.invokeGetTemperature(pos, 64);
        }
        double temperature = biome.method_8712();
        if (climateSampler != null) {
            temperature = climateSampler.sample(pos.method_10263(), pos.method_10260()).temp();
        }
        if (temperatureHeightScaling.supportsModifier(temperatureModifier = biomeAccessor.getWeather().comp_845())) {
            temperature = temperatureModifier.method_30798(pos, (float)temperature);
        }
        if (temperatureHeightScaling != null) {
            temperature = temperatureHeightScaling.modifyTemperature(pos, temperature);
        }
        return temperature;
    }

    @Override
    public class_1959.class_1963 modernerBeta$samplePrecipitation(class_1959 biome, class_2338 pos) {
        if (!biome.method_48163()) {
            return class_1959.class_1963.field_9384;
        }
        if (this.modernerBeta$getTemperatureHeightScaling() == TemperatureHeightScaling.BETA) {
            pos = pos.method_33096(64);
        }
        double temp = this.modernerBeta$sampleTemperature(biome, pos);
        double snowThreshold = this.modernerBeta$getClimateSampler() != null ? this.modernerBeta$getClimateSampler().getSnowThreshold() : 0.15;
        return temp < snowThreshold ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382;
    }

    @WrapOperation(method={"getPrecipitation"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/biome/Biome;getPrecipitation(Lnet/minecraft/util/math/BlockPos;I)Lnet/minecraft/world/biome/Biome$Precipitation;")})
    public class_1959.class_1963 modifyTickPrecipitation(class_1959 biome, class_2338 blockPos, int seaLevel, Operation<class_1959.class_1963> original) {
        if (!this.modernerBeta$isModded()) {
            return (class_1959.class_1963)original.call(new Object[]{biome, blockPos, seaLevel});
        }
        return this.modernerBeta$samplePrecipitation(biome, blockPos);
    }
}

