/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.random;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicInteger;
import mod.bluestaggo.modernerbeta.util.random.mersenne.MersenneTwister;
import net.minecraft.class_3532;
import net.minecraft.class_5798;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6574;

public class BedrockCheckedRandom
extends class_5820 {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final double TWO_POW_M32 = 2.3283064365386963E-10;
    private final AtomicInteger seed = new AtomicInteger();
    private final MersenneTwister mt;
    private boolean haveNextNextGaussian;
    private float nextNextGaussian;
    private final boolean valid;

    public BedrockCheckedRandom(long seed) {
        super(0L);
        this.mt = new MersenneTwister((int)seed);
        this.valid = true;
        this.method_43052(seed);
    }

    public int getSeed() {
        return this.seed.get();
    }

    public class_5819 method_38420() {
        return new BedrockCheckedRandom(this.method_43054());
    }

    public class_6574 method_38421() {
        return new Splitter(this.method_43054());
    }

    public void method_43052(long seed) {
        if (this.valid) {
            this.setSeed((int)seed);
        }
    }

    private void setSeed(int seed) {
        if (!this.seed.compareAndSet(this.seed.get(), seed)) {
            throw class_5798.method_33564((String)"BedrockCheckedRandom", null);
        }
        this.haveNextNextGaussian = false;
        this.nextNextGaussian = 0.0f;
        this.mt.setSeed(seed);
    }

    public int method_43054() {
        return this.mt.genRandInt32() >>> 1;
    }

    public int method_43048(int bound) {
        if (bound > 0) {
            return (int)(Integer.toUnsignedLong(this.mt.genRandInt32()) % (long)bound);
        }
        return 0;
    }

    public boolean method_43056() {
        return (this.mt.genRandInt32() & Integer.MIN_VALUE) != 0;
    }

    public float method_43057() {
        return (float)this.genRandReal2();
    }

    public double method_43058() {
        return this.genRandReal2();
    }

    public double method_43059() {
        float v2;
        float v1;
        float s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = this.method_43057() * 2.0f - 1.0f) * v1 + (v2 = this.method_43057() * 2.0f - 1.0f) * v2) == 0.0f || s > 1.0f) {
        }
        float multiplier = (float)Math.sqrt(-2.0f * (float)Math.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public int method_43156(int bits) {
        return this.mt.genRandInt32() >>> 32 - bits;
    }

    private double genRandReal2() {
        return (double)Integer.toUnsignedLong(this.mt.genRandInt32()) * 2.3283064365386963E-10;
    }

    public static class Splitter
    implements class_6574 {
        private final int seed;

        public Splitter(int seed) {
            this.seed = seed;
        }

        public class_5819 method_38418(int x, int y, int z) {
            long posHash = class_3532.method_15371((int)x, (int)y, (int)z);
            long seed = posHash ^ (long)this.seed;
            return new BedrockCheckedRandom((int)seed);
        }

        public class_5819 method_38995(String seed) {
            int i = seed.hashCode();
            return new BedrockCheckedRandom(i ^ this.seed);
        }

        public class_5819 method_60628(long seed) {
            return new BedrockCheckedRandom((int)seed);
        }

        @VisibleForTesting
        public void method_39039(StringBuilder info) {
            info.append("BedrockCheckedRandom.Splitter{").append(this.seed).append("}");
        }
    }
}

