/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverExtendedIdStepped;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ConfiguredLayers;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4543;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class BiomeProviderFractal
extends BiomeProvider
implements BiomeResolverBlock,
BiomeResolverExtendedIdStepped,
class_4543.class_4544 {
    protected final ConfiguredLayers configuredLayers;
    protected final List<Layer> pipeline;
    private final Supplier<class_6880<class_1959>> baseBiome = Suppliers.memoize(() -> this.getBiomeEntry(this.settings.getOrDefault(SettingsComponentTypes.SINGLE_BIOME)).orElseThrow());
    private final class_4543 biomeAccess;
    private final List<class_6880<class_1959>> allBiomes;
    private final Layer layer;

    public BiomeProviderFractal(ModernBetaSettings settings, class_7871<class_1959> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        this.biomeAccess = new class_4543((class_4543.class_4544)this, seed);
        this.configuredLayers = this.settings.getOrThrow(SettingsComponentTypes.FRACTAL_LAYERS);
        this.pipeline = this.configuredLayers.getPipeline();
        boolean use32BitSeed = this.settings.getOrDefault(SettingsComponentTypes.USE_32BIT_LAYER_SEED);
        if (use32BitSeed) {
            seed &= 0xFFFFFFFFL;
        }
        this.layer = this.configuredLayers.getOutputOrThrow(ModernBetaBuiltInTypes.LayerOutput.BIOME.id);
        this.layer.init(seed);
        HashSet<ExtendedBiomeId> allExtendedBiomes = new HashSet<ExtendedBiomeId>();
        this.layer.addPossibleBiomesRecursive(allExtendedBiomes);
        this.allBiomes = allExtendedBiomes.stream().map(biome -> this.getBiomeEntry(biome.baseId())).filter(Optional::isPresent).map(Optional::get).distinct().toList();
    }

    private Optional<class_6880<class_1959>> getBiomeEntry(class_2960 id) {
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)id);
        return this.biomeRegistry.method_46746(key);
    }

    @Override
    public class_6880<class_1959> getBiome(int biomeX, int biomeY, int biomeZ) {
        class_2960 baseId = this.getExtendedBiomeId(biomeX, biomeY, biomeZ).baseId();
        return this.getBiomeEntry(baseId).orElseThrow(() -> new NoSuchElementException("Biome \"" + String.valueOf(baseId) + "\" does not exist."));
    }

    @Override
    public ExtendedBiomeId getExtendedBiomeId(int biomeX, int biomeY, int biomeZ) {
        return this.layer.sample(biomeX, biomeZ);
    }

    @Override
    public class_6880<class_1959> getBiomeBlock(int x, int y, int z) {
        return this.biomeAccess.method_22393(new class_2338(x, y, z));
    }

    @Override
    public List<class_6880<class_1959>> getBiomes() {
        return this.allBiomes;
    }

    public class_6880<class_1959> method_16359(int biomeX, int biomeY, int biomeZ) {
        return this.getBiome(biomeX, biomeY, biomeZ);
    }

    @Override
    public class_6880<class_1959> getBiomeForStep(int biomeX, int biomeY, int biomeZ, int step) {
        class_2960 baseId = this.getExtendedBiomeIdForStep(biomeX, biomeY, biomeZ, step).baseId();
        return this.getBiomeEntry(baseId).orElseThrow(() -> new NoSuchElementException("Biome \"" + String.valueOf(baseId) + "\" does not exist."));
    }

    @Override
    public ExtendedBiomeId getExtendedBiomeIdForStep(int biomeX, int biomeY, int biomeZ, int step) {
        return this.pipeline.get(step).sample(biomeX, biomeZ);
    }

    @Override
    public class_2561 getBiomeName(int biomeX, int biomeY, int biomeZ) {
        return this.getExtendedBiomeName(this.getExtendedBiomeId(biomeX, biomeY, biomeZ));
    }

    @Override
    public class_2561 getBiomeNameForStep(int biomeX, int biomeY, int biomeZ, int step) {
        return this.getExtendedBiomeName(this.getExtendedBiomeIdForStep(biomeX, biomeY, biomeZ, step));
    }

    private class_2561 getExtendedBiomeName(ExtendedBiomeId extendedBiomeId) {
        class_2561 text = (class_2561)this.getBiomeEntry(extendedBiomeId.baseId()).map(entry -> entry.method_40230().map(key -> class_2561.method_43471((String)key.method_29177().method_42093("biome"))).orElse(class_2561.method_43470((String)"[unregistered]"))).orElse(class_2561.method_43470((String)"[unregistered]"));
        if (!extendedBiomeId.ext().isEmpty()) {
            text = class_2561.method_43469((String)"createWorld.customize.modern_beta.settings.preview.extended_biome_id", (Object[])new Object[]{text, class_2561.method_43470((String)extendedBiomeId.ext())});
        }
        return text;
    }

    @Override
    public int getStepCount() {
        return this.pipeline.size();
    }

    @Override
    public class_2561 getStepName(int step) {
        return class_2561.method_43470((String)this.pipeline.get(step).toString());
    }
}

