/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Random;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.PerlinNoise;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SingleParentLayer;

public class PerlinZoomLayer
extends SingleParentLayer {
    public static final MapCodec<PerlinZoomLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> PerlinZoomLayer.fillSingleParentLayerFields(instance).and(instance.group((App)Codec.DOUBLE.fieldOf("scale").orElse((Object)2.0).forGetter(layer -> layer.scale), (App)Codec.DOUBLE.fieldOf("strength").orElse((Object)0.8).forGetter(layer -> layer.strength), (App)Codec.DOUBLE.fieldOf("variation").orElse((Object)1.2).forGetter(layer -> layer.variation))).apply((Applicative)instance, PerlinZoomLayer::new));
    private final double scale;
    private final double strength;
    private final double variation;
    private transient PerlinNoise xOffsetNoise = new PerlinNoise();
    private transient PerlinNoise zOffsetNoise = new PerlinNoise();

    public PerlinZoomLayer(String id, long seed, String parent, double scale, double strength, double variation) {
        super(id, seed, parent);
        this.scale = scale;
        this.strength = strength;
        this.variation = variation;
    }

    @Override
    public void init(long worldSeed) {
        super.init(worldSeed);
        Random noiseRandom = new Random(this.getSaltedSeed());
        this.xOffsetNoise = new PerlinNoise(noiseRandom, true);
        this.zOffsetNoise = new PerlinNoise(noiseRandom, true);
    }

    @Override
    public void initUnsalted() {
        super.initUnsalted();
        Random noiseRandom = new Random(this.getSaltedSeed());
        this.xOffsetNoise = new PerlinNoise(noiseRandom, true);
        this.zOffsetNoise = new PerlinNoise(noiseRandom, true);
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.PERLIN_ZOOM;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        int zoomedX = (int)Math.round((double)x / this.scale + this.xOffsetNoise.sample((double)x * this.variation / this.scale, (double)z * this.variation / this.scale) * this.strength);
        int zoomedZ = (int)Math.round((double)z / this.scale + this.zOffsetNoise.sample((double)x * this.variation / this.scale, (double)z * this.variation / this.scale) * this.strength);
        return this.parentLayer.sample(zoomedX, zoomedZ);
    }
}

