/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.voronoi;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiComparable;

public class VoronoiPointRules<T, S extends VoronoiComparable<S>> {
    private final List<VoronoiPoint<T, S>> voronoiPoints;

    private VoronoiPointRules(List<VoronoiPoint<T, S>> voronoiPoints) {
        this.voronoiPoints = ImmutableList.copyOf(voronoiPoints);
    }

    public T calculateClosestTo(S comparable) {
        T closestPoint = null;
        double closestDistance = Double.MAX_VALUE;
        for (VoronoiPoint<T, S> point : this.voronoiPoints) {
            double distance = point.comparable().calculateDistanceTo(comparable);
            if (!(distance < closestDistance)) continue;
            closestPoint = point.item();
            closestDistance = distance;
        }
        return closestPoint;
    }

    public List<VoronoiPoint<T, S>> getRules() {
        return this.voronoiPoints;
    }

    public List<T> getItems() {
        return this.voronoiPoints.stream().filter(p -> p.item() != null).map(p -> p.item()).toList();
    }

    private record VoronoiPoint<T, S extends VoronoiComparable<S>>(T item, S comparable) {
    }

    public static class Builder<T, S extends VoronoiComparable<S>> {
        private final List<VoronoiPoint<T, S>> voronoiPoints = new ArrayList<VoronoiPoint<T, S>>();

        public Builder<T, S> add(T item, S comparable) {
            this.voronoiPoints.add(new VoronoiPoint<T, S>(item, comparable));
            return this;
        }

        public VoronoiPointRules<T, S> build() {
            return new VoronoiPointRules<T, S>(this.voronoiPoints);
        }
    }
}

