/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.carver;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.carver.BetaCaveCarverConfig;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2939;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_5871;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6575;
import net.minecraft.class_6643;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class BetaCaveCarver
extends class_2939<BetaCaveCarverConfig> {
    public BetaCaveCarver(Codec<BetaCaveCarverConfig> caveCodec) {
        super(caveCodec);
    }

    public boolean shouldCarve(BetaCaveCarverConfig config, class_5819 random) {
        return true;
    }

    public boolean carve(class_5873 context, BetaCaveCarverConfig config, class_2791 mainChunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_5819 random, class_6350 aquiferSampler, class_1923 pos, class_6643 carvingMask) {
        boolean useFixedCaves = config.useFixedCaves.orElse(false);
        int caveCount = random.method_43048(random.method_43048(random.method_43048(40) + 1) + 1);
        if (random.method_43048(this.getMaxCaveCount()) != 0) {
            caveCount = 0;
        }
        for (int i = 0; i < caveCount; ++i) {
            double x = pos.method_33939(random.method_43048(16));
            double y = config.field_31488.method_35391(random, (class_5868)context);
            double z = pos.method_33941(random.method_43048(16));
            double horizontalScale = config.field_31492.method_33920(random);
            double verticalScale = config.field_31493.method_33920(random);
            double floorLevel = config.field_31494.method_33920(random);
            class_2939.class_5874 skipPredicate = (carverContext, scaledRelativeX, scaledRelativeY, scaledRelativeZ, relativeY) -> !this.isPositionExcluded(scaledRelativeX, scaledRelativeY, scaledRelativeZ, floorLevel);
            int tunnelCount = 1;
            if (random.method_43048(4) == 0) {
                double yScale = config.field_31489.method_33920(random);
                this.carveCave(context, config, mainChunk, posToBiome, random, mainChunk.method_12004().field_9181, mainChunk.method_12004().field_9180, x, y, z, yScale, skipPredicate, carvingMask, aquiferSampler, useFixedCaves);
                tunnelCount += random.method_43048(4);
            }
            for (int j = 0; j < tunnelCount; ++j) {
                float yaw = random.method_43057() * 3.141593f * 2.0f;
                float pitch = (random.method_43057() - 0.5f) * 2.0f / 8.0f;
                float width = this.getTunnelSystemWidth(random, useFixedCaves);
                this.carveTunnels(context, config, mainChunk, posToBiome, random, mainChunk.method_12004().field_9181, mainChunk.method_12004().field_9180, x, y, z, horizontalScale, verticalScale, width, yaw, pitch, 0, 0, 1.0, skipPredicate, carvingMask, aquiferSampler, useFixedCaves);
            }
        }
        return true;
    }

    private void carveCave(class_5873 context, BetaCaveCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_5819 random, int mainChunkX, int mainChunkZ, double x, double y, double z, double yScale, class_2939.class_5874 skipPredicate, class_6643 carvingMask, class_6350 aquiferSampler, boolean useFixedCaves) {
        this.carveTunnels(context, config, chunk, posToBiome, random, mainChunkX, mainChunkZ, x, y, z, 1.0, 1.0, 1.0f + random.method_43057() * 6.0f, 0.0f, 0.0f, -1, -1, yScale, skipPredicate, carvingMask, aquiferSampler, useFixedCaves);
    }

    private void carveTunnels(class_5873 context, BetaCaveCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_5819 initialRandom, int mainChunkX, int mainChunkZ, double x, double y, double z, double horizontalScale, double verticalScale, float width, float yaw, float pitch, int branch, int branchCount, double yawPitchRatio, class_2939.class_5874 skipPredicate, class_6643 carvingMask, class_6350 aquiferSampler, boolean useFixedCaves) {
        boolean vary;
        float f2 = 0.0f;
        float f3 = 0.0f;
        class_6575 random = new class_6575(initialRandom.method_43055());
        if (branchCount <= 0) {
            int someNumMaxStarts = 112;
            branchCount = someNumMaxStarts - random.method_43048(someNumMaxStarts / 4);
        }
        boolean noStarts = false;
        if (branch == -1) {
            branch = branchCount / 2;
            noStarts = true;
        }
        int randBranch = random.method_43048(branchCount / 2) + branchCount / 4;
        boolean bl = vary = random.method_43048(6) == 0;
        while (branch < branchCount) {
            double tunnelHorizontalScale = 1.5 + (double)(class_3532.method_15374((float)((float)branch * 3.141593f / (float)branchCount)) * width * 1.0f);
            double tunnelVerticalScale = tunnelHorizontalScale * yawPitchRatio;
            float f4 = class_3532.method_15362((float)pitch);
            float f5 = class_3532.method_15374((float)pitch);
            x += (double)(class_3532.method_15362((float)yaw) * f4);
            y += (double)f5;
            z += (double)(class_3532.method_15374((float)yaw) * f4);
            pitch *= vary ? 0.92f : 0.7f;
            pitch += f3 * 0.1f;
            yaw += f2 * 0.1f;
            f3 *= 0.9f;
            f2 *= 0.75f;
            f3 += (random.method_43057() - random.method_43057()) * random.method_43057() * 2.0f;
            f2 += (random.method_43057() - random.method_43057()) * random.method_43057() * 4.0f;
            if (!noStarts && branch == randBranch && width > 1.0f) {
                this.carveTunnels(context, config, chunk, posToBiome, (class_5819)(useFixedCaves ? random : initialRandom), mainChunkX, mainChunkZ, x, y, z, horizontalScale, verticalScale, random.method_43057() * 0.5f + 0.5f, yaw - 1.570796f, pitch / 3.0f, branch, branchCount, 1.0, skipPredicate, carvingMask, aquiferSampler, useFixedCaves);
                this.carveTunnels(context, config, chunk, posToBiome, (class_5819)(useFixedCaves ? random : initialRandom), mainChunkX, mainChunkZ, x, y, z, horizontalScale, verticalScale, random.method_43057() * 0.5f + 0.5f, yaw + 1.570796f, pitch / 3.0f, branch, branchCount, 1.0, skipPredicate, carvingMask, aquiferSampler, useFixedCaves);
                return;
            }
            if (noStarts || random.method_43048(4) != 0) {
                if (!this.canCarveBranch(mainChunkX, mainChunkZ, x, z, branch, branchCount, width)) {
                    return;
                }
                this.carveRegion(context, config, chunk, posToBiome, mainChunkX, mainChunkZ, x, y, z, tunnelHorizontalScale * horizontalScale, tunnelVerticalScale * verticalScale, skipPredicate, carvingMask, aquiferSampler);
                if (noStarts) break;
            }
            ++branch;
        }
    }

    private boolean carveRegion(class_5873 context, BetaCaveCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, int mainChunkX, int mainChunkZ, double x, double y, double z, double horizontalScale, double verticalScale, class_2939.class_5874 skipPredicate, class_6643 carvingMask, class_6350 aquiferSampler) {
        double ctrX = mainChunkX * 16 + 8;
        double ctrZ = mainChunkZ * 16 + 8;
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338.class_2339 tmp = new class_2338.class_2339();
        if (x < ctrX - 16.0 - horizontalScale * 2.0 || z < ctrZ - 16.0 - horizontalScale * 2.0 || x > ctrX + 16.0 + horizontalScale * 2.0 || z > ctrZ + 16.0 + horizontalScale * 2.0) {
            return false;
        }
        int mainChunkStartX = mainChunkX * 16;
        int mainChunkStartZ = mainChunkZ * 16;
        int minX = class_3532.method_15357((double)(x - horizontalScale)) - mainChunkStartX - 1;
        int maxX = class_3532.method_15357((double)(x + horizontalScale)) - mainChunkStartX + 1;
        int minY = class_3532.method_15357((double)(y - verticalScale)) - 1;
        int maxY = class_3532.method_15357((double)(y + verticalScale)) + 1;
        int minZ = class_3532.method_15357((double)(z - horizontalScale)) - mainChunkStartZ - 1;
        int maxZ = class_3532.method_15357((double)(z + horizontalScale)) - mainChunkStartZ + 1;
        if (minX < 0) {
            minX = 0;
        }
        if (maxX > 16) {
            maxX = 16;
        }
        if (minY < context.method_30462() + 1) {
            minY = context.method_30462() + 1;
        }
        if (maxY > context.method_30462() + context.method_30458() - 8) {
            maxY = context.method_30462() + context.method_30458() - 8;
        }
        if (minZ < 0) {
            minZ = 0;
        }
        if (maxZ > 16) {
            maxZ = 16;
        }
        if (this.isRegionUncarvable(context, config, chunk, mainChunkX, mainChunkZ, minX, maxX, minY, maxY, minZ, maxZ)) {
            return false;
        }
        boolean carved = false;
        for (int localX = minX; localX < maxX; ++localX) {
            int offsetX = chunk.method_12004().method_33939(localX);
            double scaledRelX = ((double)(localX + mainChunkX * 16) + 0.5 - x) / horizontalScale;
            for (int localZ = minZ; localZ < maxZ; ++localZ) {
                int offsetZ = chunk.method_12004().method_33941(localZ);
                double scaledRelZ = ((double)(localZ + mainChunkZ * 16) + 0.5 - z) / horizontalScale;
                MutableBoolean replacedGrassy = new MutableBoolean(false);
                for (int localY = maxY; localY > minY; --localY) {
                    double scaledRelY = ((double)(localY - 1) + 0.5 - y) / verticalScale;
                    if (skipPredicate.shouldSkip(context, scaledRelX, scaledRelY, scaledRelZ, localY) || carvingMask.method_38868(localX, localY, localZ)) continue;
                    carvingMask.method_38865(localX, localY, localZ);
                    pos.method_10103(offsetX, localY, offsetZ);
                    carved |= this.carveAtPoint(context, config, chunk, posToBiome, carvingMask, pos, tmp, aquiferSampler, replacedGrassy);
                }
            }
        }
        return carved;
    }

    protected boolean carveAtPoint(class_5873 context, BetaCaveCarverConfig config, class_2791 chunk, Function<class_2338, class_6880<class_1959>> posToBiome, class_6643 carvingMask, class_2338.class_2339 pos, class_2338.class_2339 tmp, class_6350 aquiferSampler, MutableBoolean replacedGrassy) {
        boolean useSurfaceRules = config.useSurfaceRules.orElse(false);
        if (useSurfaceRules) {
            return super.method_16581(context, (class_5871)config, chunk, posToBiome, carvingMask, pos, tmp, aquiferSampler, replacedGrassy);
        }
        class_2680 state = chunk.method_8320((class_2338)pos);
        boolean replacedGrass = false;
        if (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10402)) {
            replacedGrass = true;
        }
        if (state.method_40143(config.field_38864)) {
            class_2680 carverState = this.getState(context, config, (class_2338)pos, aquiferSampler);
            if (carverState == null) {
                return false;
            }
            VersionCompat.setBlockState(chunk, (class_2338)pos, carverState);
            if (aquiferSampler.method_33742() && !carverState.method_26227().method_15769()) {
                chunk.method_12039((class_2338)pos);
            }
            if (replacedGrass) {
                tmp.method_25505((class_2382)pos, class_2350.field_11033);
                if (chunk.method_8320((class_2338)tmp).method_27852(class_2246.field_10566)) {
                    VersionCompat.setBlockState(chunk, (class_2338)tmp, BlockStates.GRASS_BLOCK);
                }
            }
            return true;
        }
        return false;
    }

    public class_2680 getState(class_5873 context, BetaCaveCarverConfig config, class_2338 pos, class_6350 aquiferSampler) {
        int z;
        int y;
        if (pos.method_10264() <= config.field_31490.method_33844((class_5868)context)) {
            return BlockStates.LAVA;
        }
        boolean useAquifers = config.useAquifers.orElse(false);
        if (!useAquifers) {
            return BlockStates.AIR;
        }
        int x = pos.method_10263();
        class_2680 state = aquiferSampler.method_38317((class_6910.class_6912)new class_6910.class_6914(x, y = pos.method_10264(), z = pos.method_10260()), 0.0);
        if (state == null) {
            return BetaCaveCarver.isDebug((class_5871)config) ? config.field_29053.method_36416() : null;
        }
        return BetaCaveCarver.isDebug((class_5871)config) ? BetaCaveCarver.getDebugState((class_5871)config, state) : state;
    }

    private boolean canCarveBranch(int mainChunkX, int mainChunkZ, double x, double z, int branch, int branchCount, float baseWidth) {
        double ctrX = mainChunkX * 16 + 8;
        double d1 = x - ctrX;
        double ctrZ = mainChunkZ * 16 + 8;
        double d2 = z - ctrZ;
        double d3 = branchCount - branch;
        double d4 = baseWidth + 2.0f + 16.0f;
        return !(d1 * d1 + d2 * d2 - d3 * d3 > d4 * d4);
    }

    private boolean isRegionUncarvable(class_5873 context, BetaCaveCarverConfig config, class_2791 chunk, int mainChunkX, int mainChunkZ, int relMinX, int relMaxX, int minY, int maxY, int relMinZ, int relMaxZ) {
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        boolean useAquifers = config.useAquifers.orElse(false);
        for (int relX = relMinX; relX < relMaxX; ++relX) {
            for (int relZ = relMinZ; relZ < relMaxZ; ++relZ) {
                for (int relY = maxY + 1; relY >= minY - 1; --relY) {
                    if (relY < context.method_30462() || relY >= context.method_30462() + context.method_30458()) continue;
                    int lavaLevel = config.field_31490.method_33844((class_5868)context);
                    class_2248 block = chunk.method_8320((class_2338)blockPos.method_10103(relX, relY, relZ)).method_26204();
                    if (!useAquifers && block == class_2246.field_10382) {
                        return true;
                    }
                    if (!useAquifers && block == class_2246.field_10164 && relY > lavaLevel) {
                        return true;
                    }
                    if (relY == minY - 1 || !this.isOnBoundary(relMinX, relMaxX, relMinZ, relMaxZ, relX, relZ)) continue;
                    relY = minY;
                }
            }
        }
        return false;
    }

    private boolean isPositionExcluded(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, double floorY) {
        return scaledRelativeY > floorY && scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ < 1.0;
    }

    private boolean isOnBoundary(int minX, int maxX, int minZ, int maxZ, int relX, int relZ) {
        return relX != minX && relX != maxX - 1 && relZ != minZ && relZ != maxZ - 1;
    }

    protected int getCaveY(class_5873 context, class_5819 random) {
        return random.method_43048(random.method_43048(120) + 8);
    }

    protected int getMaxCaveCount() {
        return 15;
    }

    protected float getTunnelSystemWidth(class_5819 random, boolean useFixedCaves) {
        float width = random.method_43057() * 2.0f + random.method_43057();
        if (useFixedCaves && random.method_43048(10) == 0) {
            width *= random.method_43057() * random.method_43057() * 3.0f + 1.0f;
        }
        return width;
    }

    private static class_2680 getDebugState(class_5871 config, class_2680 state) {
        if (state.method_27852(class_2246.field_10124)) {
            return config.field_29053.method_33973();
        }
        if (state.method_27852(class_2246.field_10382)) {
            class_2680 waterState = config.field_29053.method_36414();
            if (waterState.method_28498((class_2769)class_2741.field_12508)) {
                return (class_2680)waterState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
            }
            return waterState;
        }
        if (state.method_27852(class_2246.field_10164)) {
            return config.field_29053.method_36415();
        }
        return state;
    }

    private static boolean isDebug(class_5871 config) {
        return config.field_29053.method_33970();
    }
}

