/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.ForcedBiomeHeight;
import mod.bluestaggo.modernerbeta.world.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.class_1966;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public abstract class ChunkProviderForcedHeight
extends ChunkProviderNoise {
    private final int heightSampleRadius;
    private final float[] biomeHeightWeights;
    private final Map<ExtendedBiomeId, HeightConfig> biomeHeightValues;
    private final ForcedBiomeHeight forcedBiomeHeight = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FORCED_BIOME_HEIGHT);

    public ChunkProviderForcedHeight(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.biomeHeightValues = Stream.concat(this.forcedBiomeHeight.heightOverrides().entrySet().stream(), ModernBetaRegistries.HEIGHT_CONFIG.method_40270().filter(class_6880::method_40227).flatMap(entry -> {
            class_6862 heightConfigTag = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)((class_5321)entry.method_40230().orElseThrow()).method_29177());
            HeightConfig heightConfig = (HeightConfig)entry.comp_349();
            return chunkGenerator.method_12098().method_28443().stream().filter(biome -> biome.method_40220(heightConfigTag)).map(biome -> ExtendedBiomeId.of(((class_5321)biome.method_40230().orElseThrow()).method_29177(), heightConfig.type())).filter(extId -> !this.forcedBiomeHeight.heightOverrides().containsKey(extId)).map(extId -> Map.entry(extId, heightConfig));
        })).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (base, duplicate) -> base));
        int hsr = this.heightSampleRadius = this.getHeightSampleRadius();
        int hsd = 2 * this.heightSampleRadius + 1;
        this.biomeHeightWeights = new float[hsd * hsd];
        for (int x = -hsr; x <= hsr; ++x) {
            for (int z = -hsr; z <= hsr; ++z) {
                this.biomeHeightWeights[x + hsr + (z + hsr) * hsd] = this.calculateBiomeHeightWeight(x, z);
            }
        }
    }

    public ExtendedBiomeId getExtendedBiomeId(int biomeX, int biomeZ) {
        class_1966 class_19662 = this.chunkGenerator.method_12098();
        if (class_19662 instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)class_19662;
            return modernBetaBiomeSource.getBiomeForHeightGen(biomeX, 16, biomeZ);
        }
        return ExtendedBiomeId.of(((class_5321)this.getBiome(biomeX, 16, biomeZ, null).method_40230().orElseThrow()).method_29177());
    }

    public HeightConfig getHeightConfigOfBiome(ExtendedBiomeId extendedBiomeId) {
        return this.biomeHeightValues.getOrDefault(extendedBiomeId, HeightConfig.DEFAULT);
    }

    public HeightConfig getRawHeightConfigAt(int x, int z) {
        return this.getHeightConfigOfBiome(this.getExtendedBiomeId(x, z));
    }

    public HeightConfig getHeightConfigAt(int noiseX, int noiseZ) {
        float scale = 0.0f;
        float depth = 0.0f;
        float totalWeight = 0.0f;
        ExtendedBiomeId biome = this.getExtendedBiomeId(noiseX, noiseZ);
        double minSurfaceHeight = this.getHeightConfigOfBiome(biome).depth();
        int hsr = this.heightSampleRadius;
        int hsd = 2 * this.heightSampleRadius + 1;
        for (int biomeX = -hsr; biomeX <= hsr; ++biomeX) {
            for (int biomeZ = -hsr; biomeZ <= hsr; ++biomeZ) {
                float weight = this.biomeHeightWeights[biomeX + hsr + (biomeZ + hsr) * hsd];
                if (weight <= 0.0f) continue;
                biome = this.getExtendedBiomeId(noiseX + biomeX, noiseZ + biomeZ);
                HeightConfig heightConfig = this.getHeightConfigOfBiome(biome);
                float thisScale = heightConfig.scale();
                float thisDepth = heightConfig.depth();
                if (!this.forcedBiomeHeight.modifyOnlyPositiveDepth() || thisDepth > 0.0f) {
                    thisScale = this.forcedBiomeHeight.scaleOffset() + thisScale * this.forcedBiomeHeight.scaleWeight();
                    thisDepth = this.forcedBiomeHeight.depthOffset() + thisDepth * this.forcedBiomeHeight.depthWeight();
                }
                weight /= Math.max(thisDepth + 2.0f, 0.01f);
                if ((double)heightConfig.depth() > minSurfaceHeight) {
                    weight /= 2.0f;
                }
                scale += thisScale * weight;
                depth += thisDepth * weight;
                totalWeight += weight;
            }
        }
        scale /= totalWeight;
        depth /= totalWeight;
        scale = scale * 0.9f + 0.1f;
        depth = (depth * 4.0f - 1.0f) / 8.0f;
        return new HeightConfig(depth, scale);
    }

    protected int getHeightSampleRadius() {
        return 2;
    }

    protected float calculateBiomeHeightWeight(int x, int z) {
        return 10.0f / class_3532.method_15355((float)((float)(x * x + z * z) + 0.2f));
    }
}

