/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.gui.screen;

import com.google.common.util.concurrent.AtomicDouble;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverExtendedId;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverExtendedIdStepped;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverStepped;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.world.provider.BiomeProviderType;
import mod.bluestaggo.modernerbeta.client.gui.screen.ModernBetaScreen;
import mod.bluestaggo.modernerbeta.mixin.client.AccessorScreenshotRecorder;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_6673;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7193;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8021;
import org.slf4j.event.Level;

@Environment(value=EnvType.CLIENT)
public class ModernBetaBiomePreviewScreen
extends ModernBetaScreen {
    private final BiomeProvider biomeProvider;
    private BiomeDisplayWidget biomeDisplay;
    private volatile String exceptionMessage;

    public ModernBetaBiomePreviewScreen(class_2561 title, class_437 parent, class_7193 generationOptions, ModernBetaSettings biomeSettings) {
        super(title, parent);
        Object biomeProvider = null;
        try {
            biomeProvider = ((BiomeProviderType)ModernBetaRegistries.BIOME.method_10223(biomeSettings.getProvider())).apply(biomeSettings, (class_7871<class_1959>)generationOptions.method_45689().method_46762(class_7924.field_41236), generationOptions.comp_616().method_28028());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exceptionMessage = exception.getLocalizedMessage();
        }
        this.biomeProvider = biomeProvider;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.biomeDisplay != null) {
            this.biomeDisplay.close();
        }
        this.biomeDisplay = new BiomeDisplayWidget(0, 0, this.field_22789 * 3 / 4, this.field_22790 * 3 / 4);
        boolean hasSteps = this.biomeProvider instanceof BiomeResolverStepped;
        class_4185 buttonZoomOut = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), button -> this.biomeDisplay.zoomOut()).method_46434(0, 0, 20, 20).method_46431();
        class_4185 buttonZoomIn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> this.biomeDisplay.zoomIn()).method_46434(0, 0, 20, 20).method_46431();
        class_4185 buttonScreenshot = class_4185.method_46430((class_2561)class_2561.method_43471((String)"createWorld.customize.modern_beta.settings.screenshot"), button -> this.biomeDisplay.saveScreenshot()).method_46434(0, 0, 100, 20).method_46431();
        class_4185 buttonBack = class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)).method_46434(0, 0, 100, 20).method_46431();
        class_7845 gridWidgetMain = this.createGridWidget();
        class_7845 gridWidgetButtons = this.createGridWidget();
        gridWidgetMain.method_46458().method_46467().method_46474();
        class_7845.class_7939 gridAdderMain = gridWidgetMain.method_47610(1);
        class_7845.class_7939 gridAdderButtons = gridWidgetButtons.method_47610(hasSteps ? 6 : 4);
        gridAdderMain.method_47612((class_8021)this.biomeDisplay);
        gridAdderMain.method_47612((class_8021)gridWidgetButtons);
        gridAdderButtons.method_47612((class_8021)buttonZoomOut);
        gridAdderButtons.method_47612((class_8021)buttonZoomIn);
        if (hasSteps) {
            BiomeResolverStepped stepResolver = (BiomeResolverStepped)((Object)this.biomeProvider);
            int stepCount = stepResolver.getStepCount();
            this.biomeDisplay.step.set(stepCount - 1);
            class_4185 buttonPrevStep = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), button -> {
                this.biomeDisplay.step.getAndUpdate(i -> Math.floorMod(i - 1, stepCount));
                this.biomeDisplay.clear();
            }).method_46434(0, 0, 20, 20).method_46431();
            class_4185 buttonNextStep = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), button -> {
                this.biomeDisplay.step.getAndUpdate(i -> Math.floorMod(i + 1, stepCount));
                this.biomeDisplay.clear();
            }).method_46434(0, 0, 20, 20).method_46431();
            gridAdderButtons.method_47612((class_8021)buttonPrevStep);
            gridAdderButtons.method_47612((class_8021)buttonNextStep);
        }
        gridAdderButtons.method_47612((class_8021)buttonScreenshot);
        gridAdderButtons.method_47612((class_8021)buttonBack);
        gridWidgetMain.method_48222();
        class_7843.method_46443((class_8021)gridWidgetMain, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (float)0.5f, (float)1.0f);
        gridWidgetMain.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.biomeDisplay.startRenderThread();
    }

    public void method_25432() {
        this.biomeDisplay.close();
    }

    class BiomeDisplayWidget
    extends class_339
    implements AutoCloseable {
        static final class_2960 TEXTURE_ID = ModernerBeta.createId("biome_preview");
        static final int EMPTY_COLOR = 0x7F000000;
        final class_1060 textureManager;
        final class_1011 image;
        final class_1043 texture;
        final BiomeRenderThread renderThread;
        final AtomicInteger zoomOut;
        final AtomicInteger zoomIn;
        final AtomicInteger step;
        int prevMouseX;
        int prevMouseY;
        final AtomicDouble offsetX;
        final AtomicDouble offsetY;

        BiomeDisplayWidget(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.zoomOut = new AtomicInteger(1);
            this.zoomIn = new AtomicInteger(1);
            this.step = new AtomicInteger();
            this.offsetX = new AtomicDouble();
            this.offsetY = new AtomicDouble();
            assert (ModernBetaBiomePreviewScreen.this.field_22787 != null);
            this.image = new class_1011(width, height, false);
            this.image.method_4326(0, 0, width, height, 0x7F000000);
            this.texture = new class_1043(this.image);
            this.texture.method_4524();
            this.textureManager = ModernBetaBiomePreviewScreen.this.field_22787.method_1531();
            this.textureManager.method_4616(TEXTURE_ID, (class_1044)this.texture);
            this.renderThread = new BiomeRenderThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            Object object = this.image;
            synchronized (object) {
                this.image.method_4326(0, 0, this.field_22758, this.field_22759, 0x7F000000);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        void zoomOut() {
            if (this.zoomIn.get() > 1) {
                this.zoomIn.getAndUpdate(i -> i / 2);
            } else if (this.zoomOut.get() < 0x1000000) {
                this.zoomOut.getAndUpdate(i -> i * 2);
            } else {
                return;
            }
            this.offsetX.getAndUpdate(i -> i / 2.0);
            this.offsetY.getAndUpdate(i -> i / 2.0);
            this.clear();
        }

        void zoomIn() {
            if (this.zoomOut.get() <= 1) {
                if (this.zoomIn.get() >= 0x1000000) {
                    return;
                }
                this.zoomIn.getAndUpdate(i -> i * 2);
            } else {
                this.zoomOut.getAndUpdate(i -> i / 2);
            }
            this.offsetX.getAndUpdate(i -> i * 2.0);
            this.offsetY.getAndUpdate(i -> i * 2.0);
            this.clear();
        }

        void startRenderThread() {
            this.renderThread.start();
        }

        void saveScreenshot() {
            assert (ModernBetaBiomePreviewScreen.this.field_22787 != null);
            File screenshotDirectory = new File(((ModernBetaBiomePreviewScreen)ModernBetaBiomePreviewScreen.this).field_22787.field_1697, "screenshots");
            screenshotDirectory.mkdir();
            File screenshotPath = AccessorScreenshotRecorder.invokeGetScreenshotFilename(screenshotDirectory);
            class_156.method_27958().execute(() -> {
                try {
                    this.image.method_4325(screenshotPath);
                }
                catch (Exception exception) {
                    ModernerBeta.log(Level.WARN, "Couldn't save screenshot: " + String.valueOf(exception));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            double zoomLevel;
            int step = this.step.get();
            if (this.renderThread.uploadRequested) {
                class_1011 class_10112 = this.image;
                synchronized (class_10112) {
                    this.texture.method_4524();
                }
            }
            context.method_25290(TEXTURE_ID, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
            BiomeProvider biomeProvider = ModernBetaBiomePreviewScreen.this.biomeProvider;
            if (biomeProvider instanceof BiomeResolverStepped) {
                BiomeResolverStepped resolverStepped = (BiomeResolverStepped)((Object)biomeProvider);
                class_5250 stepName = class_2561.method_43470((String)(step + 1 + "/" + resolverStepped.getStepCount() + " - "));
                stepName.method_10852(resolverStepped.getStepName(step));
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + ModernBetaBiomePreviewScreen.this.field_22793.method_27525((class_5348)stepName) + 8, this.method_46427() + 16, -1442840576);
                context.method_51439(ModernBetaBiomePreviewScreen.this.field_22793, (class_2561)stepName, this.method_46426() + 4, this.method_46427() + 4, -1, false);
            }
            class_5250 zoomLabel = class_2561.method_43470((String)("1:" + ((zoomLevel = (double)this.zoomOut.get() * 4.0 / (double)this.zoomIn.get()) % 1.0 == 0.0 ? Integer.toString((int)zoomLevel) : Double.toString(zoomLevel))));
            int zoomLabelWidth = ModernBetaBiomePreviewScreen.this.field_22793.method_27525((class_5348)zoomLabel);
            context.method_25294(this.method_46426() + this.method_25368() - zoomLabelWidth - 8, this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + 16, -1442840576);
            context.method_51439(ModernBetaBiomePreviewScreen.this.field_22793, (class_2561)zoomLabel, this.method_46426() + this.method_25368() - zoomLabelWidth - 4, this.method_46427() + 4, -1, false);
            if (ModernBetaBiomePreviewScreen.this.exceptionMessage != null) {
                context.method_27534(ModernBetaBiomePreviewScreen.this.field_22793, (class_2561)class_2561.method_43470((String)ModernBetaBiomePreviewScreen.this.exceptionMessage).method_27692(class_124.field_1061), this.method_46426() + this.method_25368() / 2, this.method_46427() + this.method_25364() / 2 - 4, -1);
            }
            int offsetMouseX = mouseX - this.method_46426();
            int offsetMouseY = mouseY - this.method_46427();
            if (ModernBetaBiomePreviewScreen.this.biomeProvider != null && offsetMouseX >= 0 && offsetMouseY >= 0 && offsetMouseX < this.field_22758 && offsetMouseY < this.field_22759) {
                class_2561 class_25612;
                int sampleX = (offsetMouseX + (int)Math.round(this.offsetX.get()) - this.field_22758 / 2) * this.zoomOut.get() / this.zoomIn.get();
                int sampleY = (offsetMouseY + (int)Math.round(this.offsetY.get()) - this.field_22759 / 2) * this.zoomOut.get() / this.zoomIn.get();
                BiomeProvider biomeProvider2 = ModernBetaBiomePreviewScreen.this.biomeProvider;
                if (biomeProvider2 instanceof BiomeResolverStepped) {
                    BiomeResolverStepped resolverStepped = (BiomeResolverStepped)((Object)biomeProvider2);
                    class_25612 = resolverStepped.getBiomeNameForStep(sampleX, 64, sampleY, step);
                } else {
                    class_25612 = ModernBetaBiomePreviewScreen.this.biomeProvider.getBiomeName(sampleX, 64, sampleY);
                }
                class_2561 biomeName = class_25612;
                context.method_51434(ModernBetaBiomePreviewScreen.this.field_22793, List.of(class_2561.method_43470((String)(sampleX * 4 + ", " + sampleY * 4)), biomeName), mouseX, mouseY);
            }
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
            assert (ModernBetaBiomePreviewScreen.this.field_22787 != null);
            double prevOffsetX = this.offsetX.getAndAdd(-deltaX);
            double prevOffsetY = this.offsetY.getAndAdd(-deltaY);
            int diffOffsetX = (int)Math.round(this.offsetX.get()) - (int)Math.round(prevOffsetX);
            int diffOffsetY = (int)Math.round(this.offsetY.get()) - (int)Math.round(prevOffsetY);
            Object object = this.image;
            synchronized (object) {
                int[] pixels = this.image.method_48463();
                int i = 0;
                this.image.method_4326(0, 0, this.field_22758, this.field_22759, 0x7F000000);
                for (int srcY = 0; srcY < this.field_22759; ++srcY) {
                    for (int srcX = 0; srcX < this.field_22758; ++srcX) {
                        int dstX = srcX - diffOffsetX;
                        int dstY = srcY - diffOffsetY;
                        if (dstX >= 0 && dstX < this.field_22758 && dstY >= 0 && dstY < this.field_22759) {
                            this.image.method_4305(dstX, dstY, pixels[i]);
                        }
                        ++i;
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (verticalAmount < 0.0) {
                this.zoomOut();
                return true;
            }
            if (verticalAmount > 0.0) {
                this.zoomIn();
                return true;
            }
            return false;
        }

        protected void method_47399(class_6382 builder) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.renderThread.stop = true;
            this.texture.close();
            this.textureManager.method_4615(TEXTURE_ID);
            BiomeDisplayWidget biomeDisplayWidget = this;
            synchronized (biomeDisplayWidget) {
                this.notify();
            }
        }

        class BiomeRenderThread
        extends Thread {
            static final Pattern EXT_INT = Pattern.compile("(\\d)+$");
            volatile boolean stop;
            volatile boolean uploadRequested;

            BiomeRenderThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (ModernBetaBiomePreviewScreen.this.biomeProvider == null) {
                    return;
                }
                int genX = -1;
                int genY = 0;
                boolean full = true;
                Int2IntAVLTreeMap randColors = new Int2IntAVLTreeMap();
                Random random = new Random();
                LayerRandom voronoiRandom = new LayerRandom(class_6673.method_39001());
                try {
                    while (!this.stop) {
                        ExtendedBiomeId extendedBiomeId;
                        class_6880<class_1959> class_68802;
                        if (++genX >= BiomeDisplayWidget.this.field_22758) {
                            genX = 0;
                            ++genY;
                        }
                        if (genY >= BiomeDisplayWidget.this.field_22759) {
                            genY = 0;
                            if (full) {
                                BiomeDisplayWidget biomeDisplayWidget = BiomeDisplayWidget.this;
                                // MONITORENTER : biomeDisplayWidget
                                try {
                                    BiomeDisplayWidget.this.wait();
                                }
                                catch (InterruptedException e) {
                                    // MONITOREXIT : biomeDisplayWidget
                                    return;
                                }
                                if (this.stop) {
                                    return;
                                }
                            }
                            full = true;
                        }
                        class_1011 e = BiomeDisplayWidget.this.image;
                        // MONITORENTER : e
                        int baseAlpha = BiomeDisplayWidget.this.image.method_4315(genX, genY) >>> 24;
                        // MONITOREXIT : e
                        if (baseAlpha == 255) continue;
                        full = false;
                        int scale = BiomeDisplayWidget.this.zoomOut.get();
                        int voronoiZoom = BiomeDisplayWidget.this.zoomIn.get();
                        int gridScale = (int)Math.pow(2.0, ((int)(Math.log(scale) / Math.log(2.0)) + 2) / 4 * 4) * voronoiZoom;
                        int intOffX = (int)Math.round(BiomeDisplayWidget.this.offsetX.get());
                        int intOffY = (int)Math.round(BiomeDisplayWidget.this.offsetY.get());
                        int sampleX = (genX + intOffX - BiomeDisplayWidget.this.field_22758 / 2) * scale;
                        int sampleY = (genY + intOffY - BiomeDisplayWidget.this.field_22759 / 2) * scale;
                        int gridSampleX = sampleX;
                        int gridSampleY = sampleY;
                        if (voronoiZoom > 1) {
                            float voronoiFactor = (float)voronoiZoom * 0.9f;
                            int scaledSampleX = Math.floorDiv(sampleX, voronoiZoom);
                            int scaledSampleY = Math.floorDiv(sampleY, voronoiZoom);
                            int subSampleX = Math.floorMod(sampleX, voronoiZoom);
                            int subSampleY = Math.floorMod(sampleY, voronoiZoom);
                            voronoiRandom.init(scaledSampleX, scaledSampleY);
                            float n00x = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            float n00y = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            voronoiRandom.init(scaledSampleX + 1, scaledSampleY);
                            float n10x = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            float n10y = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            voronoiRandom.init(scaledSampleX, scaledSampleY + 1);
                            float n01x = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor;
                            float n01y = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            voronoiRandom.init(scaledSampleX + 1, scaledSampleY + 1);
                            float n11x = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            float n11y = ((float)voronoiRandom.method_43048(1024) / 1024.0f - 0.5f) * voronoiFactor + (float)voronoiZoom;
                            sampleX = scaledSampleX;
                            sampleY = scaledSampleY;
                            float dist00 = class_3532.method_27285((float)((float)subSampleX - n00x)) + class_3532.method_27285((float)((float)subSampleY - n00y));
                            float dist10 = class_3532.method_27285((float)((float)subSampleX - n10x)) + class_3532.method_27285((float)((float)subSampleY - n10y));
                            float dist01 = class_3532.method_27285((float)((float)subSampleX - n01x)) + class_3532.method_27285((float)((float)subSampleY - n01y));
                            float dist11 = class_3532.method_27285((float)((float)subSampleX - n11x)) + class_3532.method_27285((float)((float)subSampleY - n11y));
                            if (dist11 < dist10 && dist11 < dist01 && dist11 < dist00) {
                                ++sampleX;
                                ++sampleY;
                            } else if (dist10 < dist00 && dist10 < dist01 && dist10 < dist11) {
                                ++sampleX;
                            } else if (dist01 < dist00 && dist01 < dist10 && dist01 < dist11) {
                                ++sampleY;
                            }
                        }
                        int step = BiomeDisplayWidget.this.step.get();
                        BiomeProvider subSampleX = ModernBetaBiomePreviewScreen.this.biomeProvider;
                        if (subSampleX instanceof BiomeResolverStepped) {
                            BiomeResolverStepped resolverStepped = (BiomeResolverStepped)((Object)subSampleX);
                            class_68802 = resolverStepped.getBiomeForStep(sampleX, 64, sampleY, step);
                        } else {
                            class_68802 = ModernBetaBiomePreviewScreen.this.biomeProvider.getBiome(sampleX, 64, sampleY);
                        }
                        class_6880<class_1959> biome = class_68802;
                        BiomeProvider n00x = ModernBetaBiomePreviewScreen.this.biomeProvider;
                        if (n00x instanceof BiomeResolverExtendedId) {
                            BiomeResolverExtendedId resolverExtendedId = (BiomeResolverExtendedId)((Object)n00x);
                            if (resolverExtendedId instanceof BiomeResolverExtendedIdStepped) {
                                BiomeResolverExtendedIdStepped resolverExtendedIdStepped = (BiomeResolverExtendedIdStepped)resolverExtendedId;
                                extendedBiomeId = resolverExtendedIdStepped.getExtendedBiomeIdForStep(sampleX, 64, sampleY, step);
                            } else {
                                extendedBiomeId = resolverExtendedId.getExtendedBiomeId(sampleX, 64, sampleY);
                            }
                        } else {
                            extendedBiomeId = ExtendedBiomeId.NULL;
                        }
                        ExtendedBiomeId extendedBiome = extendedBiomeId;
                        int color = this.getBiomeColor(biome, extendedBiome.ext(), sampleX, sampleY, (Int2IntMap)randColors, random);
                        if (gridSampleX % (64 * gridScale) == 0 || gridSampleY % (64 * gridScale) == 0) {
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color & 0xFF;
                            r = class_3532.method_48781((float)0.33333334f, (int)r, (int)255);
                            g = class_3532.method_48781((float)0.33333334f, (int)g, (int)255);
                            b = class_3532.method_48781((float)0.33333334f, (int)b, (int)255);
                            color = r << 16 | g << 8 | b;
                        } else if (gridSampleX % (4 * gridScale) == 0 || gridSampleY % (4 * gridScale) == 0) {
                            int r = color >> 16 & 0xFF;
                            int g = color >> 8 & 0xFF;
                            int b = color & 0xFF;
                            r = class_3532.method_48781((float)0.1f, (int)r, (int)255);
                            g = class_3532.method_48781((float)0.1f, (int)g, (int)255);
                            b = class_3532.method_48781((float)0.1f, (int)b, (int)255);
                            color = r << 16 | g << 8 | b;
                        }
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        color = r | g << 8 | b << 16 | 0xFF000000;
                        class_1011 class_10112 = BiomeDisplayWidget.this.image;
                        // MONITORENTER : class_10112
                        BiomeDisplayWidget.this.image.method_4305(genX, genY, color);
                        this.uploadRequested = true;
                        // MONITOREXIT : class_10112
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    ModernBetaBiomePreviewScreen.this.exceptionMessage = exception.getLocalizedMessage();
                }
            }

            private int getBiomeColor(class_6880<class_1959> biomeEntry, String ext, int x, int y, Int2IntMap randColors, Random random) {
                int color;
                boolean watery;
                Integer registeredColor;
                String id = biomeEntry.method_40230().map(key -> key.method_29177().toString()).orElse("[unregistered]");
                if (ext != null && !ext.isEmpty()) {
                    String extId = id + "*" + ext;
                    Integer registeredExtColor = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BIOME_PREVIEW_COLORS).get(extId);
                    if (registeredExtColor != null) {
                        return registeredExtColor;
                    }
                    Matcher extIntMatcher = EXT_INT.matcher(ext);
                    if (extIntMatcher.find()) {
                        try {
                            int extInt = Integer.parseInt(extIntMatcher.group());
                            return extInt >= 256 ? extInt : randColors.computeIfAbsent(Integer.parseInt(extIntMatcher.group()), i -> random.nextInt(0xFFFFFF));
                        }
                        catch (Exception extInt) {
                            // empty catch block
                        }
                    }
                }
                if ((registeredColor = ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BIOME_PREVIEW_COLORS).get(id)) != null) {
                    return registeredColor;
                }
                class_1959 biome = (class_1959)biomeEntry.comp_349();
                boolean bl = watery = biomeEntry.method_40220(class_6908.field_36509) || biomeEntry.method_40220(class_6908.field_36511);
                if (watery) {
                    color = biome.method_8687();
                    if (biomeEntry.method_40220(class_6908.field_36509)) {
                        color = (color & 0xFEFEFE) >> 1;
                        if (biomeEntry.method_40220(class_6908.field_36508)) {
                            color = (color & 0xFEFEFE) >> 1;
                        }
                    }
                } else {
                    SurfaceConfig surfaceConfig = SurfaceConfig.getSurfaceConfig(biomeEntry);
                    class_2680 topBlock = surfaceConfig.normal().topBlock();
                    color = topBlock.method_27852(class_2246.field_10219) ? biome.method_8711((double)x, (double)y) : topBlock.method_26205(null, (class_2338)new class_2338((int)x, (int)64, (int)y)).field_16011;
                }
                float contrast = 2.0f;
                float[] hsb = new float[3];
                Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsb);
                hsb[1] = class_3532.method_15363((float)(hsb[1] * contrast), (float)0.0f, (float)1.0f);
                hsb[2] = class_3532.method_15363((float)((hsb[2] - 0.5f) * contrast + 0.5f), (float)0.0f, (float)1.0f);
                if (biome.method_8712() < 0.15f && !biomeEntry.method_40220(class_6908.field_36508)) {
                    hsb[1] = hsb[1] * 0.1f;
                    hsb[2] = hsb[2] * 0.25f + 0.75f;
                }
                return Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
            }
        }
    }
}

