/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.fabric.data;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveBiomeVoronoi;
import mod.bluestaggo.modernerbeta.settings.component.CaveGeneration;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import mod.bluestaggo.modernerbeta.settings.component.ClimateScale;
import mod.bluestaggo.modernerbeta.settings.component.DeepslateGeneration;
import mod.bluestaggo.modernerbeta.settings.component.FiniteBeaches;
import mod.bluestaggo.modernerbeta.settings.component.FiniteCaveGeneration;
import mod.bluestaggo.modernerbeta.settings.component.FiniteLevelProperties;
import mod.bluestaggo.modernerbeta.settings.component.FiniteNoise;
import mod.bluestaggo.modernerbeta.settings.component.FinitePools;
import mod.bluestaggo.modernerbeta.settings.component.ForcedBiomeHeight;
import mod.bluestaggo.modernerbeta.settings.component.Infdev227Structures;
import mod.bluestaggo.modernerbeta.settings.component.IslesProperties;
import mod.bluestaggo.modernerbeta.settings.component.NoiseScale;
import mod.bluestaggo.modernerbeta.settings.component.NoiseSlide;
import mod.bluestaggo.modernerbeta.world.biome.HeightConfig;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomes;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMapping;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ConfiguredLayers;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.LayerTarget;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.AddLandLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ApplyOceanClimateLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.BiomeReplacementLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ComputeRiverLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ConditionalOverlayLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ConstantBiomeLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.FuzzyZoomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.InitLandLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.InitRiverLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.MappedNoiseLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.MixRiverLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ModalZoomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.PredicateOverlayLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.RandomBiomeLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SmoothLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.StackedZoomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SupplyRandomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.WeightedPoolLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicate;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.InRangeBiomePredicate;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointBiome;
import mod.bluestaggo.modernerbeta.world.chunk.provider.indev.IndevTheme;
import mod.bluestaggo.modernerbeta.world.chunk.provider.indev.IndevType;
import mod.bluestaggo.modernerbeta.world.chunk.provider.island.IslandShape;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_7891;

public final class ModernBetaSettingsPresets {
    public static final ModernBetaSettingsPreset DEFAULT_BETA = ModernBetaSettingsPresets.presetBeta(false);
    public static final ModernBetaSettingsPreset DEFAULT_MAJOR = ModernBetaSettingsPresets.preset1122(false, 0, false);

    public static void bootstrap(class_7891<ModernBetaSettingsPreset> presetRegisterable) {
        class_2960 betaId = ModernerBeta.createId("beta");
        class_2960 majorId = ModernerBeta.createId("release_1_12_2");
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta"), (Object)DEFAULT_BETA);
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_1_02"), (Object)ModernBetaSettingsPresets.presetBeta(true));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("alpha"), (Object)ModernBetaSettingsPresets.presetAlpha());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("skylands"), (Object)ModernBetaSettingsPresets.presetSkylands());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("infdev_415"), (Object)ModernBetaSettingsPresets.presetInfdev415());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("infdev_420"), (Object)ModernBetaSettingsPresets.presetInfdev420());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("infdev_611"), (Object)ModernBetaSettingsPresets.presetInfdev611());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("infdev_325"), (Object)ModernBetaSettingsPresets.presetInfdev325());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("infdev_227"), (Object)ModernBetaSettingsPresets.presetInfdev227());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("indev"), (Object)ModernBetaSettingsPresets.presetIndev());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("classic_0_30"), (Object)ModernBetaSettingsPresets.presetClassic());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("classic_0_0_14a_08"), (Object)ModernBetaSettingsPresets.presetClassic14a08());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("pe"), (Object)ModernBetaSettingsPresets.presetPE());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_8_1"), (Object)ModernBetaSettingsPresets.presetBeta181(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_9_pre_3"), (Object)ModernBetaSettingsPresets.presetBeta19Pre3(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_0_0"), (Object)ModernBetaSettingsPresets.preset100(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_1"), (Object)ModernBetaSettingsPresets.preset11(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_2_5"), (Object)ModernBetaSettingsPresets.preset125(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_6_4"), (Object)ModernBetaSettingsPresets.preset164(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_12_2"), (Object)DEFAULT_MAJOR);
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_17_1"), (Object)ModernBetaSettingsPresets.preset1171(false, 0, false));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("bedrock_1_2"), (Object)ModernBetaSettingsPresets.preset1122(false, 0, true));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("bedrock_1_17"), (Object)ModernBetaSettingsPresets.preset1171(false, 0, true));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_skylands"), (Object)ModernBetaSettingsPresets.presetBetaSkylands());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_isles"), (Object)ModernBetaSettingsPresets.presetIsles(DEFAULT_BETA, betaId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_water_world"), (Object)ModernBetaSettingsPresets.presetWaterWorld(DEFAULT_BETA, betaId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_isle_land"), (Object)ModernBetaSettingsPresets.presetIsleLand(DEFAULT_BETA, betaId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_cave_delight"), (Object)ModernBetaSettingsPresets.presetCaveDelight(DEFAULT_BETA, betaId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_mountain_madness"), (Object)ModernBetaSettingsPresets.presetMountainMadness(DEFAULT_BETA, betaId, false));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_drought"), (Object)ModernBetaSettingsPresets.presetDrought(DEFAULT_BETA, betaId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_cave_chaos"), (Object)ModernBetaSettingsPresets.presetCaveChaos(DEFAULT_BETA, betaId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_large_biomes"), (Object)ModernBetaSettingsPresets.presetBetaLargeBiomes());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_xbox_legacy"), (Object)ModernBetaSettingsPresets.presetBetaXboxLegacy());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_survival_island"), (Object)ModernBetaSettingsPresets.presetBetaSurvivalIsland());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_vanilla"), (Object)ModernBetaSettingsPresets.presetBetaVanilla());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("legacy_console_classic"), (Object)ModernBetaSettingsPresets.presetReleaseXboxLegacy(864));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("legacy_console_small"), (Object)ModernBetaSettingsPresets.presetReleaseXboxLegacy(1024));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("legacy_console_medium"), (Object)ModernBetaSettingsPresets.presetReleaseXboxLegacy(3072));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("legacy_console_large"), (Object)ModernBetaSettingsPresets.presetReleaseXboxLegacy(5120));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_hybrid"), (Object)ModernBetaSettingsPresets.presetReleaseHybrid(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("snow_aint_snowier"), (Object)ModernBetaSettingsPresets.presetSnowAintSnowier(false, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("alpha_winter"), (Object)ModernBetaSettingsPresets.presetAlphaWinter());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("indev_paradise"), (Object)ModernBetaSettingsPresets.presetIndevParadise());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("indev_woods"), (Object)ModernBetaSettingsPresets.presetIndevWoods());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("indev_hell"), (Object)ModernBetaSettingsPresets.presetIndevHell());
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("water_world"), (Object)ModernBetaSettingsPresets.presetWaterWorld(DEFAULT_MAJOR, majorId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("isle_land"), (Object)ModernBetaSettingsPresets.presetIsleLand(DEFAULT_MAJOR, majorId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("cave_delight"), (Object)ModernBetaSettingsPresets.presetCaveDelight(DEFAULT_MAJOR, majorId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("mountain_madness"), (Object)ModernBetaSettingsPresets.presetMountainMadness(DEFAULT_MAJOR, majorId, true));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("drought"), (Object)ModernBetaSettingsPresets.presetDrought(DEFAULT_MAJOR, majorId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("cave_chaos"), (Object)ModernBetaSettingsPresets.presetCaveChaos(DEFAULT_MAJOR, majorId));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_8_1_large_biomes"), (Object)ModernBetaSettingsPresets.presetBeta181(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_9_pre_3_large_biomes"), (Object)ModernBetaSettingsPresets.presetBeta19Pre3(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_0_0_large_biomes"), (Object)ModernBetaSettingsPresets.preset100(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_1_large_biomes"), (Object)ModernBetaSettingsPresets.preset11(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_2_5_large_biomes"), (Object)ModernBetaSettingsPresets.preset125(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_6_4_large_biomes"), (Object)ModernBetaSettingsPresets.preset164(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_12_2_large_biomes"), (Object)ModernBetaSettingsPresets.preset1122(false, 2, false));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_17_1_large_biomes"), (Object)ModernBetaSettingsPresets.preset1171(false, 2, false));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_hybrid_large_biomes"), (Object)ModernBetaSettingsPresets.presetReleaseHybrid(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("snow_aint_snowier_large_biomes"), (Object)ModernBetaSettingsPresets.presetSnowAintSnowier(false, 2));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_8_1_amplified"), (Object)ModernBetaSettingsPresets.presetBeta181(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("beta_1_9_pre_3_amplified"), (Object)ModernBetaSettingsPresets.presetBeta19Pre3(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_0_0_amplified"), (Object)ModernBetaSettingsPresets.preset100(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_1_amplified"), (Object)ModernBetaSettingsPresets.preset11(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_2_5_amplified"), (Object)ModernBetaSettingsPresets.preset125(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_6_4_amplified"), (Object)ModernBetaSettingsPresets.preset164(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_12_2_amplified"), (Object)ModernBetaSettingsPresets.preset1122(true, 0, false));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_1_17_1_amplified"), (Object)ModernBetaSettingsPresets.preset1171(true, 0, false));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("release_hybrid_amplified"), (Object)ModernBetaSettingsPresets.presetReleaseHybrid(true, 0));
        presetRegisterable.method_46838(ModernBetaSettingsPresets.keyOf("snow_aint_snowier_amplified"), (Object)ModernBetaSettingsPresets.presetSnowAintSnowier(true, 0));
    }

    private static class_5321<ModernBetaSettingsPreset> keyOf(String id) {
        return class_5321.method_29179(ModernBetaRegistryKeys.SETTINGS_PRESET, (class_2960)ModernerBeta.createId(id));
    }

    private static ModernBetaSettingsPreset presetBeta() {
        return ModernBetaSettingsPresets.presetBeta(false);
    }

    private static ModernBetaSettingsPreset presetBeta(boolean oakBiomes) {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.BETA.id).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.BETA).addDefault(SettingsComponentTypes.DEEPSLATE_GENERATION, SettingsComponentTypes.USE_SURFACE_RULES, SettingsComponentTypes.SEA_LEVEL_OFFSET, SettingsComponentTypes.NOISE_SCALE, SettingsComponentTypes.NOISE_SLIDE).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Biome.BETA.id).add(SettingsComponentTypes.USE_OCEAN_BIOMES, true).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.BETA).add(SettingsComponentTypes.CLIMATE_DISTRIBUTION, ClimateDistribution.BETA).add(SettingsComponentTypes.CLIMATE_MAPPINGS, Map.ofEntries(Map.entry("desert", new ClimateMapping(ModernBetaBiomes.BETA_DESERT.method_29177(), ModernBetaBiomes.BETA_OCEAN.method_29177())), Map.entry("forest", new ClimateMapping((oakBiomes ? ModernBetaBiomes.BETA_OAK_FOREST : ModernBetaBiomes.BETA_FOREST).method_29177(), ModernBetaBiomes.BETA_OCEAN.method_29177())), Map.entry("ice_desert", new ClimateMapping(ModernBetaBiomes.BETA_TUNDRA.method_29177(), ModernBetaBiomes.BETA_FROZEN_OCEAN.method_29177())), Map.entry("plains", new ClimateMapping(ModernBetaBiomes.BETA_PLAINS.method_29177(), ModernBetaBiomes.BETA_OCEAN.method_29177())), Map.entry("rainforest", new ClimateMapping(ModernBetaBiomes.BETA_RAINFOREST.method_29177(), ModernBetaBiomes.BETA_WARM_OCEAN.method_29177())), Map.entry("savanna", new ClimateMapping(ModernBetaBiomes.BETA_SAVANNA.method_29177(), ModernBetaBiomes.BETA_OCEAN.method_29177())), Map.entry("shrubland", new ClimateMapping(ModernBetaBiomes.BETA_SHRUBLAND.method_29177(), ModernBetaBiomes.BETA_OCEAN.method_29177())), Map.entry("seasonal_forest", new ClimateMapping(ModernBetaBiomes.BETA_SEASONAL_FOREST.method_29177(), ModernBetaBiomes.BETA_LUKEWARM_OCEAN.method_29177())), Map.entry("swampland", new ClimateMapping(ModernBetaBiomes.BETA_SWAMPLAND.method_29177(), ModernBetaBiomes.BETA_COLD_OCEAN.method_29177())), Map.entry("taiga", new ClimateMapping((oakBiomes ? ModernBetaBiomes.BETA_OAK_TAIGA : ModernBetaBiomes.BETA_TAIGA).method_29177(), ModernBetaBiomes.BETA_FROZEN_OCEAN.method_29177())), Map.entry("tundra", new ClimateMapping(ModernBetaBiomes.BETA_TUNDRA.method_29177(), ModernBetaBiomes.BETA_FROZEN_OCEAN.method_29177())))).addDefault(SettingsComponentTypes.CLIMATE_SCALE).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.CaveBiome.VORONOI.id).addDefault(SettingsComponentTypes.CAVE_BIOME_VORONOI).build());
    }

    private static ModernBetaSettingsPreset presetAlpha() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.ALPHA.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.BETA).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(684.412f, 684.412f, 512.0f, 512.0f, 100.0f, 100.0f, 80.0f, 160.0f, 80.0f, 8.5f, 12.0f, true)).addDefault(SettingsComponentTypes.USE_SURFACE_RULES, SettingsComponentTypes.SEA_LEVEL_OFFSET, SettingsComponentTypes.CAVE_GENERATION, SettingsComponentTypes.NOISE_SLIDE).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.ALPHA), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetSkylands() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.SKYLANDS.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.BETA).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(1368.824f, 684.412f, 512.0f, 512.0f, 100.0f, 100.0f, 80.0f, 160.0f, 80.0f, 8.5f, 12.0f, true)).add(SettingsComponentTypes.NOISE_SLIDE, new NoiseSlide(-30, 31, 0, -30, 7, 1)).addDefault(SettingsComponentTypes.USE_SURFACE_RULES).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.BETA_SKY), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetInfdev415() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.INFDEV_415.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(684.412f, 984.412f, 512.0f, 512.0f, 100.0f, 100.0f, 80.0f, 400.0f, 80.0f, 8.5f, 12.0f, true)).add(SettingsComponentTypes.NOISE_SLIDE, NoiseSlide.DISABLED).addDefault(SettingsComponentTypes.USE_SURFACE_RULES, SettingsComponentTypes.SEA_LEVEL_OFFSET).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INFDEV_415), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetInfdev420() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.INFDEV_420.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(684.412f, 684.412f, 512.0f, 512.0f, 100.0f, 100.0f, 80.0f, 160.0f, 80.0f, 8.5f, 12.0f, true)).add(SettingsComponentTypes.NOISE_SLIDE, NoiseSlide.DISABLED).addDefault(SettingsComponentTypes.USE_SURFACE_RULES, SettingsComponentTypes.SEA_LEVEL_OFFSET).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INFDEV_420), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetInfdev611() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.INFDEV_611.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.BETA).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(684.412f, 684.412f, 512.0f, 512.0f, 100.0f, 100.0f, 80.0f, 160.0f, 80.0f, 8.5f, 12.0f, true)).add(SettingsComponentTypes.NOISE_SLIDE, NoiseSlide.DISABLED).addDefault(SettingsComponentTypes.USE_SURFACE_RULES, SettingsComponentTypes.SEA_LEVEL_OFFSET).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INFDEV_611), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetInfdev325() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.INFDEV_227.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.USE_SURFACE_RULES, false).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).add(SettingsComponentTypes.INFDEV_227_STRUCTURES, new Infdev227Structures(true, false)).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INFDEV_325), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetInfdev227() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.INFDEV_227.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.USE_SURFACE_RULES, false).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).add(SettingsComponentTypes.INFDEV_227_STRUCTURES, new Infdev227Structures(true, true)).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INFDEV_227), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetIndev() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.INDEV.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).addDefault(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES, SettingsComponentTypes.FINITE_CAVE_GENERATION, SettingsComponentTypes.FINITE_NOISE, SettingsComponentTypes.FINITE_BEACHES, SettingsComponentTypes.FINITE_POOLS).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INDEV_NORMAL), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetClassic() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.CLASSIC_0_30.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).add(SettingsComponentTypes.FINITE_BEACHES, new FiniteBeaches(FiniteBeaches.DEFAULT.sandThreshold(), true, false, FiniteBeaches.DEFAULT.gravelThreshold(), false, true, false)).addDefault(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES, SettingsComponentTypes.FINITE_CAVE_GENERATION, SettingsComponentTypes.FINITE_NOISE, SettingsComponentTypes.FINITE_POOLS, SettingsComponentTypes.SPAWN_INDEV_HOUSE).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INDEV_NORMAL), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetClassic14a08() {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.CLASSIC_0_30.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.DISABLED).add(SettingsComponentTypes.FINITE_CAVE_GENERATION, new FiniteCaveGeneration(true, true, 16384, 1.0f, 75.0f)).add(SettingsComponentTypes.FINITE_NOISE, new FiniteNoise(1.3f, 1.0f, 8.0f, -8.0f, 6.0f, 6.0f, 8, 2.0f)).add(SettingsComponentTypes.FINITE_BEACHES, new FiniteBeaches(FiniteBeaches.DEFAULT.sandThreshold(), true, false, FiniteBeaches.DEFAULT.gravelThreshold(), true, false, true)).add(SettingsComponentTypes.FINITE_POOLS, new FinitePools(200, 10000, true)).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.CLASSIC_14A_08), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetPE() {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.PE.id).add(SettingsComponentTypes.DEEPSLATE_GENERATION, DeepslateGeneration.DISABLED).build(), DEFAULT_BETA.biomeSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Biome.PE.id).add(SettingsComponentTypes.USE_OCEAN_BIOMES, false).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.BETA).add(SettingsComponentTypes.CLIMATE_DISTRIBUTION, ClimateDistribution.BETA).add(SettingsComponentTypes.CLIMATE_MAPPINGS, Map.ofEntries(Map.entry("desert", new ClimateMapping(ModernBetaBiomes.PE_DESERT.method_29177(), ModernBetaBiomes.PE_OCEAN.method_29177())), Map.entry("forest", new ClimateMapping(ModernBetaBiomes.PE_FOREST.method_29177(), ModernBetaBiomes.PE_OCEAN.method_29177())), Map.entry("ice_desert", new ClimateMapping(ModernBetaBiomes.PE_TUNDRA.method_29177(), ModernBetaBiomes.PE_FROZEN_OCEAN.method_29177())), Map.entry("plains", new ClimateMapping(ModernBetaBiomes.PE_PLAINS.method_29177(), ModernBetaBiomes.PE_OCEAN.method_29177())), Map.entry("rainforest", new ClimateMapping(ModernBetaBiomes.PE_RAINFOREST.method_29177(), ModernBetaBiomes.PE_WARM_OCEAN.method_29177())), Map.entry("savanna", new ClimateMapping(ModernBetaBiomes.PE_SAVANNA.method_29177(), ModernBetaBiomes.PE_OCEAN.method_29177())), Map.entry("shrubland", new ClimateMapping(ModernBetaBiomes.PE_SHRUBLAND.method_29177(), ModernBetaBiomes.PE_OCEAN.method_29177())), Map.entry("seasonal_forest", new ClimateMapping(ModernBetaBiomes.PE_SEASONAL_FOREST.method_29177(), ModernBetaBiomes.PE_LUKEWARM_OCEAN.method_29177())), Map.entry("swampland", new ClimateMapping(ModernBetaBiomes.PE_SWAMPLAND.method_29177(), ModernBetaBiomes.PE_COLD_OCEAN.method_29177())), Map.entry("taiga", new ClimateMapping(ModernBetaBiomes.PE_TAIGA.method_29177(), ModernBetaBiomes.PE_FROZEN_OCEAN.method_29177())), Map.entry("tundra", new ClimateMapping(ModernBetaBiomes.PE_TUNDRA.method_29177(), ModernBetaBiomes.PE_FROZEN_OCEAN.method_29177())))).build(), ModernBetaSettings.noCaveBiomes());
    }

    private static ModernBetaSettingsPreset presetBetaSkylands() {
        return new ModernBetaSettingsPreset(ModernBetaSettingsPresets.presetSkylands().chunkSettings(), DEFAULT_BETA.biomeSettings().extend().add(SettingsComponentTypes.USE_OCEAN_BIOMES, false).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetIsles(ModernBetaSettingsPreset initialSettings, class_2960 initialId) {
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.ISLES_PROPERTIES, IslesProperties.ENABLED).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetWaterWorld(ModernBetaSettingsPreset initialSettings, class_2960 initialId) {
        NoiseScale baseNoiseScale = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        Map<ExtendedBiomeId, HeightConfig> baseHeightOverrides = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.FORCED_BIOME_HEIGHT).heightOverrides();
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.SEA_LEVEL_OFFSET, 192).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(baseNoiseScale.coordinate(), baseNoiseScale.height(), baseNoiseScale.upperLimit(), baseNoiseScale.lowerLimit(), baseNoiseScale.depthNoiseX(), baseNoiseScale.depthNoiseZ(), 5000.0f, 1000.0f, 5000.0f, baseNoiseScale.baseSize(), 8.0f, baseNoiseScale.farlands())).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, new ForcedBiomeHeight(baseHeightOverrides, 2.0f, 0.5f, 2.0f, 0.375f, false)).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetIsleLand(ModernBetaSettingsPreset initialSettings, class_2960 initialId) {
        NoiseScale baseNoiseScale = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(3000.0f, 6000.0f, 250.0f, 512.0f, baseNoiseScale.depthNoiseX(), baseNoiseScale.depthNoiseZ(), baseNoiseScale.mainNoiseX(), baseNoiseScale.mainNoiseY(), baseNoiseScale.mainNoiseZ(), baseNoiseScale.baseSize(), 10.0f, baseNoiseScale.farlands())).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetCaveDelight(ModernBetaSettingsPreset initialSettings, class_2960 initialId) {
        NoiseScale baseNoiseScale = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        Map<ExtendedBiomeId, HeightConfig> baseHeightOverrides = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.FORCED_BIOME_HEIGHT).heightOverrides();
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(baseNoiseScale.coordinate(), baseNoiseScale.height(), baseNoiseScale.upperLimit(), baseNoiseScale.lowerLimit(), baseNoiseScale.depthNoiseX(), baseNoiseScale.depthNoiseZ(), 5000.0f, 1000.0f, 5000.0f, baseNoiseScale.baseSize(), 5.0f, baseNoiseScale.farlands())).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, new ForcedBiomeHeight(baseHeightOverrides, 2.0f, 1.0f, 4.0f, 1.0f, false)).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetMountainMadness(ModernBetaSettingsPreset initialSettings, class_2960 initialId, boolean modifyBaseSize) {
        NoiseScale baseNoiseScale = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        Map<ExtendedBiomeId, HeightConfig> baseHeightOverrides = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.FORCED_BIOME_HEIGHT).heightOverrides();
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(738.41864f, 157.69133f, 801.4267f, 1254.1643f, 374.93652f, 288.65228f, 1355.9908f, 745.5343f, 1183.464f, modifyBaseSize ? 1.8758626f : baseNoiseScale.baseSize(), 1.7137525f, baseNoiseScale.farlands())).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, new ForcedBiomeHeight(baseHeightOverrides, 1.7553768f, 3.4701107f, 1.0f, 2.535211f, false)).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetDrought(ModernBetaSettingsPreset initialSettings, class_2960 initialId) {
        NoiseScale baseNoiseScale = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.SEA_LEVEL_OFFSET, -43).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(baseNoiseScale.coordinate(), baseNoiseScale.height(), baseNoiseScale.upperLimit(), baseNoiseScale.lowerLimit(), baseNoiseScale.depthNoiseX(), baseNoiseScale.depthNoiseZ(), 1000.0f, 3000.0f, 1000.0f, baseNoiseScale.baseSize(), 10.0f, baseNoiseScale.farlands())).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetCaveChaos(ModernBetaSettingsPreset initialSettings, class_2960 initialId) {
        NoiseScale baseNoiseScale = initialSettings.chunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        return new ModernBetaSettingsPreset(ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).add(SettingsComponentTypes.SEA_LEVEL_OFFSET, -57).add(SettingsComponentTypes.NOISE_SCALE, new NoiseScale(baseNoiseScale.coordinate(), baseNoiseScale.height(), 2.0f, 64.0f, baseNoiseScale.depthNoiseX(), baseNoiseScale.depthNoiseZ(), baseNoiseScale.mainNoiseX(), baseNoiseScale.mainNoiseY(), baseNoiseScale.mainNoiseZ(), baseNoiseScale.baseSize(), 8.0f, baseNoiseScale.farlands())).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PRESET, initialId).build());
    }

    private static ModernBetaSettingsPreset presetBetaLargeBiomes() {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings(), DEFAULT_BETA.biomeSettings().extend().add(SettingsComponentTypes.CLIMATE_SCALE, new ClimateScale(0.00625f, 0.0125f, 0.125f, 7.8125E-4f)).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.CaveBiome.VORONOI.id).add(SettingsComponentTypes.CAVE_BIOME_VORONOI, new CaveBiomeVoronoi(128.0f, 16.0f, -64, 64, CaveBiomeVoronoi.DEFAULT.points())).build());
    }

    private static ModernBetaSettingsPreset presetBetaXboxLegacy() {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.ISLES_PROPERTIES, IslesProperties.xboxLegacy(864)).build(), DEFAULT_BETA.biomeSettings(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetBetaSurvivalIsland() {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.ISLES_PROPERTIES, new IslesProperties(true, false, -200.0f, IslandShape.CIRCLE, 1, 8, 64, 16, 300.0f, 0.25f)).build(), DEFAULT_BETA.biomeSettings(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetBetaVanilla() {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.USE_SURFACE_RULES, true).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).build(), ModernBetaSettings.builder().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Biome.VORONOI.id).add(SettingsComponentTypes.USE_OCEAN_BIOMES, true).add(SettingsComponentTypes.CLIMATE_SCALE, new ClimateScale(0.008333334f, 0.016666668f, 0.16666667f, 0.003125f)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.MAJOR_RELEASE).add(SettingsComponentTypes.VORONOI_POINTS, List.of(new VoronoiPointBiome(class_1972.field_9424.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.1, 0.5), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.3, 0.5), new VoronoiPointBiome(class_1972.field_9409.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.5, 0.5), new VoronoiPointBiome(class_1972.field_9409.method_29177(), class_1972.field_9408.method_29177(), class_1972.field_9408.method_29177(), 0.9, 0.7, 0.5), new VoronoiPointBiome(class_1972.field_9417.method_29177(), class_1972.field_9408.method_29177(), class_1972.field_9408.method_29177(), 0.9, 0.9, 0.5), new VoronoiPointBiome(class_1972.field_9449.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.1, 0.5), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.3, 0.5), new VoronoiPointBiome(class_1972.field_9409.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.5, 0.5), new VoronoiPointBiome(class_1972.field_9409.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.7, 0.5), new VoronoiPointBiome(class_1972.field_9409.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.9, 0.5), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.1, 0.5), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.3, 0.5), new VoronoiPointBiome(class_1972.field_9412.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.5, 0.5), new VoronoiPointBiome(class_1972.field_9412.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.7, 0.5), new VoronoiPointBiome(class_1972.field_9471.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.9, 0.5), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.1, 0.5), new VoronoiPointBiome(class_1972.field_9420.method_29177(), class_1972.field_9467.method_29177(), class_1972.field_9470.method_29177(), 0.3, 0.3, 0.5), new VoronoiPointBiome(class_1972.field_9420.method_29177(), class_1972.field_9467.method_29177(), class_1972.field_9470.method_29177(), 0.3, 0.5, 0.5), new VoronoiPointBiome(class_1972.field_9454.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.7, 0.5), new VoronoiPointBiome(class_1972.field_9454.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.9, 0.5), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.1, 0.5), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.3, 0.5), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.5, 0.5), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.7, 0.5), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.9, 0.5), new VoronoiPointBiome(class_1972.field_9424.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.1, 0.2), new VoronoiPointBiome(class_1972.field_9455.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.3, 0.2), new VoronoiPointBiome(class_1972.field_9475.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.5, 0.2), new VoronoiPointBiome(class_1972.field_9475.method_29177(), class_1972.field_9408.method_29177(), class_1972.field_9408.method_29177(), 0.9, 0.7, 0.2), new VoronoiPointBiome(class_1972.field_9440.method_29177(), class_1972.field_9408.method_29177(), class_1972.field_9408.method_29177(), 0.9, 0.9, 0.2), new VoronoiPointBiome(class_1972.field_9449.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.1, 0.2), new VoronoiPointBiome(class_1972.field_34470.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.3, 0.2), new VoronoiPointBiome(class_1972.field_9414.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.5, 0.2), new VoronoiPointBiome(class_1972.field_9414.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.7, 0.2), new VoronoiPointBiome(class_1972.field_9414.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.9, 0.2), new VoronoiPointBiome(class_1972.field_34470.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.1, 0.2), new VoronoiPointBiome(class_1972.field_34470.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.3, 0.2), new VoronoiPointBiome(class_1972.field_42720.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.5, 0.2), new VoronoiPointBiome(class_1972.field_42720.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.7, 0.2), new VoronoiPointBiome(class_1972.field_38748.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.9, 0.2), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.1, 0.2), new VoronoiPointBiome(class_1972.field_35119.method_29177(), class_1972.field_9467.method_29177(), class_1972.field_9470.method_29177(), 0.3, 0.3, 0.2), new VoronoiPointBiome(class_1972.field_35119.method_29177(), class_1972.field_9467.method_29177(), class_1972.field_9470.method_29177(), 0.3, 0.5, 0.2), new VoronoiPointBiome(class_1972.field_34471.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.7, 0.2), new VoronoiPointBiome(class_1972.field_34471.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.9, 0.2), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.1, 0.2), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.3, 0.2), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.5, 0.2), new VoronoiPointBiome(class_1972.field_34472.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.7, 0.2), new VoronoiPointBiome(class_1972.field_34472.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.9, 0.2), new VoronoiPointBiome(class_1972.field_9415.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.1, 0.8), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.3, 0.8), new VoronoiPointBiome(class_1972.field_35118.method_29177(), class_1972.field_9441.method_29177(), class_1972.field_9439.method_29177(), 0.9, 0.5, 0.8), new VoronoiPointBiome(class_1972.field_35118.method_29177(), class_1972.field_9408.method_29177(), class_1972.field_9408.method_29177(), 0.9, 0.7, 0.8), new VoronoiPointBiome(class_1972.field_9462.method_29177(), class_1972.field_9408.method_29177(), class_1972.field_9408.method_29177(), 0.9, 0.9, 0.8), new VoronoiPointBiome(class_1972.field_9449.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.1, 0.8), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.7, 0.3, 0.8), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.1, 0.8), new VoronoiPointBiome(class_1972.field_9451.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.3, 0.8), new VoronoiPointBiome(class_1972.field_35112.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.5, 0.8), new VoronoiPointBiome(class_1972.field_35112.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.7, 0.8), new VoronoiPointBiome(class_1972.field_38748.method_29177(), class_1972.field_9423.method_29177(), class_1972.field_9446.method_29177(), 0.5, 0.9, 0.8), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.1, 0.8), new VoronoiPointBiome(class_1972.field_35113.method_29177(), class_1972.field_9467.method_29177(), class_1972.field_9470.method_29177(), 0.3, 0.3, 0.8), new VoronoiPointBiome(class_1972.field_35113.method_29177(), class_1972.field_9467.method_29177(), class_1972.field_9470.method_29177(), 0.3, 0.5, 0.8), new VoronoiPointBiome(class_1972.field_34471.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.7, 0.8), new VoronoiPointBiome(class_1972.field_34471.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.3, 0.9, 0.8), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.1, 0.8), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.3, 0.8), new VoronoiPointBiome(class_1972.field_35117.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.5, 0.8), new VoronoiPointBiome(class_1972.field_9453.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.7, 0.8), new VoronoiPointBiome(class_1972.field_9453.method_29177(), class_1972.field_9435.method_29177(), class_1972.field_9418.method_29177(), 0.1, 0.9, 0.8))).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetAlphaWinter() {
        ModernBetaSettingsPreset basePreset = ModernBetaSettingsPresets.presetAlpha();
        return new ModernBetaSettingsPreset(basePreset.chunkSettings(), ModernBetaSettings.singleBiome(ModernBetaBiomes.ALPHA_WINTER), basePreset.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetIndevParadise() {
        ModernBetaSettingsPreset basePreset = ModernBetaSettingsPresets.presetIndev();
        return new ModernBetaSettingsPreset(basePreset.chunkSettings().extend().add(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES, new FiniteLevelProperties(IndevType.ISLAND, IndevTheme.PARADISE, 256, 256, 128)).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INDEV_PARADISE), basePreset.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetIndevWoods() {
        ModernBetaSettingsPreset basePreset = ModernBetaSettingsPresets.presetIndev();
        return new ModernBetaSettingsPreset(basePreset.chunkSettings().extend().add(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES, new FiniteLevelProperties(IndevType.ISLAND, IndevTheme.WOODS, 256, 256, 128)).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INDEV_WOODS), basePreset.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetIndevHell() {
        ModernBetaSettingsPreset basePreset = ModernBetaSettingsPresets.presetIndev();
        return new ModernBetaSettingsPreset(basePreset.chunkSettings().extend().add(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES, new FiniteLevelProperties(IndevType.ISLAND, IndevTheme.HELL, 256, 256, 128)).build(), ModernBetaSettings.singleBiome(ModernBetaBiomes.INDEV_HELL), basePreset.caveBiomeSettings());
    }

    private static Map<class_2960, String> earlyReleaseLayerOutputs(int biomeScale) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)ModernBetaBuiltInTypes.LayerOutput.BIOME.id, (Object)"land");
        for (int i = 0; i < 4 + biomeScale; ++i) {
            builder.put((Object)ModernerBeta.createId("climate_" + i), (Object)("land_" + i));
        }
        return builder.build();
    }

    private static ModernBetaSettingsPreset presetBeta181(boolean amplified, int biomeScale) {
        ArrayList<Layer> layers = new ArrayList<Layer>(List.of(new InitLandLayer("land", 1L), new FuzzyZoomLayer("land", 2000L, "land"), AddLandLayer.forIslandScaleBeta("land", 1L, "land"), new ModalZoomLayer("land", 2001L, "land"), AddLandLayer.forIslandScaleBeta("land", 2L, "land"), new ModalZoomLayer("land", 2002L, "land"), AddLandLayer.forIslandScaleBeta("land", 3L, "land"), new ModalZoomLayer("land", 2003L, "land"), AddLandLayer.forIslandScaleBeta("land", 3L, "land"), new ModalZoomLayer("land", 2004L, "land"), AddLandLayer.forIslandScaleBeta("land", 3L, "land"), new InitRiverLayer("river", 100L, "land"), StackedZoomLayer.modal("river", 1000L, "river", 6 + biomeScale), new ComputeRiverLayer("river", 0L, "river", true), new SmoothLayer("river", 1000L, "river"), new RandomBiomeLayer("biome_pool", 200L, ExtendedBiomeId.listOf("minecraft:desert", "minecraft:forest", "moderner_beta:late_beta_extreme_hills", "moderner_beta:late_beta_swampland", "moderner_beta:late_beta_plains", "moderner_beta:late_beta_taiga")), new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("biome_pool"))), StackedZoomLayer.modal("land", 1000L, "land", 2), new ModalZoomLayer("land_0", 1000L, "land"), AddLandLayer.forBeta("land_0", 3L, "land_0")));
        for (int i = 0; i < 3 + biomeScale; ++i) {
            layers.add(new ModalZoomLayer("land_" + (1 + i), 1001 + i, "land_" + i));
        }
        layers.add(new SmoothLayer("land", 1000L, "land_" + (3 + biomeScale)));
        layers.add(MixRiverLayer.forEarlyRelease("land", 0L, "land", "river"));
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(Map.of(ExtendedBiomeId.OCEAN, new HeightConfig(-1.0f, 0.5f)), amplified)).build(), ModernBetaSettings.betaFractalLayers(ModernBetaSettingsPresets.earlyReleaseLayerOutputs(biomeScale), ClimateDistribution.BETA, layers).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.NONE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ConfiguredLayers configuredLayers100Era(int biomeScale, ExtendedBiomeId icePlains) {
        ArrayList<Layer> layers = new ArrayList<Layer>(List.of(new InitLandLayer("land", 1L), new FuzzyZoomLayer("land", 2000L, "land"), AddLandLayer.forIslandScale("land", 1L, "land"), new ModalZoomLayer("land", 2001L, "land"), AddLandLayer.forIslandScale("land", 2L, "land"), new WeightedPoolLayer("snow", 2L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.SNOWY_PLAINS), 1).method_34975((Object)LayerTarget.none(), 4).method_34974()), new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("snow"))), new ModalZoomLayer("land", 2002L, "land"), AddLandLayer.forIslandScale("land", 3L, "land"), new ModalZoomLayer("land", 2003L, "land"), AddLandLayer.forIslandScale("land", 4L, "land"), ConditionalOverlayLayer.mushroomIslands(), new InitRiverLayer("river", 100L, "land"), StackedZoomLayer.modal("river", 1000L, "river", 6 + biomeScale), new ComputeRiverLayer("river", 0L, "river", true), new SmoothLayer("river", 1000L, "river"), new RandomBiomeLayer("biome_pool", 200L, ExtendedBiomeId.listOf("minecraft:desert", "minecraft:forest", "moderner_beta:late_beta_extreme_hills", "moderner_beta:early_release_swampland", "moderner_beta:late_beta_plains", "moderner_beta:late_beta_taiga")), new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("biome_pool"), ExtendedBiomeId.FROZEN_OCEAN, LayerTarget.biome(icePlains), ExtendedBiomeId.SNOWY_PLAINS, LayerTarget.biome(icePlains))), StackedZoomLayer.modal("land", 1000L, "land", 2), new ModalZoomLayer("land_0", 1000L, "land"), AddLandLayer.forEarlyRelease("land_0", 3L, "land_0", icePlains), new ConditionalOverlayLayer("land_0", 0L, "land_0", PredicateOverlayLayer.Target.MUSHROOM_SHORE.predicate(), LayerTarget.biome(ExtendedBiomeId.MUSHROOM_SHORE), LayerTarget.none())));
        for (int i = 0; i < 3 + biomeScale; ++i) {
            layers.add(new ModalZoomLayer("land_" + (1 + i), 1001 + i, "land_" + i));
        }
        layers.add(new SmoothLayer("land", 1000L, "land_" + (3 + biomeScale)));
        layers.add(MixRiverLayer.forEarlyRelease("land", 0L, "land", "river"));
        return new ConfiguredLayers(layers, ModernBetaSettingsPresets.earlyReleaseLayerOutputs(biomeScale));
    }

    private static ModernBetaSettingsPreset presetBeta19Pre3(boolean amplified, int biomeScale) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, amplified ? ForcedBiomeHeight.AMPLIFIED : ForcedBiomeHeight.DEFAULT).build(), ModernBetaSettings.betaFractalLayers(ModernBetaSettingsPresets.configuredLayers100Era(biomeScale, ExtendedBiomeId.of(ModernBetaBiomes.LATE_BETA_ICE_PLAINS)), ClimateDistribution.RELEASE_1_0).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.NONE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset preset100(boolean amplified, int biomeScale) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, amplified ? ForcedBiomeHeight.AMPLIFIED : ForcedBiomeHeight.DEFAULT).build(), ModernBetaSettings.betaFractalLayers(ModernBetaSettingsPresets.configuredLayers100Era(biomeScale, ExtendedBiomeId.of(ModernBetaBiomes.EARLY_RELEASE_ICE_PLAINS)), ClimateDistribution.RELEASE_1_0).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.NONE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ConfiguredLayers configuredLayers11Era(int biomeScale, boolean addJungles, boolean taigasInIcePlains) {
        ExtendedBiomeId icePlains = ExtendedBiomeId.of(ModernBetaBiomes.EARLY_RELEASE_ICE_PLAINS);
        List<ExtendedBiomeId> biomePool = ExtendedBiomeId.listOf("minecraft:desert", "minecraft:forest", "moderner_beta:early_release_extreme_hills", "moderner_beta:early_release_swampland", "moderner_beta:late_beta_plains", "moderner_beta:early_release_taiga");
        if (addJungles) {
            biomePool = new ArrayList<ExtendedBiomeId>(biomePool);
            biomePool.add(ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_9417));
        }
        Map<ExtendedBiomeId, ExtendedBiomeId> hillsVariants = Map.ofEntries(ExtendedBiomeId.of("minecraft:desert").mapTo("*hills"), ExtendedBiomeId.of("minecraft:forest").mapTo("*hills"), ExtendedBiomeId.of("moderner_beta:late_beta_plains").mapTo("minecraft:forest"), ExtendedBiomeId.of("moderner_beta:early_release_taiga").mapTo("*hills"), ExtendedBiomeId.of("moderner_beta:early_release_ice_plains").mapTo("*hills"));
        if (addJungles) {
            hillsVariants = new HashMap(hillsVariants);
            hillsVariants.put(ExtendedBiomeId.of("minecraft:jungle"), ExtendedBiomeId.of("minecraft:jungle*hills"));
        }
        WeightedPoolLayer swampLakesLayer = new WeightedPoolLayer("swamp_lakes", 1000L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.RIVER), 1).method_34975((Object)LayerTarget.none(), 5).method_34974());
        List<PredicateOverlayLayer.Target> lakeOverlays = List.of(PredicateOverlayLayer.Target.layer(BiomePredicate.of(ExtendedBiomeId.of("~moderner_beta:early_release_swampland")), "swamp_lakes"));
        if (addJungles) {
            lakeOverlays = new ArrayList<PredicateOverlayLayer.Target>(lakeOverlays);
            lakeOverlays.add(PredicateOverlayLayer.Target.layer(BiomePredicate.of(ExtendedBiomeId.of("~minecraft:jungle")), "jungle_lakes"));
        }
        Layer icePlainsLayer = taigasInIcePlains ? new RandomBiomeLayer("ice_plains", 200L, biomePool.stream().map(biome -> biome.isOf(ModernBetaBiomes.EARLY_RELEASE_TAIGA) ? biome : icePlains).toList()) : new ConstantBiomeLayer("ice_plains", 0L, icePlains);
        ArrayList<Layer> layers = new ArrayList<Layer>(Arrays.asList(new InitLandLayer("land", 1L), new FuzzyZoomLayer("land", 2000L, "land"), AddLandLayer.forIslandScale("land", 1L, "land"), new ModalZoomLayer("land", 2001L, "land"), AddLandLayer.forIslandScale("land", 2L, "land"), new WeightedPoolLayer("snow", 2L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.SNOWY_PLAINS), 1).method_34975((Object)LayerTarget.none(), 4).method_34974()), new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("snow"))), new ModalZoomLayer("land", 2002L, "land"), AddLandLayer.forIslandScale("land", 3L, "land"), new ModalZoomLayer("land", 2003L, "land"), AddLandLayer.forIslandScale("land", 4L, "land"), ConditionalOverlayLayer.mushroomIslands(), new InitRiverLayer("river", 100L, "land"), StackedZoomLayer.modal("river", 1000L, "river", 6 + biomeScale), new ComputeRiverLayer("river", 0L, "river", true), new SmoothLayer("river", 1000L, "river"), new RandomBiomeLayer("biome_pool", 200L, biomePool), icePlainsLayer, new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("biome_pool"), ExtendedBiomeId.FROZEN_OCEAN, LayerTarget.layer("ice_plains"), ExtendedBiomeId.SNOWY_PLAINS, LayerTarget.layer("ice_plains"))), StackedZoomLayer.modal("land", 1000L, "land", 2), BiomeReplacementLayer.toBiomes("hills", 0L, "land", hillsVariants), new ConditionalOverlayLayer("land", 1000L, "land", BiomePredicate.simpleHills(hillsVariants.keySet()), LayerTarget.layer("hills"), LayerTarget.none()), new ModalZoomLayer("land_0", 1000L, "land"), AddLandLayer.forEarlyRelease("land_0", 3L, "land_0", icePlains), new ModalZoomLayer("land_1", 1001L, "land_0"), new PredicateOverlayLayer("land_1", 0L, "land_1", List.of(PredicateOverlayLayer.Target.MUSHROOM_SHORE, PredicateOverlayLayer.Target.inclusiveBeach(ExtendedBiomeId.setOf("minecraft:ocean", "minecraft:river", "moderner_beta:early_release_extreme_hills", "moderner_beta:early_release_swampland"), ExtendedBiomeId.BEACH), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("moderner_beta:early_release_extreme_hills")).and(BiomePredicate.border()), ExtendedBiomeId.of("moderner_beta:early_release_extreme_hills*edge")))), swampLakesLayer, new PredicateOverlayLayer("land_1", 1000L, "land_1", lakeOverlays)));
        for (int i = 0; i < 2 + biomeScale; ++i) {
            layers.add(new ModalZoomLayer("land_" + (2 + i), 1001 + i, "land_" + (1 + i)));
        }
        layers.add(new SmoothLayer("land", 1000L, "land_" + (3 + biomeScale)));
        layers.add(MixRiverLayer.forEarlyRelease("land", 0L, "land", "river"));
        if (addJungles) {
            WeightedPoolLayer jungleLakesLayer = new WeightedPoolLayer("jungle_lakes", 1000L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.RIVER), 1).method_34975((Object)LayerTarget.none(), 7).method_34974());
            layers = new ArrayList<Layer>(layers);
            layers.add(layers.lastIndexOf(swampLakesLayer), jungleLakesLayer);
        }
        return new ConfiguredLayers(layers, ModernBetaSettingsPresets.earlyReleaseLayerOutputs(biomeScale));
    }

    private static ModernBetaSettingsPreset preset11(boolean amplified, int biomeScale) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, amplified ? ForcedBiomeHeight.AMPLIFIED : ForcedBiomeHeight.DEFAULT).build(), ModernBetaSettings.betaFractalLayers(ModernBetaSettingsPresets.configuredLayers11Era(biomeScale, false, false), ClimateDistribution.RELEASE_1_1).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.NONE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset preset125(boolean amplified, int biomeScale) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, amplified ? ForcedBiomeHeight.AMPLIFIED : ForcedBiomeHeight.DEFAULT).build(), ModernBetaSettings.fractalLayers(ModernBetaSettingsPresets.configuredLayers11Era(biomeScale, true, false)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.NONE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset preset164(boolean amplified, int biomeScale) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(Map.of(ExtendedBiomeId.of("minecraft:desert*hills"), new HeightConfig(0.3f, 0.8f), ExtendedBiomeId.of("minecraft:forest*hills"), new HeightConfig(0.3f, 0.7f), ExtendedBiomeId.of("moderner_beta:early_release_extreme_hills"), new HeightConfig(0.3f, 1.5f), ExtendedBiomeId.of("moderner_beta:early_release_ice_plains*hills"), new HeightConfig(0.3f, 1.3f), ExtendedBiomeId.of("minecraft:jungle*hills"), new HeightConfig(1.8f, 0.5f), ExtendedBiomeId.of("moderner_beta:early_release_taiga*hills"), new HeightConfig(0.3f, 0.8f)), amplified)).build(), ModernBetaSettings.fractalLayers(ModernBetaSettingsPresets.configuredLayers11Era(biomeScale, true, true)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.NONE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ConfiguredLayers configuredLayers1710Era(int biomeScale, int finiteSize, boolean bedrock, boolean saltedMutation, boolean climaticOceans, boolean bambooJungles, boolean strongBadlandsCategories, boolean modernBiomes) {
        if (bedrock) {
            saltedMutation = false;
            strongBadlandsCategories = false;
        }
        Set<ExtendedBiomeId> oceans = ExtendedBiomeId.setOf("minecraft:ocean", "minecraft:deep_ocean");
        BiomePredicate oceansPredicate = BiomePredicate.inSet(oceans);
        Map<ExtendedBiomeId, ExtendedBiomeId> hillVariants = Map.ofEntries(ExtendedBiomeId.of("minecraft:desert").mapTo("*hills"), ExtendedBiomeId.of("minecraft:forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:birch_forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:taiga").mapTo("*hills"), ExtendedBiomeId.of("minecraft:snowy_taiga").mapTo("*hills"), ExtendedBiomeId.of("minecraft:snowy_plains").mapTo("*hills"), ExtendedBiomeId.of("minecraft:jungle").mapTo("*hills"), ExtendedBiomeId.of("minecraft:bamboo_jungle").mapTo("*hills"), ExtendedBiomeId.of("minecraft:plains").mapTo("minecraft:forest"), ExtendedBiomeId.of("minecraft:windswept_hills").mapTo("minecraft:windswept_forest"), ExtendedBiomeId.of("minecraft:dark_forest").mapTo("minecraft:plains"), ExtendedBiomeId.of("minecraft:old_growth_pine_taiga").mapTo("*hills"), ExtendedBiomeId.of("minecraft:old_growth_spruce_taiga").mapTo("*hills"), ExtendedBiomeId.of("minecraft:savanna").mapTo("minecraft:savanna_plateau"), ExtendedBiomeId.of("minecraft:badlands*plateau").mapTo("minecraft:badlands"), ExtendedBiomeId.of("minecraft:wooded_badlands").mapTo("minecraft:badlands"));
        Map<ExtendedBiomeId, ExtendedBiomeId> mutatedVariants = Map.ofEntries(ExtendedBiomeId.of("minecraft:plains").mapTo("minecraft:sunflower_plains"), ExtendedBiomeId.of("minecraft:desert").mapTo("*lakes"), ExtendedBiomeId.of("minecraft:forest").mapTo("minecraft:flower_forest"), ExtendedBiomeId.of("minecraft:taiga").mapTo("*mountains"), ExtendedBiomeId.of("minecraft:swamp").mapTo("*hills"), ExtendedBiomeId.of("minecraft:mangrove_swamp").mapTo("*hills"), ExtendedBiomeId.of("minecraft:jungle").mapTo("*modified"), ExtendedBiomeId.of("minecraft:sparse_jungle").mapTo("*modified"), ExtendedBiomeId.of("minecraft:snowy_taiga").mapTo("*mountains"), ExtendedBiomeId.of("minecraft:snowy_plains").mapTo("minecraft:ice_spikes"), ExtendedBiomeId.of("minecraft:savanna").mapTo("minecraft:windswept_savanna"), ExtendedBiomeId.of("minecraft:savanna_plateau").mapTo("minecraft:windswept_savanna*plateau"), ExtendedBiomeId.of("minecraft:badlands").mapTo("minecraft:eroded_badlands"), ExtendedBiomeId.of("minecraft:wooded_badlands").mapTo("*modified"), ExtendedBiomeId.of("minecraft:badlands*plateau").mapTo("*modified_plateau"), ExtendedBiomeId.of("minecraft:birch_forest").mapTo("minecraft:old_growth_birch_forest"), ExtendedBiomeId.of("minecraft:birch_forest*hills").mapTo("minecraft:old_growth_birch_forest*hills"), ExtendedBiomeId.of("minecraft:dark_forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:old_growth_pine_taiga").mapTo("minecraft:old_growth_spruce_taiga"), ExtendedBiomeId.of("minecraft:old_growth_pine_taiga*hills").mapTo("minecraft:old_growth_spruce_taiga*hills"), ExtendedBiomeId.of("minecraft:windswept_hills").mapTo("minecraft:windswept_gravelly_hills"), ExtendedBiomeId.of("minecraft:windswept_forest").mapTo("minecraft:windswept_gravelly_hills"));
        Map<ExtendedBiomeId, ExtendedBiomeId> modernVariants = Map.ofEntries(ExtendedBiomeId.of("minecraft:windswept_hills").mapTo("minecraft:meadow"), ExtendedBiomeId.of("minecraft:taiga").mapTo("minecraft:cherry_grove"), ExtendedBiomeId.of("minecraft:swamp").mapTo("minecraft:mangrove_swamp"));
        Map biomeCategories = Map.ofEntries(Map.entry("beach", ExtendedBiomeId.setOf("~minecraft:beach", "~minecraft:snowy_beach")), Map.entry("desert", ExtendedBiomeId.setOf("~minecraft:desert")), Map.entry("windswept_hills", ExtendedBiomeId.setOf("~minecraft:windswept_gravelly_hills", "~minecraft:windswept_hills", "~minecraft:windswept_forest", "~minecraft:meadow")), Map.entry("forest", ExtendedBiomeId.setOf("~minecraft:birch_forest", "~minecraft:dark_forest", "~minecraft:flower_forest", "~minecraft:forest", "~minecraft:old_growth_birch_forest", "~minecraft:cherry_grove")), Map.entry("snowy_plains", ExtendedBiomeId.setOf("~minecraft:ice_spikes", "~minecraft:snowy_plains")), Map.entry("jungle", ExtendedBiomeId.setOf("~minecraft:bamboo_jungle", "~minecraft:jungle", "~minecraft:sparse_jungle")), Map.entry("badlands", ExtendedBiomeId.setOf("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:badlands*modified_plateau", "minecraft:wooded_badlands*modified")), Map.entry("badlands_plateau", ExtendedBiomeId.setOf("minecraft:badlands*plateau", "minecraft:wooded_badlands")), Map.entry("badlands_all", ExtendedBiomeId.setOf("~minecraft:badlands", "~minecraft:eroded_badlands", "~minecraft:wooded_badlands")), Map.entry("mushroom_fields", ExtendedBiomeId.setOf("~minecraft:mushroom_fields")), Map.entry("ocean", oceans), Map.entry("plains", ExtendedBiomeId.setOf("~minecraft:plains", "~minecraft:sunflower_plains")), Map.entry("river", ExtendedBiomeId.setOf("~minecraft:frozen_river", "~minecraft:river")), Map.entry("savanna", ExtendedBiomeId.setOf("~minecraft:savanna", "~minecraft:savanna_plateau", "~minecraft:windswept_savanna")), Map.entry("swamp", ExtendedBiomeId.setOf("~minecraft:swamp", "~minecraft:mangrove_swamp")), Map.entry("taiga", ExtendedBiomeId.setOf("~minecraft:old_growth_spurce_taiga", "~minecraft:old_growth_pine_taiga", "~minecraft:snowy_taiga", "~minecraft:taiga")), Map.entry("jungle_like", ExtendedBiomeId.setOf("~minecraft:bamboo_jungle", "~minecraft:jungle", "~minecraft:sparse_jungle", "minecraft:forest", "minecraft:taiga", "minecraft:ocean", "minecraft:deep_ocean")), Map.entry("snowy", ExtendedBiomeId.setOf("~minecraft:ice_spikes", "~minecraft:snowy_plains", "~minecraft:snowy_taiga")));
        List<Set<ExtendedBiomeId>> hillyCategories = List.of((Set)biomeCategories.get("ocean"), (Set)biomeCategories.get("forest"), (Set)biomeCategories.get("taiga"), (Set)biomeCategories.get("plains"), (Set)biomeCategories.get("snowy_plains"), (Set)biomeCategories.get("savanna"), (Set)biomeCategories.get("desert"), (Set)biomeCategories.get("windswept_hills"), (Set)biomeCategories.get("jungle"), (Set)biomeCategories.get("badlands"), (Set)biomeCategories.get("badlands_plateau"));
        Set<ExtendedBiomeId> hillTargetBiomeSet = hillyCategories.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        BiomePredicate hillPredicate = BiomePredicate.inSet(hillTargetBiomeSet).and(BiomePredicate.neighborsMatch(hillyCategories, 3));
        if (!strongBadlandsCategories) {
            hillPredicate = hillPredicate.or(BiomePredicate.inSet((Set)biomeCategories.get("badlands_plateau")).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet((Set)biomeCategories.get("badlands_all")), 3)));
        }
        boolean usesBiomeScale = finiteSize <= 0 || finiteSize >= 3072;
        Layer[] layerArray = new Layer[69];
        layerArray[0] = new InitLandLayer("land", 1L);
        layerArray[1] = new FuzzyZoomLayer("land", 2000L, "land");
        layerArray[2] = AddLandLayer.forIslandScaleMajor("land", 1L, "land");
        layerArray[3] = new ModalZoomLayer("land", 2001L, "land");
        layerArray[4] = AddLandLayer.forIslandScaleMajor("land", 2L, "land");
        layerArray[5] = AddLandLayer.forIslandScaleMajor("land", 50L, "land");
        layerArray[6] = AddLandLayer.forIslandScaleMajor("land", 70L, "land");
        layerArray[7] = new ConditionalOverlayLayer("land", 2L, "land", BiomePredicate.of(ExtendedBiomeId.OCEAN).and(BiomePredicate.interior()).and(BiomePredicate.oneIn(2)), LayerTarget.biome(ExtendedBiomeId.PLAINS), LayerTarget.none());
        layerArray[8] = new WeightedPoolLayer("climate", 2L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.CLIMATE_SNOWY), 1).method_34975((Object)LayerTarget.biome(ExtendedBiomeId.CLIMATE_COOL), 1).method_34975((Object)LayerTarget.biome(ExtendedBiomeId.CLIMATE_WARM), 4).method_34974());
        layerArray[9] = new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("climate")));
        layerArray[10] = AddLandLayer.forIslandScaleMajor("land", 3L, "land");
        layerArray[11] = new ConditionalOverlayLayer("land", 0L, "land", BiomePredicate.of(ExtendedBiomeId.CLIMATE_WARM).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet(ExtendedBiomeId.CLIMATE_COOL, ExtendedBiomeId.CLIMATE_SNOWY), 1)), LayerTarget.biome(ExtendedBiomeId.CLIMATE_TEMPERATE), LayerTarget.none());
        layerArray[12] = new ConditionalOverlayLayer("land", 0L, "land", BiomePredicate.of(ExtendedBiomeId.CLIMATE_SNOWY).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet(ExtendedBiomeId.CLIMATE_TEMPERATE, ExtendedBiomeId.CLIMATE_WARM), 1)), LayerTarget.biome(ExtendedBiomeId.CLIMATE_COOL), LayerTarget.none());
        layerArray[13] = new RandomBiomeLayer("climate_warm_rare", 3L, ExtendedBiomeId.CLIMATE_WARM_RARE).skipRandom(1);
        layerArray[14] = new RandomBiomeLayer("climate_temperate_rare", 3L, ExtendedBiomeId.CLIMATE_TEMPERATE_RARE).skipRandom(1);
        layerArray[15] = new RandomBiomeLayer("climate_cool_rare", 3L, ExtendedBiomeId.CLIMATE_COOL_RARE).skipRandom(1);
        layerArray[16] = new RandomBiomeLayer("climate_snowy_rare", 3L, ExtendedBiomeId.CLIMATE_SNOWY_RARE).skipRandom(1);
        layerArray[17] = new BiomeReplacementLayer("rare_climates", 0L, "land", Map.ofEntries(Map.entry(ExtendedBiomeId.CLIMATE_WARM, LayerTarget.layer("climate_warm_rare")), Map.entry(ExtendedBiomeId.CLIMATE_TEMPERATE, LayerTarget.layer("climate_temperate_rare")), Map.entry(ExtendedBiomeId.CLIMATE_COOL, LayerTarget.layer("climate_cool_rare")), Map.entry(ExtendedBiomeId.CLIMATE_SNOWY, LayerTarget.layer("climate_snowy_rare"))));
        layerArray[18] = new PredicateOverlayLayer("land", 3L, "land", List.of(PredicateOverlayLayer.Target.layer(BiomePredicate.oneIn(13), "rare_climates")));
        layerArray[19] = new ModalZoomLayer("land", 2002L, "land");
        layerArray[20] = new ModalZoomLayer("land", 2003L, "land");
        layerArray[21] = AddLandLayer.forIslandScaleMajor("land", 4L, "land");
        layerArray[22] = usesBiomeScale ? ConditionalOverlayLayer.mushroomIslands() : null;
        layerArray[23] = new ConditionalOverlayLayer("land", 0L, "land", BiomePredicate.of(ExtendedBiomeId.OCEAN).and(BiomePredicate.interior()), LayerTarget.biome(ExtendedBiomeId.DEEP_OCEAN), LayerTarget.none());
        layerArray[24] = new SupplyRandomLayer("mutation", 100L, 299999);
        layerArray[25] = new ConditionalOverlayLayer("mutation", 0L, "land", BiomePredicate.of(ExtendedBiomeId.OCEAN), LayerTarget.none(), LayerTarget.layer("mutation"));
        layerArray[26] = bedrock ? StackedZoomLayer.modal("river", 1001L, "mutation", 2, 0) : StackedZoomLayer.modal("river", 1000L, "mutation", 2);
        layerArray[27] = bedrock ? StackedZoomLayer.modal("river", 1001L, "river", 4 + biomeScale, 0) : StackedZoomLayer.modal("river", 1000L, "river", 4 + biomeScale);
        layerArray[28] = saltedMutation ? StackedZoomLayer.modal("mutation", 1000L, "mutation", 2) : StackedZoomLayer.modal("mutation", 1000L, "mutation", 2).unsalted();
        layerArray[29] = new ComputeRiverLayer("river", 0L, "river", false);
        layerArray[30] = new SmoothLayer("river", 1000L, "river");
        layerArray[31] = new RandomBiomeLayer("biome_pool_warm", 200L, ExtendedBiomeId.listOf("minecraft:desert", "minecraft:desert", "minecraft:desert", "minecraft:savanna", "minecraft:savanna", "minecraft:plains"));
        layerArray[32] = new RandomBiomeLayer("biome_pool_warm_rare", 200L, ExtendedBiomeId.listOf("minecraft:badlands*plateau", "minecraft:wooded_badlands", "minecraft:wooded_badlands"));
        layerArray[33] = new RandomBiomeLayer("biome_pool_temperate", 200L, bedrock ? ExtendedBiomeId.listOf("minecraft:forest", "minecraft:dark_forest", "minecraft:windswept_hills", "minecraft:plains", "minecraft:plains", "minecraft:plains", "minecraft:birch_forest", "minecraft:swamp") : ExtendedBiomeId.listOf("minecraft:forest", "minecraft:dark_forest", "minecraft:windswept_hills", "minecraft:plains", "minecraft:birch_forest", "minecraft:swamp"));
        layerArray[34] = new ConstantBiomeLayer("biome_pool_temperate_rare", 200L, ExtendedBiomeId.of("minecraft:jungle"));
        layerArray[35] = new RandomBiomeLayer("biome_pool_cool", 200L, ExtendedBiomeId.listOf("minecraft:forest", "minecraft:windswept_hills", "minecraft:taiga", "minecraft:plains"));
        layerArray[36] = new ConstantBiomeLayer("biome_pool_cool_rare", 200L, ExtendedBiomeId.of("minecraft:old_growth_pine_taiga"));
        layerArray[37] = new RandomBiomeLayer("biome_pool_snowy", 200L, ExtendedBiomeId.listOf("minecraft:snowy_plains", "minecraft:snowy_plains", "minecraft:snowy_plains", "minecraft:snowy_taiga"));
        layerArray[38] = new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.CLIMATE_WARM, LayerTarget.layer("biome_pool_warm"), ExtendedBiomeId.CLIMATE_WARM_RARE.get(0).asWeak(), LayerTarget.layer("biome_pool_warm_rare"), ExtendedBiomeId.CLIMATE_TEMPERATE, LayerTarget.layer("biome_pool_temperate"), ExtendedBiomeId.CLIMATE_TEMPERATE_RARE.get(0).asWeak(), LayerTarget.layer("biome_pool_temperate_rare"), ExtendedBiomeId.CLIMATE_COOL, LayerTarget.layer("biome_pool_cool"), ExtendedBiomeId.CLIMATE_COOL_RARE.get(0).asWeak(), LayerTarget.layer("biome_pool_cool_rare"), ExtendedBiomeId.CLIMATE_SNOWY, LayerTarget.layer("biome_pool_snowy"), ExtendedBiomeId.CLIMATE_SNOWY_RARE.get(0).asWeak(), LayerTarget.layer("biome_pool_snowy")));
        layerArray[39] = modernBiomes ? BiomeReplacementLayer.toBiomes("modern_land", 3000L, "land", modernVariants) : null;
        layerArray[40] = modernBiomes ? new ConditionalOverlayLayer("land", 1003L, "land", BiomePredicate.oneIn(5), LayerTarget.layer("modern_land"), LayerTarget.none()) : null;
        Layer layer = layerArray[41] = bambooJungles ? new ConditionalOverlayLayer("land", 1001L, "land", BiomePredicate.of(ExtendedBiomeId.of("minecraft:jungle")).and(BiomePredicate.oneIn(10)), LayerTarget.biome("minecraft:bamboo_jungle"), LayerTarget.none()) : null;
        layerArray[42] = bedrock ? StackedZoomLayer.modal("land", 1001L, "land", 2, 0) : StackedZoomLayer.modal("land", 1000L, "land", finiteSize <= 0 || finiteSize >= 5120 ? 2 : (finiteSize >= 3072 ? 1 : 0));
        layerArray[43] = new PredicateOverlayLayer("land", 0L, "land", Stream.of(PredicateOverlayLayer.Target.biome(BiomePredicate.inSet(ExtendedBiomeId.of("minecraft:wooded_badlands"), ExtendedBiomeId.of("minecraft:badlands*plateau")).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet((Set)biomeCategories.get("badlands_all")), 4).invert()), ExtendedBiomeId.of("minecraft:badlands")), PredicateOverlayLayer.Target.borderTransition(ExtendedBiomeId.of("minecraft:old_growth_pine_taiga"), (Set)biomeCategories.get("taiga"), ExtendedBiomeId.of("minecraft:taiga")), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("minecraft:desert")).and(BiomePredicate.neighborsMatch(ExtendedBiomeId.of("minecraft:snowy_plains"), 1)), ExtendedBiomeId.of("minecraft:windswept_forest")), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("minecraft:swamp")).and(BiomePredicate.neighborsMatch(ExtendedBiomeId.of("minecraft:jungle"), 1)), ExtendedBiomeId.of("minecraft:sparse_jungle")), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("minecraft:swamp")).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet(ExtendedBiomeId.of("minecraft:desert"), ExtendedBiomeId.of("minecraft:snowy_taiga"), ExtendedBiomeId.of("minecraft:snowy_plains")), 1)), ExtendedBiomeId.of("minecraft:plains"))).filter(Objects::nonNull).toList());
        layerArray[44] = BiomeReplacementLayer.toBiomes("hills", 0L, "land", hillVariants);
        layerArray[45] = new RandomBiomeLayer("deep_ocean_islands", 1000L, ExtendedBiomeId.listOf("minecraft:plains", "minecraft:forest")).skipRandom(2);
        layerArray[46] = new PredicateOverlayLayer("hills", 1000L, "hills", List.of(PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("minecraft:forest")).and(BiomePredicate.oneIn(1)).and(BiomePredicate.oneIn(3)), ExtendedBiomeId.of("minecraft:forest*hills")), PredicateOverlayLayer.Target.layer(BiomePredicate.of(ExtendedBiomeId.of("minecraft:deep_ocean")).and(BiomePredicate.oneIn(1)).and(BiomePredicate.oneIn(3)), "deep_ocean_islands"), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("minecraft:ocean")), ExtendedBiomeId.of("minecraft:deep_ocean"))));
        layerArray[47] = new ConditionalOverlayLayer("hills", 1000L, "mutation", BiomePredicate.oneIn(3).or(BiomePredicate.wrappedIntMatch(29, 0)), LayerTarget.layer("hills"), LayerTarget.layer("land"));
        layerArray[48] = BiomeReplacementLayer.toBiomes("mutated_hills", 0L, "hills", mutatedVariants);
        layerArray[49] = new ConditionalOverlayLayer("hills", 0L, "mutation", BiomePredicate.wrappedIntMatch(29, 0), LayerTarget.layer("mutated_hills"), LayerTarget.layer("hills"));
        layerArray[50] = new ConditionalOverlayLayer("land_with_hills", 0L, "land", hillPredicate, LayerTarget.layer("hills"), LayerTarget.layer("land"));
        layerArray[51] = BiomeReplacementLayer.toBiomes("mutated_land", 0L, "land", mutatedVariants);
        layerArray[52] = new ConditionalOverlayLayer("mutated_land", 0L, "mutation", BiomePredicate.wrappedIntMatch(29, 1), LayerTarget.layer("mutated_land"), LayerTarget.layer("land_with_hills"));
        layerArray[53] = new ConditionalOverlayLayer("land", 0L, "land", BiomePredicate.of(ExtendedBiomeId.OCEAN).invert(), LayerTarget.layer("mutated_land"), LayerTarget.layer("land_with_hills"));
        layerArray[54] = new ConditionalOverlayLayer("land", 1001L, "land", BiomePredicate.of(ExtendedBiomeId.PLAINS).and(BiomePredicate.oneIn(57)), LayerTarget.biome("sunflower_plains"), LayerTarget.none());
        layerArray[55] = new ModalZoomLayer("land", 1000L, "land");
        layerArray[56] = AddLandLayer.forMajorRelease("land", 3L, "land");
        layerArray[57] = !usesBiomeScale ? ConditionalOverlayLayer.mushroomIslands() : null;
        layerArray[58] = new ModalZoomLayer("land", 1001L, "land");
        layerArray[59] = !usesBiomeScale ? new ConditionalOverlayLayer("land", 0L, "land", BiomePredicate.diagonalNeighborsMatch(ExtendedBiomeId.MUSHROOM_ISLAND, 1), LayerTarget.biome(ExtendedBiomeId.MUSHROOM_ISLAND), LayerTarget.none()) : null;
        layerArray[60] = new PredicateOverlayLayer("land", 0L, "land", List.of(PredicateOverlayLayer.Target.MUSHROOM_SHORE, PredicateOverlayLayer.Target.biome(BiomePredicate.inSet((Set)biomeCategories.get("jungle")).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet((Set)biomeCategories.get("jungle_like")).invert(), 1)), ExtendedBiomeId.of("minecraft:sparse_jungle")), PredicateOverlayLayer.Target.exclusiveBeach(modernBiomes ? Stream.concat(((Set)biomeCategories.get("windswept_hills")).stream(), Stream.of(ExtendedBiomeId.of("minecraft:cherry_grove"))).collect(Collectors.toSet()) : (Set)biomeCategories.get("windswept_hills"), oceansPredicate, ExtendedBiomeId.of("minecraft:stony_shore")), PredicateOverlayLayer.Target.exclusiveBeach((Set)biomeCategories.get("snowy"), oceansPredicate, ExtendedBiomeId.of("minecraft:snowy_beach")), PredicateOverlayLayer.Target.biome(BiomePredicate.inSet(ExtendedBiomeId.setOf("minecraft:badlands", "minecraft:wooded_badlands")).and(BiomePredicate.neighborsMatch(oceansPredicate, 1).invert()).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet((Set)biomeCategories.get("badlands_all")).invert(), 1)), ExtendedBiomeId.of("minecraft:desert")), PredicateOverlayLayer.Target.inclusiveBeach(ExtendedBiomeId.setOf("minecraft:ocean", "minecraft:deep_ocean", "minecraft:river", "minecraft:swamp", "minecraft:mangrove_swamp", "minecraft:mushroom_fields", "minecraft:badlands", "minecraft:wooded_badlands"), oceansPredicate, ExtendedBiomeId.BEACH), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("moderner_beta:early_release_extreme_hills")).and(BiomePredicate.border()), ExtendedBiomeId.of("moderner_beta:early_release_extreme_hills*edge"))));
        layerArray[61] = StackedZoomLayer.modal("land", 1002L, "land", 2 + biomeScale);
        layerArray[62] = new SmoothLayer("land", 1000L, "land");
        layerArray[63] = MixRiverLayer.forMajorRelease("land", 0L, "land", "river");
        layerArray[64] = climaticOceans ? (bedrock ? new WeightedPoolLayer("ocean_climate", 2L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.WARM_OCEAN), 8).method_34975((Object)LayerTarget.biome(ExtendedBiomeId.LUKEWARM_OCEAN), 32).method_34975((Object)LayerTarget.biome(ExtendedBiomeId.OCEAN), 28).method_34975((Object)LayerTarget.biome(ExtendedBiomeId.COLD_OCEAN), 27).method_34975((Object)LayerTarget.biome(ExtendedBiomeId.FROZEN_OCEAN), 5).method_34974()) : new MappedNoiseLayer("ocean_climate", 2L, List.of(new MappedNoiseLayer.Entry(0.4, ExtendedBiomeId.WARM_OCEAN), new MappedNoiseLayer.Entry(0.2, ExtendedBiomeId.LUKEWARM_OCEAN), new MappedNoiseLayer.Entry(0.0, ExtendedBiomeId.OCEAN), new MappedNoiseLayer.Entry(-0.2, ExtendedBiomeId.COLD_OCEAN), new MappedNoiseLayer.Entry(-0.4, ExtendedBiomeId.FROZEN_OCEAN)), 8.0, DoubleList.of((double)1.0), false)) : null;
        Layer layer2 = layerArray[65] = climaticOceans && bedrock ? new ConditionalOverlayLayer("ocean_climate", 2L, "ocean_climate", BiomePredicate.anyOf(BiomePredicate.of(ExtendedBiomeId.WARM_OCEAN).and(BiomePredicate.neighborsMatch(ExtendedBiomeId.FROZEN_OCEAN, 1)), BiomePredicate.of(ExtendedBiomeId.FROZEN_OCEAN).and(BiomePredicate.neighborsMatch(ExtendedBiomeId.WARM_OCEAN, 1))), LayerTarget.biome(ExtendedBiomeId.OCEAN), LayerTarget.none()) : null;
        Layer layer3 = climaticOceans ? (bedrock ? StackedZoomLayer.modal("ocean_climate", 2002L, "ocean_climate", 6, 0) : StackedZoomLayer.modal("ocean_climate", 2001L, "ocean_climate", 6)) : (layerArray[66] = null);
        layerArray[67] = climaticOceans ? new ApplyOceanClimateLayer("land", 0L, "land", "ocean_climate", !bedrock) : null;
        layerArray[68] = finiteSize > 0 ? new ConditionalOverlayLayer("land", 0L, "land", BiomePredicate.inRange(0, 0, finiteSize / 8, finiteSize / 8, true, InRangeBiomePredicate.Shape.RECTANGLE), LayerTarget.none(), LayerTarget.biome(ExtendedBiomeId.OCEAN)) : null;
        List<Layer> layers = Stream.of(layerArray).filter(Objects::nonNull).toList();
        return new ConfiguredLayers(layers, Map.of(ModernBetaBuiltInTypes.LayerOutput.BIOME.id, "land"));
    }

    private static ModernBetaSettingsPreset preset1122(boolean amplified, int biomeScale, boolean bedrock) {
        Map<ExtendedBiomeId, HeightConfig> heightOverrides = HeightConfig.MAJOR_RELEASE_CONFIGS;
        if (bedrock) {
            heightOverrides = new HashMap<ExtendedBiomeId, HeightConfig>(heightOverrides);
            heightOverrides.put(ExtendedBiomeId.of("minecraft:wooded_badlands"), heightOverrides.get(ExtendedBiomeId.of("minecraft:badlands")));
        }
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, bedrock ? ModernBetaBuiltInTypes.Chunk.EARLY_BEDROCK.id : ModernBetaBuiltInTypes.Chunk.MAJOR_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, bedrock ? NoiseScale.DEFAULT : NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.USE_SURFACE_RULES, true).add(SettingsComponentTypes.CAVE_GENERATION, bedrock ? CaveGeneration.BEDROCK : CaveGeneration.RELEASE_1_12_2).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(heightOverrides, amplified)).build(), ModernBetaSettings.fractalLayers(ModernBetaSettingsPresets.configuredLayers1710Era(biomeScale, 0, bedrock, false, false, false, false, false)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.MAJOR_RELEASE).add(SettingsComponentTypes.USE_32BIT_LAYER_SEED, bedrock).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset preset1171(boolean amplified, int biomeScale, boolean bedrock) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, bedrock ? ModernBetaBuiltInTypes.Chunk.EARLY_BEDROCK.id : ModernBetaBuiltInTypes.Chunk.MAJOR_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, bedrock ? NoiseScale.DEFAULT : NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.USE_SURFACE_RULES, true).add(SettingsComponentTypes.CAVE_GENERATION, bedrock ? CaveGeneration.BEDROCK : CaveGeneration.RELEASE_1_17_1).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(HeightConfig.MAJOR_RELEASE_CONFIGS, amplified)).build(), ModernBetaSettings.fractalLayers(ModernBetaSettingsPresets.configuredLayers1710Era(biomeScale, 0, bedrock, true, true, true, true, false)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.MAJOR_RELEASE).add(SettingsComponentTypes.USE_32BIT_LAYER_SEED, bedrock).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetReleaseXboxLegacy(int finiteSize) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.MAJOR_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.USE_SURFACE_RULES, true).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.RELEASE_1_12_2).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(HeightConfig.MAJOR_RELEASE_CONFIGS)).add(SettingsComponentTypes.ISLES_PROPERTIES, IslesProperties.xboxLegacy(finiteSize)).build(), ModernBetaSettings.fractalLayers(ModernBetaSettingsPresets.configuredLayers1710Era(0, finiteSize, false, false, false, false, false, false)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.MAJOR_RELEASE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetSnowAintSnowier(boolean amplified, int biomeScale) {
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.MAJOR_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.USE_SURFACE_RULES, true).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.RELEASE_1_17_1).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(HeightConfig.MAJOR_RELEASE_CONFIGS, amplified)).build(), ModernBetaSettings.fractalLayers(ModernBetaSettingsPresets.configuredLayers1710Era(biomeScale, 0, false, true, true, true, true, true)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.MAJOR_RELEASE).build(), DEFAULT_BETA.caveBiomeSettings());
    }

    private static ModernBetaSettingsPreset presetReleaseHybrid(boolean amplified, int biomeScale) {
        Map<ExtendedBiomeId, ExtendedBiomeId> hillsVariants = Map.ofEntries(ExtendedBiomeId.of("minecraft:desert").mapTo("*hills"), ExtendedBiomeId.of("minecraft:forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:windswept_hills").mapTo("minecraft:windswept_forest"), ExtendedBiomeId.of("minecraft:swamp").mapTo("*hills"), ExtendedBiomeId.of("minecraft:plains").mapTo("minecraft:forest"), ExtendedBiomeId.of("minecraft:taiga").mapTo("*hills"), ExtendedBiomeId.of("minecraft:jungle").mapTo("*hills"), ExtendedBiomeId.of("minecraft:snowy_taiga").mapTo("*hills"), ExtendedBiomeId.of("minecraft:snowy_plains").mapTo("*hills"), ExtendedBiomeId.of("minecraft:savanna").mapTo("minecraft:savanna_plateau"), ExtendedBiomeId.of("minecraft:dark_forest").mapTo("minecraft:plains"), ExtendedBiomeId.of("minecraft:birch_forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:old_growth_birch_forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:wooded_badlands").mapTo("minecraft:badlands"), ExtendedBiomeId.of("minecraft:mangrove_swamp").mapTo("*hills"), ExtendedBiomeId.of("minecraft:flower_forest").mapTo("*hills"), ExtendedBiomeId.of("minecraft:sparse_jungle").mapTo("minecraft:jungle"), ExtendedBiomeId.of("minecraft:badlands*plateau").mapTo("minecraft:badlands"));
        Map<ExtendedBiomeId, ExtendedBiomeId> mutatedVariants = Map.ofEntries(ExtendedBiomeId.of("minecraft:plains").mapTo("minecraft:sunflower_plains"), ExtendedBiomeId.of("minecraft:forest").mapTo("minecraft:flower_forest"), ExtendedBiomeId.of("minecraft:forest*hills").mapTo("minecraft:flower_forest*hills"), ExtendedBiomeId.of("minecraft:swamp").mapTo("minecraft:swamp*hills"), ExtendedBiomeId.of("minecraft:savanna").mapTo("minecraft:windswept_savanna"), ExtendedBiomeId.of("minecraft:savanna_plateau").mapTo("minecraft:windswept_savanna*plateau"), ExtendedBiomeId.of("minecraft:badlands*plateau").mapTo("minecraft:wooded_badlands"), ExtendedBiomeId.of("minecraft:birch_forest").mapTo("minecraft:old_growth_birch_forest"), ExtendedBiomeId.of("minecraft:birch_forest*hills").mapTo("minecraft:old_growth_birch_forest*hills"), ExtendedBiomeId.of("minecraft:old_growth_pine_taiga").mapTo("minecraft:old_growth_spruce_taiga"), ExtendedBiomeId.of("minecraft:old_growth_pine_taiga*hills").mapTo("minecraft:old_growth_spruce_taiga*hills"), ExtendedBiomeId.of("minecraft:windswept_hills").mapTo("minecraft:windswept_gravelly_hills"), ExtendedBiomeId.of("minecraft:windswept_forest").mapTo("minecraft:windswept_gravelly_hills"), ExtendedBiomeId.of("minecraft:snowy_plains").mapTo("minecraft:ice_spikes"));
        return new ModernBetaSettingsPreset(DEFAULT_BETA.chunkSettings().extend().add(SettingsComponentTypes.PROVIDER, ModernBetaBuiltInTypes.Chunk.EARLY_RELEASE.id).add(SettingsComponentTypes.NOISE_SCALE, NoiseScale.WITHOUT_FARLANDS).add(SettingsComponentTypes.USE_SURFACE_RULES, true).add(SettingsComponentTypes.CAVE_GENERATION, CaveGeneration.EARLY_RELEASE).add(SettingsComponentTypes.FORCED_BIOME_HEIGHT, ForcedBiomeHeight.overridesOnly(Map.ofEntries(Map.entry(ExtendedBiomeId.of("minecraft:desert*hills"), new HeightConfig(0.3f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:forest*hills"), new HeightConfig(0.3f, 0.7f)), Map.entry(ExtendedBiomeId.of("minecraft:taiga*hills"), new HeightConfig(0.3f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:dark_forest*hills"), new HeightConfig(0.3f, 0.7f)), Map.entry(ExtendedBiomeId.of("minecraft:birch_forest*hills"), new HeightConfig(0.3f, 0.7f)), Map.entry(ExtendedBiomeId.of("minecraft:old_growth_birch_forest"), new HeightConfig(0.1f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:old_growth_birch_forest*hills"), new HeightConfig(0.3f, 1.3f)), Map.entry(ExtendedBiomeId.of("minecraft:flower_forest"), new HeightConfig(0.1f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:flower_forest*hills"), new HeightConfig(0.3f, 1.3f)), Map.entry(ExtendedBiomeId.of("minecraft:old_growth_spruce_taiga*hills"), new HeightConfig(0.3f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:snowy_taiga*hills"), new HeightConfig(0.3f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:snowy_plains*hills"), new HeightConfig(0.3f, 1.3f)), Map.entry(ExtendedBiomeId.of("minecraft:jungle*hills"), new HeightConfig(1.8f, 0.5f)), Map.entry(ExtendedBiomeId.of("minecraft:badlands*plateau"), new HeightConfig(1.8f, 0.2f)), Map.entry(ExtendedBiomeId.of("minecraft:wooded_badlands"), new HeightConfig(1.8f, 0.2f)), Map.entry(ExtendedBiomeId.of("minecraft:cherry_grove"), new HeightConfig(1.8f, 0.5f)), Map.entry(ExtendedBiomeId.of("minecraft:cherry_grove*edge"), new HeightConfig(0.8f, 0.3f)), Map.entry(ExtendedBiomeId.of("minecraft:windswept_hills"), new HeightConfig(0.3f, 1.5f)), Map.entry(ExtendedBiomeId.of("minecraft:windswept_forest"), new HeightConfig(0.3f, 1.5f)), Map.entry(ExtendedBiomeId.of("minecraft:windswept_gravelly_hills"), new HeightConfig(0.3f, 1.5f)), Map.entry(ExtendedBiomeId.of("minecraft:meadow"), new HeightConfig(1.0f, 1.0f)), Map.entry(ExtendedBiomeId.of("minecraft:stony_shore"), new HeightConfig(0.1f, 1.6f)), Map.entry(ExtendedBiomeId.of("minecraft:ice_spikes"), new HeightConfig(0.3f, 0.8f)), Map.entry(ExtendedBiomeId.of("minecraft:windswept_savanna"), new HeightConfig(0.3f, 1.5f)), Map.entry(ExtendedBiomeId.of("minecraft:windswept_savanna*plateau"), new HeightConfig(1.0f, 1.0f))), amplified)).build(), ModernBetaSettings.fractalLayers(Map.of(ModernBetaBuiltInTypes.LayerOutput.BIOME.id, "land"), new InitLandLayer("land", 1L), new FuzzyZoomLayer("land", 2000L, "land"), AddLandLayer.forIslandScale("land", 1L, "land"), new ModalZoomLayer("land", 2001L, "land"), AddLandLayer.forIslandScale("land", 2L, "land"), new WeightedPoolLayer("snow", 2L, (class_6005<LayerTarget>)class_6005.method_34971().method_34975((Object)LayerTarget.biome(ExtendedBiomeId.SNOWY_PLAINS), 1).method_34975((Object)LayerTarget.none(), 4).method_34974()), new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("snow"))), new ModalZoomLayer("land", 2002L, "land"), AddLandLayer.forIslandScale("land", 3L, "land"), new ModalZoomLayer("land", 2003L, "land"), AddLandLayer.forIslandScale("land", 4L, "land"), ConditionalOverlayLayer.mushroomIslands(), new InitRiverLayer("river", 100L, "land"), StackedZoomLayer.modal("river", 1000L, "river", 6 + biomeScale), new ComputeRiverLayer("river", 0L, "river", true), new SmoothLayer("river", 1000L, "river"), new RandomBiomeLayer("biome_pool", 200L, ExtendedBiomeId.listOf("minecraft:desert", "minecraft:desert", "minecraft:desert", "minecraft:desert", "minecraft:badlands*plateau", "minecraft:badlands*plateau", "minecraft:forest", "minecraft:forest", "minecraft:forest", "minecraft:dark_forest", "minecraft:birch_forest", "minecraft:cherry_grove", "minecraft:windswept_hills", "minecraft:windswept_hills", "minecraft:windswept_hills", "minecraft:windswept_hills", "minecraft:meadow", "minecraft:meadow", "minecraft:swamp", "minecraft:swamp", "minecraft:swamp", "minecraft:swamp", "minecraft:mangrove_swamp", "minecraft:mangrove_swamp", "minecraft:plains", "minecraft:plains", "minecraft:plains", "minecraft:plains", "minecraft:savanna", "minecraft:savanna", "minecraft:taiga", "minecraft:taiga", "minecraft:taiga", "minecraft:taiga", "minecraft:old_growth_spruce_taiga", "minecraft:old_growth_spruce_taiga", "minecraft:jungle", "minecraft:jungle", "minecraft:jungle", "minecraft:jungle", "minecraft:jungle", "minecraft:sparse_jungle")), new RandomBiomeLayer("snowy_biome_pool", 200L, ExtendedBiomeId.listOf("minecraft:snowy_plains", "minecraft:snowy_plains", "minecraft:snowy_plains", "minecraft:snowy_taiga")), new BiomeReplacementLayer("land", 0L, "land", Map.of(ExtendedBiomeId.PLAINS, LayerTarget.layer("biome_pool"), ExtendedBiomeId.FROZEN_OCEAN, LayerTarget.layer("snowy_biome_pool"), ExtendedBiomeId.SNOWY_PLAINS, LayerTarget.layer("snowy_biome_pool"))), StackedZoomLayer.modal("land", 1000L, "land", 2), BiomeReplacementLayer.toBiomes("hills", 0L, "land", hillsVariants), new ConditionalOverlayLayer("land", 1000L, "land", BiomePredicate.inSet(hillsVariants.keySet()).and(BiomePredicate.identicalNeighbors(3, false)).and(BiomePredicate.oneIn(3)), LayerTarget.layer("hills"), LayerTarget.none()), BiomeReplacementLayer.toBiomes("mutated_land", 0L, "land", mutatedVariants), new MappedNoiseLayer("mutation", 7L, List.of(new MappedNoiseLayer.Entry(-0.3333333333333333, ExtendedBiomeId.of("minecraft:the_void*mutation")), new MappedNoiseLayer.Entry(0.0, ExtendedBiomeId.NULL)), 2.0, DoubleList.of((double)1.0), true), StackedZoomLayer.modal("mutation", 2005L, "mutation", 2), new ConditionalOverlayLayer("land", 1000L, "mutation", BiomePredicate.of(ExtendedBiomeId.of("minecraft:the_void*mutation")), LayerTarget.layer("mutated_land"), LayerTarget.layer("land")), new ModalZoomLayer("land", 1000L, "land"), AddLandLayer.forEarlyRelease("land", 3L, "land", ExtendedBiomeId.of((class_5321<class_1959>)class_1972.field_35117)), new ModalZoomLayer("land", 1001L, "land"), new PredicateOverlayLayer("land", 0L, "land", List.of(PredicateOverlayLayer.Target.MUSHROOM_SHORE, PredicateOverlayLayer.Target.exclusiveBeach(ExtendedBiomeId.setOf("minecraft:meadow", "minecraft:cherry_grove"), ExtendedBiomeId.of("minecraft:stony_shore")), PredicateOverlayLayer.Target.biome(BiomePredicate.of(ExtendedBiomeId.of("minecraft:cherry_grove")).and(BiomePredicate.border()), ExtendedBiomeId.of("minecraft:cherry_grove*edge")), PredicateOverlayLayer.Target.biome(BiomePredicate.inSet(ExtendedBiomeId.of("minecraft:badlands*plateau"), ExtendedBiomeId.of("minecraft:wooded_badlands")).and(BiomePredicate.neighborsMatch(BiomePredicate.inSet(ExtendedBiomeId.of("~minecraft:badlands"), ExtendedBiomeId.of("~minecraft:wooded_badlands"), ExtendedBiomeId.of("~minecraft:eroded_badlands")), 4).invert()), ExtendedBiomeId.of("minecraft:badlands")), PredicateOverlayLayer.Target.inclusiveBeach(ExtendedBiomeId.setOf("minecraft:ocean", "minecraft:river", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:meadow", "minecraft:badlands", "minecraft:swamp", "minecraft:mangrove_swamp"), ExtendedBiomeId.BEACH))), StackedZoomLayer.modal("land", 1002L, "land", 2 + biomeScale), new SmoothLayer("land", 1000L, "land"), MixRiverLayer.forEarlyRelease("land", 0L, "land", "river"), new MappedNoiseLayer("ocean_climate", 2L, List.of(new MappedNoiseLayer.Entry(0.4, ExtendedBiomeId.WARM_OCEAN), new MappedNoiseLayer.Entry(0.2, ExtendedBiomeId.LUKEWARM_OCEAN), new MappedNoiseLayer.Entry(0.0, ExtendedBiomeId.OCEAN), new MappedNoiseLayer.Entry(-0.2, ExtendedBiomeId.COLD_OCEAN), new MappedNoiseLayer.Entry(-0.4, ExtendedBiomeId.FROZEN_OCEAN)), 8.0, DoubleList.of((double)1.0), false), StackedZoomLayer.modal("ocean_climate", 2001L, "ocean_climate", 6), new ApplyOceanClimateLayer("land", 0L, "land", "ocean_climate", true)).add(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING, TemperatureHeightScaling.MAJOR_RELEASE).build(), DEFAULT_BETA.caveBiomeSettings());
    }
}

