/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.fabric.data;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2405;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_3499;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_6826;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ModernBetaStructureDatafixApplier
implements class_2405 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Iterable<Path> paths;
    private final class_7784 output;

    public ModernBetaStructureDatafixApplier(class_7784 output, Collection<Path> paths) {
        this.paths = paths;
        this.output = output;
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        Path output = this.output.method_45971();
        ArrayList<CompletionStage> list = new ArrayList<CompletionStage>();
        for (Path path : this.paths) {
            list.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])stream.filter(p -> p.toString().endsWith(".nbt")).map(p -> CompletableFuture.runAsync(() -> ModernBetaStructureDatafixApplier.datafixNBTFile(writer, p, ModernBetaStructureDatafixApplier.getLocation(path, p), output), class_156.method_27958())).toArray(CompletableFuture[]::new));
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to read input directory", (Throwable)e);
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    stream.close();
                }
                return completableFuture;
            }, class_156.method_18349()).thenCompose(future -> future));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public String method_10321() {
        return "Structure NBT Datafixer";
    }

    private static String getLocation(Path inputPath, Path filePath) {
        return inputPath.relativize(filePath).toString().replaceAll("\\\\", "/");
    }

    @Nullable
    public static Path datafixNBTFile(class_7403 writer, Path inputPath, String filename, Path outputPath) {
        Path path;
        class_6826 is = new class_6826(Files.newInputStream(inputPath, new OpenOption[0]));
        try {
            class_2487 read = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
            class_3499 structureTemplate = new class_3499();
            int dataVersion = class_2512.method_48309((class_2487)read, (int)500);
            class_2487 fixed = class_4284.field_19217.method_48130(class_3551.method_15450(), read, dataVersion);
            structureTemplate.method_15183((class_7871)class_7923.field_41175.method_46771(), fixed);
            class_2487 out = structureTemplate.method_15175(new class_2487());
            Path path2 = outputPath.resolve(filename);
            ModernBetaStructureDatafixApplier.writeTo(writer, path2, out);
            LOGGER.info("Datafixed structure file {}", (Object)filename);
            path = path2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                LOGGER.error("Couldn't datafix file {} located at {}", new Object[]{filename, inputPath, iOException});
                return null;
            }
        }
        is.close();
        return path;
    }

    public static void writeTo(class_7403 writer, Path path, class_2487 content) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HashingOutputStream hashing = new HashingOutputStream(Hashing.sha1(), (OutputStream)out);
        class_2507.method_10634((class_2487)content, (OutputStream)hashing);
        byte[] bytes = out.toByteArray();
        HashCode sha1 = hashing.hash();
        try {
            writer.method_43346(path, bytes, sha1);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't write structure file {}", (Object)path, (Object)e);
        }
    }
}

