/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.util.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.class_1923;
import net.minecraft.class_5539;
import org.apache.commons.lang3.function.TriFunction;

public class WorldChunkCache<T> {
    public static final int DEFAULT_SIZE = 512;
    public static final boolean DEFAULT_EVICT = true;
    private final String name;
    private final int capacity;
    private final boolean evictOldChunks;
    private final TriFunction<class_5539, Integer, Integer, T> chunkFunc;
    private final Long2ObjectLinkedOpenHashMap<T> chunkMap;
    private final StampedLock lock;

    public WorldChunkCache(String name, int capacity, boolean evictOldChunks, TriFunction<class_5539, Integer, Integer, T> chunkFunc) {
        this.name = name;
        this.capacity = capacity;
        this.evictOldChunks = evictOldChunks;
        this.chunkFunc = chunkFunc;
        this.chunkMap = new Long2ObjectLinkedOpenHashMap(capacity);
        this.lock = new StampedLock();
    }

    public WorldChunkCache(String name, int capacity, TriFunction<class_5539, Integer, Integer, T> chunkFunc) {
        this(name, capacity, true, chunkFunc);
    }

    public WorldChunkCache(String name, TriFunction<class_5539, Integer, Integer, T> chunkFunc) {
        this(name, 512, true, chunkFunc);
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.chunkMap.clear();
            this.chunkMap.trim();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(class_5539 world, int chunkX, int chunkZ) {
        Object chunk;
        long key = class_1923.method_8331((int)chunkX, (int)chunkZ);
        long stamp = this.lock.readLock();
        try {
            while ((chunk = this.chunkMap.get(key)) == null) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp != 0L) {
                    stamp = writeStamp;
                    chunk = this.createChunk(key, world, chunkX, chunkZ);
                    break;
                }
                this.lock.unlockRead(stamp);
                stamp = this.lock.writeLock();
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
        return (T)chunk;
    }

    private T createChunk(long key, class_5539 world, int chunkX, int chunkZ) {
        if (this.evictOldChunks && this.chunkMap.size() >= this.capacity) {
            this.chunkMap.removeFirst();
        }
        Object chunk = this.chunkFunc.apply((Object)world, (Object)chunkX, (Object)chunkZ);
        this.chunkMap.put(key, chunk);
        return (T)chunk;
    }
}

