/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.injector;

import java.util.Optional;
import java.util.function.Predicate;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.mixin.AccessorChunkSection;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.biome.injector.BiomeInjectionRules;
import mod.bluestaggo.modernerbeta.world.cavebiome.provider.CaveBiomeProviderNone;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7522;

public class BiomeInjector {
    public static final int OCEAN_START_DEPTH = 4;
    public static final int OCEAN_DEEP_START_DEPTH = 16;
    public static final int CAVE_START_DEPTH = 8;
    private final ModernBetaChunkGenerator modernBetaChunkGenerator;
    private final ModernBetaBiomeSource modernBetaBiomeSource;
    private final BiomeInjectionRules rulesPre;
    private final BiomeInjectionRules rulesPost;
    private final BiomeInjectionRules rulesAll;

    public BiomeInjector(ModernBetaChunkGenerator modernBetaChunkGenerator, ModernBetaBiomeSource modernBetaBiomeSource) {
        this.modernBetaChunkGenerator = modernBetaChunkGenerator;
        this.modernBetaBiomeSource = modernBetaBiomeSource;
        ModernBetaSettings settingsBiome = ModernBetaSettings.fromCompound(this.modernBetaBiomeSource.getBiomeSettings()).mapPreset(modernBetaChunkGenerator.getPresetRegistry(), ModernBetaSettingsPreset::biomeSettings);
        boolean useOceanBiomes = settingsBiome.getOrDefault(SettingsComponentTypes.USE_OCEAN_BIOMES);
        Predicate<BiomeInjectionRules.BiomeInjectionContext> cavePredicate = context -> context.getY() >= context.worldMinY && context.getY() + 8 < context.minHeight;
        Predicate<BiomeInjectionRules.BiomeInjectionContext> oceanPredicate = context -> modernBetaBiomeSource.hasOceanBiomes() && this.atOceanDepth(context.topHeight, 4);
        Predicate<BiomeInjectionRules.BiomeInjectionContext> deepOceanPredicate = context -> modernBetaBiomeSource.hasOceanBiomes() && this.atOceanDepth(context.topHeight, 16);
        BiomeInjectionRules.Builder builderPre = new BiomeInjectionRules.Builder();
        BiomeInjectionRules.Builder builderPost = new BiomeInjectionRules.Builder();
        BiomeInjectionRules.Builder builderAll = new BiomeInjectionRules.Builder();
        if (!(this.modernBetaBiomeSource.getCaveBiomeProvider() instanceof CaveBiomeProviderNone)) {
            builderPost.add(cavePredicate, this.modernBetaBiomeSource::getCaveBiome);
        }
        if (useOceanBiomes) {
            builderPost.add(deepOceanPredicate, this.modernBetaBiomeSource::getDeepOceanBiome);
            builderPost.add(oceanPredicate, this.modernBetaBiomeSource::getOceanBiome);
        }
        builderAll.add(builderPre).add(builderPost);
        this.rulesPre = builderPre.build();
        this.rulesPost = builderPost.build();
        this.rulesAll = builderAll.build();
    }

    public void injectBiomes(class_2791 chunk, class_6544.class_6552 noiseSampler, BiomeInjectionStep step) {
        if (this.rulesAll.isEmpty()) {
            return;
        }
        class_1923 chunkPos = chunk.method_12004();
        int startBiomeX = chunkPos.method_8326() >> 2;
        int startBiomeZ = chunkPos.method_8328() >> 2;
        class_5539 view = chunk.method_39460();
        for (int sectionY = view.method_32891(); sectionY < view.method_31597(); ++sectionY) {
            int sectionYNdx = chunk.method_31603(sectionY);
            class_2826 section = chunk.method_38259(sectionYNdx);
            class_7522 readableContainer = section.method_38294();
            class_2841 palettedContainer = section.method_38294().method_44350();
            for (int localBiomeX = 0; localBiomeX < 4; ++localBiomeX) {
                for (int localBiomeZ = 0; localBiomeZ < 4; ++localBiomeZ) {
                    int biomeX = localBiomeX + startBiomeX;
                    int biomeZ = localBiomeZ + startBiomeZ;
                    for (int localBiomeY = 0; localBiomeY < 4; ++localBiomeY) {
                        int biomeY = localBiomeY + sectionY << 2;
                        class_6880 initialBiome = (class_6880)readableContainer.method_12321(localBiomeX, localBiomeY, localBiomeZ);
                        class_6880<class_1959> replacementBiome = this.getOptionalBiome(view, biomeX, biomeY, biomeZ, noiseSampler, step).orElse((class_6880<class_1959>)initialBiome);
                        palettedContainer.method_35321(localBiomeX, localBiomeY, localBiomeZ, replacementBiome);
                    }
                }
            }
            ((AccessorChunkSection)section).setBiomeContainer((class_7522<class_6880<class_1959>>)palettedContainer);
        }
    }

    public class_6880<class_1959> getBiomeAtBlock(class_5539 world, int x, int y, int z, class_6544.class_6552 noiseSampler, BiomeInjectionStep step) {
        int biomeX = x >> 2;
        int biomeY = y >> 2;
        int biomeZ = z >> 2;
        return this.getBiome(world, biomeX, biomeY, biomeZ, noiseSampler, step);
    }

    public String getBiomeNameAtBlock(class_5539 world, int x, int y, int z, class_6544.class_6552 noiseSampler, BiomeInjectionStep step) {
        int biomeX = x >> 2;
        int biomeY = y >> 2;
        int biomeZ = z >> 2;
        class_5321 key = this.getBiome(world, biomeX, biomeY, biomeZ, noiseSampler, step).method_40230().orElse(null);
        if (key == null) {
            return "???";
        }
        return key.method_29177().toString();
    }

    public class_6880<class_1959> getBiome(class_5539 world, int biomeX, int biomeY, int biomeZ, class_6544.class_6552 noiseSampler, BiomeInjectionStep step) {
        if (this.rulesAll.isEmpty()) {
            return this.modernBetaBiomeSource.method_38109(biomeX, biomeY, biomeZ, noiseSampler);
        }
        BiomeInjectionRules.BiomeInjectionContext context = this.createContext(world, biomeX, biomeY, biomeZ);
        return this.getBiome(context, biomeX, biomeY, biomeZ, noiseSampler, step).orElseGet(() -> this.modernBetaBiomeSource.method_38109(biomeX, biomeY, biomeZ, noiseSampler));
    }

    public Optional<class_6880<class_1959>> getOptionalBiome(class_5539 world, int biomeX, int biomeY, int biomeZ, class_6544.class_6552 noiseSampler, BiomeInjectionStep step) {
        BiomeInjectionRules.BiomeInjectionContext context = this.createContext(world, biomeX, biomeY, biomeZ);
        return this.getBiome(context, biomeX, biomeY, biomeZ, noiseSampler, step);
    }

    private Optional<class_6880<class_1959>> getBiome(BiomeInjectionRules.BiomeInjectionContext context, int biomeX, int biomeY, int biomeZ, class_6544.class_6552 noiseSampler, BiomeInjectionStep step) {
        class_6880<class_1959> biome = switch (step.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.rulesPre.test(context, biomeX, biomeY, biomeZ);
            case 1 -> this.rulesPost.test(context, biomeX, biomeY, biomeZ);
            case 2 -> this.rulesAll.test(context, biomeX, biomeY, biomeZ);
        };
        return Optional.ofNullable(biome);
    }

    private BiomeInjectionRules.BiomeInjectionContext createContext(class_5539 world, int biomeX, int biomeY, int biomeZ) {
        int y = biomeY << 2;
        int worldMinY = this.modernBetaChunkGenerator.method_33730();
        int topHeight = this.sampleTopHeight(world, biomeX, biomeZ);
        int minHeight = this.sampleMinHeight(world, biomeX, biomeZ);
        return new BiomeInjectionRules.BiomeInjectionContext(worldMinY, topHeight, minHeight).setY(y);
    }

    private int sampleTopHeight(class_5539 world, int biomeX, int biomeZ) {
        int x = (biomeX << 2) + 2;
        int z = (biomeZ << 2) + 2;
        return this.modernBetaChunkGenerator.getHeight(x, z, class_2902.class_2903.field_13195, world);
    }

    private int sampleFloorHeight(class_5539 world, int biomeX, int biomeZ) {
        int n;
        int x = (biomeX << 2) + 2;
        int z = (biomeZ << 2) + 2;
        ChunkProvider chunkProvider = this.modernBetaChunkGenerator.getChunkProvider();
        if (chunkProvider instanceof ChunkProviderNoise) {
            ChunkProviderNoise chunkProviderNoise = (ChunkProviderNoise)chunkProvider;
            n = chunkProviderNoise.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = chunkProvider.getHeight(world, x, z, class_2902.class_2903.field_13195);
        }
        return n;
    }

    private int sampleMinHeight(class_5539 world, int centerBiomeX, int centerBiomeZ) {
        int minHeight = Integer.MAX_VALUE;
        for (int localBiomeX = -1; localBiomeX <= 1; ++localBiomeX) {
            for (int localBiomeZ = -1; localBiomeZ <= 1; ++localBiomeZ) {
                int biomeX = centerBiomeX + localBiomeX;
                int biomeZ = centerBiomeZ + localBiomeZ;
                minHeight = Math.min(minHeight, this.sampleFloorHeight(world, biomeX, biomeZ));
            }
        }
        return minHeight;
    }

    private boolean atOceanDepth(int topHeight, int oceanDepth) {
        return topHeight < this.modernBetaChunkGenerator.method_16398() - oceanDepth;
    }

    public static enum BiomeInjectionStep {
        PRE,
        POST,
        ALL;

    }
}

