/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.api.debug.DebugTextProvider2D;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverOcean;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.ClimateScale;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkCache;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkClimate;
import mod.bluestaggo.modernerbeta.util.noise.SimplexOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMapping;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateType;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointBiome;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointRules;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class BiomeProviderVoronoi
extends BiomeProvider
implements BiomeResolverOcean,
DebugTextProvider2D {
    private final VoronoiClimateSampler climateSampler;
    private final VoronoiPointRules<ClimateMapping, Clime> rules;

    public BiomeProviderVoronoi(ModernBetaSettings settings, class_7871<class_1959> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        List<VoronoiPointBiome> voronoiPoints = this.getSettings().getOrThrow(SettingsComponentTypes.VORONOI_POINTS);
        ClimateScale climateScale = this.getSettings().getOrDefault(SettingsComponentTypes.CLIMATE_SCALE);
        this.climateSampler = new VoronoiClimateSampler(seed, climateScale.temp(), climateScale.rain(), climateScale.detail(), climateScale.weird());
        this.rules = BiomeProviderVoronoi.buildRules(voronoiPoints);
    }

    @Override
    public class_6880<class_1959> getBiome(int biomeX, int biomeY, int biomeZ) {
        ClimateMapping climateMapping = this.getClimateMapping(biomeX, biomeZ);
        return this.biomeRegistry.method_46747(climateMapping.getBiome(ClimateType.LAND));
    }

    @Override
    public class_6880<class_1959> getOceanBiome(int biomeX, int biomeY, int biomeZ) {
        ClimateMapping climateMapping = this.getClimateMapping(biomeX, biomeZ);
        return this.biomeRegistry.method_46747(climateMapping.getBiome(ClimateType.OCEAN));
    }

    @Override
    public class_6880<class_1959> getDeepOceanBiome(int biomeX, int biomeY, int biomeZ) {
        ClimateMapping climateMapping = this.getClimateMapping(biomeX, biomeZ);
        return this.biomeRegistry.method_46747(climateMapping.getBiome(ClimateType.DEEP_OCEAN));
    }

    @Override
    public List<class_6880<class_1959>> getBiomes() {
        ArrayList biomes = new ArrayList();
        this.rules.getItems().forEach(key -> {
            biomes.add(key.biome());
            biomes.add(key.oceanBiome());
            biomes.add(key.deepOceanBiome());
        });
        return biomes.stream().distinct().map(key -> this.biomeRegistry.method_46747(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)key))).collect(Collectors.toList());
    }

    private ClimateMapping getClimateMapping(int biomeX, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        return this.rules.calculateClosestTo(clime);
    }

    private static VoronoiPointRules<ClimateMapping, Clime> buildRules(List<VoronoiPointBiome> points) {
        VoronoiPointRules.Builder<ClimateMapping, Clime> builder = new VoronoiPointRules.Builder<ClimateMapping, Clime>();
        for (VoronoiPointBiome point : points) {
            class_2960 biome = point.biome();
            class_2960 oceanBiome = point.oceanBiome();
            class_2960 deepOceanBiome = point.deepOceanBiome();
            double temp = class_3532.method_15350((double)point.temp(), (double)0.0, (double)1.0);
            double rain = class_3532.method_15350((double)point.rain(), (double)0.0, (double)1.0);
            double weird = class_3532.method_15350((double)point.weird(), (double)0.0, (double)1.0);
            ClimateMapping climateMapping = new ClimateMapping(biome, oceanBiome, deepOceanBiome);
            Clime clime = new Clime(temp, rain, weird);
            builder.add(climateMapping, clime);
        }
        return builder.build();
    }

    @Override
    public String getDebugText(int x, int z) {
        return this.climateSampler.getDebugText(x, z);
    }

    private static class VoronoiClimateSampler {
        private final SimplexOctaveNoise tempOctaveNoise;
        private final SimplexOctaveNoise rainOctaveNoise;
        private final SimplexOctaveNoise detailOctaveNoise;
        private final SimplexOctaveNoise weirdOctaveNoise;
        private final ChunkCache<ChunkClimate> chunkCacheClimate;
        private final double tempNoiseScale;
        private final double rainNoiseScale;
        private final double detailNoiseScale;
        private final double weirdNoiseScale;

        public VoronoiClimateSampler(long seed, double tempNoiseScale, double rainNoiseScale, double detailNoiseScale, double weirdNoiseScale) {
            this.tempOctaveNoise = new SimplexOctaveNoise(new Random(seed * 9871L), 4);
            this.rainOctaveNoise = new SimplexOctaveNoise(new Random(seed * 39811L), 4);
            this.detailOctaveNoise = new SimplexOctaveNoise(new Random(seed * 543321L), 2);
            this.weirdOctaveNoise = new SimplexOctaveNoise(new Random(seed * 134714L), 2);
            this.chunkCacheClimate = new ChunkCache<ChunkClimate>("climate", (chunkX, chunkZ) -> new ChunkClimate((int)chunkX, (int)chunkZ, this::sampleNoise));
            this.tempNoiseScale = tempNoiseScale;
            this.rainNoiseScale = rainNoiseScale;
            this.detailNoiseScale = detailNoiseScale;
            this.weirdNoiseScale = weirdNoiseScale;
        }

        public Clime sample(int x, int z) {
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            return this.chunkCacheClimate.get(chunkX, chunkZ).sampleClime(x, z);
        }

        public Clime sampleNoise(int x, int z) {
            double temp = this.tempOctaveNoise.sample(x, z, this.tempNoiseScale, 0.25);
            double rain = this.rainOctaveNoise.sample(x, z, this.rainNoiseScale, 0.3333333333333333);
            double detail = this.detailOctaveNoise.sample(x, z, this.detailNoiseScale, 0.5882352941176471);
            double weird = this.weirdOctaveNoise.sample(x, z, this.weirdNoiseScale, 0.2941176471);
            detail = detail * 1.1 + 0.5;
            weird = (weird / 1.525 + 1.0) / 2.0;
            temp = (temp * 0.15 + 0.7) * 0.99 + detail * 0.01;
            rain = (rain * 0.15 + 0.5) * 0.998 + detail * 0.002;
            temp = 1.0 - (1.0 - temp) * (1.0 - temp);
            temp = class_3532.method_15350((double)temp, (double)0.0, (double)1.0);
            rain = class_3532.method_15350((double)rain, (double)0.0, (double)1.0);
            weird = class_3532.method_15350((double)weird, (double)0.0, (double)1.0);
            return new Clime(temp, rain, weird);
        }

        private String getDebugText(int x, int z) {
            Clime clime = this.sample(x, z);
            double temp = clime.temp();
            double rain = clime.rain();
            double weird = clime.weird();
            return String.format("Climate Temp: %.3f Rainfall: %.3f Weirdness: %.3f", temp, rain, weird);
        }
    }
}

