/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SingleParentLayer;

public class FuzzyZoomLayer
extends SingleParentLayer {
    public static final MapCodec<FuzzyZoomLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> FuzzyZoomLayer.fillSingleParentLayerFields(instance).apply((Applicative)instance, FuzzyZoomLayer::new));

    public FuzzyZoomLayer(String id, long seed, String parent) {
        super(id, seed, parent);
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.FUZZY_ZOOM;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        int xHalf = x & 1;
        int zHalf = z & 1;
        int halfX = x >> 1;
        int halfZ = z >> 1;
        ExtendedBiomeId biome00 = this.parentLayer.sample(halfX, halfZ);
        if (xHalf == 0 && zHalf == 0) {
            return biome00;
        }
        LayerRandom random = this.getRandom(halfX << 1, halfZ << 1);
        if (xHalf == 0) {
            return random.method_43048(2) == 1 ? this.parentLayer.sample(halfX, halfZ + 1) : biome00;
        }
        if (zHalf == 0) {
            random.method_33650(1);
            return random.method_43048(2) == 1 ? this.parentLayer.sample(halfX + 1, halfZ) : biome00;
        }
        random.method_33650(2);
        int choice = random.method_43048(4);
        return switch (choice) {
            case 0 -> biome00;
            case 1 -> this.parentLayer.sample(halfX + 1, halfZ);
            case 2 -> this.parentLayer.sample(halfX, halfZ + 1);
            case 3 -> this.parentLayer.sample(halfX + 1, halfZ + 1);
            default -> throw new IllegalStateException("Unexpected value: " + choice);
        };
    }
}

