/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerRandom;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicate;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.predicates.BiomePredicateType;
import net.minecraft.class_3542;

public record InteriorBiomePredicate(Type type) implements BiomePredicate
{
    public static final MapCodec<InteriorBiomePredicate> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)class_3542.method_28140(Type::values).fieldOf("type").orElse((Object)Type.INTERIOR).forGetter(predicate -> predicate.type)).apply((Applicative)instance, InteriorBiomePredicate::new));

    @Override
    public BiomePredicateType<?> getType() {
        return BiomePredicateType.INTERIOR;
    }

    @Override
    public boolean matches(ExtendedBiomeId biome, Layer layer, Supplier<LayerRandom> randomSupplier, int x, int z) {
        return this.type.matches(biome, layer, x, z);
    }

    public static enum Type implements class_3542
    {
        INTERIOR("interior", false, false),
        DIAGONAL_INTERIOR("diagonal_interior", false, true),
        BORDER("border", true, false),
        DIAGONAL_BORDER("diagonal_border", true, true);

        public final String id;
        private final boolean border;
        private final boolean diagonal;

        private Type(String id, boolean border, boolean diagonal) {
            this.id = id;
            this.border = border;
            this.diagonal = diagonal;
        }

        public boolean matches(ExtendedBiomeId biome, Layer layer, int x, int z) {
            ExtendedBiomeId[] neighbors = this.diagonal ? layer.sampleDiagonalNeighbors(x, z) : layer.sampleNeighbors(x, z);
            return this.border != Layer.allNeighborsEqual(neighbors, biome);
        }

        public String method_15434() {
            return this.id;
        }
    }
}

