/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.cavebiome.provider;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.CaveBiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.climate.CaveClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.cavebiome.climate.CaveClime;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveBiomeVoronoi;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointCaveBiome;
import mod.bluestaggo.modernerbeta.world.biome.voronoi.VoronoiPointRules;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class CaveBiomeProviderVoronoi
extends CaveBiomeProvider
implements CaveClimateSampler {
    private final VoronoiCaveClimateSampler climateSampler;
    private final VoronoiPointRules<class_5321<class_1959>, CaveClime> rules;

    public CaveBiomeProviderVoronoi(ModernBetaSettings settings, class_7871<class_1959> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        CaveBiomeVoronoi voronoi = this.settings.getOrThrow(SettingsComponentTypes.CAVE_BIOME_VORONOI);
        this.climateSampler = new VoronoiCaveClimateSampler(seed, voronoi.verticalScale(), voronoi.horizontalScale(), voronoi.depthMinY(), voronoi.depthMaxY());
        this.rules = CaveBiomeProviderVoronoi.buildRules(voronoi.points());
    }

    @Override
    public class_6880<class_1959> getBiome(int biomeX, int biomeY, int biomeZ) {
        CaveClime clime = this.sample(biomeX, biomeY, biomeZ);
        class_5321<class_1959> biomeKey = this.rules.calculateClosestTo(clime);
        return biomeKey == null ? null : this.biomeRegistry.method_46747(biomeKey);
    }

    @Override
    public List<class_6880<class_1959>> getBiomes() {
        return this.rules.getItems().stream().distinct().map(key -> this.biomeRegistry.method_46747(key)).collect(Collectors.toList());
    }

    @Override
    public CaveClime sample(int x, int y, int z) {
        return this.climateSampler.sample(x, y, z);
    }

    private static VoronoiPointRules<class_5321<class_1959>, CaveClime> buildRules(List<VoronoiPointCaveBiome> points) {
        VoronoiPointRules.Builder<class_5321, CaveClime> builder = new VoronoiPointRules.Builder<class_5321, CaveClime>();
        for (VoronoiPointCaveBiome point : points) {
            class_5321 biomeKey = point.biome().isBlank() ? null : class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)VersionCompat.id(point.biome()));
            double temp = class_3532.method_15350((double)point.temp(), (double)0.0, (double)1.0);
            double rain = class_3532.method_15350((double)point.rain(), (double)0.0, (double)1.0);
            double depth = class_3532.method_15350((double)point.depth(), (double)0.0, (double)1.0);
            builder.add(biomeKey, new CaveClime(temp, rain, depth));
        }
        return builder.build();
    }

    @Override
    public String getDebugText(int x, int y, int z) {
        return this.climateSampler.getDebugText(x >> 2, y >> 2, z >> 2);
    }

    private static class VoronoiCaveClimateSampler {
        private final PerlinOctaveNoise tempOctaveNoise;
        private final PerlinOctaveNoise rainOctaveNoise;
        private final PerlinOctaveNoise detailOctaveNoise;
        private final float verticalScale;
        private final float horizontalScale;
        private final int depthMinY;
        private final int depthMaxY;

        public VoronoiCaveClimateSampler(long seed, float verticalScale, float horizontalScale, int depthMinY, int depthMaxY) {
            this.tempOctaveNoise = new PerlinOctaveNoise(new Random(seed * 9871L), 2, true);
            this.rainOctaveNoise = new PerlinOctaveNoise(new Random(seed * 39811L), 2, true);
            this.detailOctaveNoise = new PerlinOctaveNoise(new Random(seed * 543321L), 1, true);
            this.verticalScale = verticalScale;
            this.horizontalScale = horizontalScale;
            this.depthMinY = depthMinY >> 2;
            this.depthMaxY = depthMaxY >> 2;
        }

        public CaveClime sample(int x, int y, int z) {
            double tempNoise = this.tempOctaveNoise.sample((double)x / (double)this.horizontalScale, (double)y / (double)this.verticalScale, (double)z / (double)this.horizontalScale);
            double rainNoise = this.rainOctaveNoise.sample((double)x / (double)this.horizontalScale, (double)y / (double)this.verticalScale, (double)z / (double)this.horizontalScale);
            double detailNoise = this.detailOctaveNoise.sample((double)x / (double)this.horizontalScale, (double)y / (double)this.verticalScale, (double)z / (double)this.horizontalScale);
            tempNoise /= 1.4;
            rainNoise /= 1.4;
            tempNoise = tempNoise * 0.99 + (detailNoise /= 0.55) * 0.01;
            rainNoise = rainNoise * 0.98 + detailNoise * 0.02;
            tempNoise = (tempNoise + 1.0) / 2.0;
            rainNoise = (rainNoise + 1.0) / 2.0;
            int depthHeight = this.depthMaxY - this.depthMinY;
            double depth = class_3532.method_15340((int)y, (int)this.depthMinY, (int)this.depthMaxY);
            depth -= (double)this.depthMinY;
            return new CaveClime(class_3532.method_15350((double)tempNoise, (double)0.0, (double)1.0), class_3532.method_15350((double)rainNoise, (double)0.0, (double)1.0), class_3532.method_15350((double)(depth /= (double)depthHeight), (double)0.0, (double)1.0));
        }

        private String getDebugText(int x, int y, int z) {
            CaveClime clime = this.sample(x, y, z);
            double temp = clime.temp();
            double rain = clime.rain();
            return String.format("Cave Climate Temp: %.3f Rainfall: %.3f", temp, rain);
        }
    }
}

