/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk.provider;

import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderFinite;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.FiniteBeaches;
import mod.bluestaggo.modernerbeta.settings.component.FiniteCaveGeneration;
import mod.bluestaggo.modernerbeta.settings.component.FiniteNoise;
import mod.bluestaggo.modernerbeta.settings.component.FinitePools;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoiseCombined;
import mod.bluestaggo.modernerbeta.world.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3532;

public class ChunkProviderClassic030
extends ChunkProviderFinite {
    private PerlinOctaveNoiseCombined minHeightOctaveNoise;
    private PerlinOctaveNoiseCombined maxHeightOctaveNoise;
    private PerlinOctaveNoise mainHeightOctaveNoise;
    private PerlinOctaveNoise dirtOctaveNoise;
    private PerlinOctaveNoiseCombined erodeOctaveNoise0;
    private PerlinOctaveNoiseCombined erodeOctaveNoise1;
    private PerlinOctaveNoise sandOctaveNoise;
    private PerlinOctaveNoise gravelOctaveNoise;
    private final int waterLevel;

    public ChunkProviderClassic030(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.waterLevel = this.levelHeight / 2;
    }

    @Override
    protected void pregenerateTerrain() {
        this.generateHeightmap(this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_NOISE));
        this.erodeTerrain();
        this.soilTerrain();
        this.carveTerrain(this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_CAVE_GENERATION));
        FinitePools poolSettings = this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_POOLS);
        this.floodFluid(poolSettings);
        this.floodLava(poolSettings);
        this.growSurface(this.chunkSettings.getOrDefault(SettingsComponentTypes.FINITE_BEACHES));
    }

    @Override
    protected void generateBorder(class_2791 chunk) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    pos.method_10103(x, y, z);
                    if (y < this.waterLevel - 2) {
                        VersionCompat.setBlockState(chunk, (class_2338)pos, BlockStates.BEDROCK);
                        continue;
                    }
                    if (y >= this.waterLevel) continue;
                    VersionCompat.setBlockState(chunk, (class_2338)pos, this.defaultFluid);
                }
            }
        }
    }

    @Override
    protected class_2680 postProcessTerrainState(class_2248 block, BlockSourceRules blockSources, ChunkProviderFinite.TerrainState terrainState, class_2338 pos, int topY) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2680 blockState = block.method_9564();
        class_2680 modifiedBlockState = blockSources.apply(x, y, z);
        boolean inFluid = modifiedBlockState.method_26215() || modifiedBlockState.method_27852(this.getLevelFluidBlock());
        int runDepth = terrainState.getRunDepth();
        if (!blockState.equals(modifiedBlockState)) {
            terrainState.terrainModified();
        }
        if (terrainState.isTerrainModified() && !inFluid) {
            if (runDepth == 0) {
                class_2680 class_26802 = modifiedBlockState = y >= this.waterLevel - 1 ? BlockStates.GRASS_BLOCK : BlockStates.DIRT;
            }
            if (runDepth == 1) {
                modifiedBlockState = BlockStates.DIRT;
            }
            terrainState.incrementRunDepth();
        }
        return modifiedBlockState;
    }

    @Override
    protected void generateBedrock(class_2791 chunk, class_2248 block, class_2338 pos) {
        int y = pos.method_10264();
        if (y == 0) {
            VersionCompat.setBlockState(chunk, pos, BlockStates.BEDROCK);
        }
    }

    @Override
    protected class_2680 postProcessSurfaceState(class_2680 blockState, SurfaceConfig surfaceConfig, class_2338 pos, boolean isCold) {
        class_2680 topBlock = surfaceConfig.normal().topBlock();
        class_2680 fillerBlock = surfaceConfig.normal().fillerBlock();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (blockState.method_27852(BlockStates.GRASS_BLOCK.method_26204())) {
            blockState = topBlock;
        } else if (blockState.method_27852(BlockStates.DIRT.method_26204())) {
            blockState = fillerBlock;
        }
        if (!this.inWorldBounds(x, z)) {
            if (y == this.waterLevel) {
                if (isCold && blockState.equals(topBlock)) {
                    blockState = (class_2680)topBlock.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(true));
                }
            } else if (y == this.waterLevel - 1 && isCold && blockState.equals(BlockStates.WATER)) {
                blockState = BlockStates.ICE;
            }
        }
        return blockState;
    }

    private void generateHeightmap(FiniteNoise noiseScale) {
        this.setPhase("Raising");
        this.minHeightOctaveNoise = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        this.maxHeightOctaveNoise = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        this.mainHeightOctaveNoise = new PerlinOctaveNoise(this.random, noiseScale.selectorOctaves(), false);
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                double heightResult;
                double heightLow = this.minHeightOctaveNoise.sample((float)x * noiseScale.heightNoiseScale(), (float)z * noiseScale.heightNoiseScale()) / (double)noiseScale.minHeightDamp() + (double)noiseScale.minHeightBoost();
                double heightHigh = this.maxHeightOctaveNoise.sample((float)x * noiseScale.heightNoiseScale(), (float)z * noiseScale.heightNoiseScale()) / (double)noiseScale.maxHeightDamp() + (double)noiseScale.maxHeightBoost();
                double heightSelector = this.mainHeightOctaveNoise.sampleXY((float)x * noiseScale.selectorScale(), (float)z * noiseScale.selectorScale()) / 8.0;
                if (heightSelector > 0.0) {
                    heightHigh = heightLow;
                }
                if ((heightResult = Math.max(heightLow, heightHigh) / 2.0) < 0.0) {
                    heightResult /= (double)noiseScale.heightUnderDamp();
                }
                this.heightmap[x + z * this.levelWidth] = (int)heightResult;
            }
        }
    }

    private void erodeTerrain() {
        this.setPhase("Eroding");
        this.erodeOctaveNoise0 = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        this.erodeOctaveNoise1 = new PerlinOctaveNoiseCombined(new PerlinOctaveNoise(this.random, 8, false), new PerlinOctaveNoise(this.random, 8, false));
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                int erodeNoise;
                double erodeSelector = this.erodeOctaveNoise0.sample(x << 1, z << 1) / 8.0;
                int n = erodeNoise = this.erodeOctaveNoise1.sample(x << 1, z << 1) > 0.0 ? 1 : 0;
                if (!(erodeSelector > 2.0)) continue;
                int heightResult = this.heightmap[x + z * this.levelWidth];
                this.heightmap[x + z * this.levelWidth] = heightResult = ((heightResult - erodeNoise) / 2 << 1) + erodeNoise;
            }
        }
    }

    private void soilTerrain() {
        this.setPhase("Soiling");
        this.dirtOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                int dirtThickness = (int)(this.dirtOctaveNoise.sampleXY(x, z) / 24.0) - 4;
                int dirtThreshold = this.heightmap[x + z * this.levelWidth] + this.waterLevel;
                int stoneThreshold = dirtThickness + dirtThreshold;
                this.heightmap[x + z * this.levelWidth] = Math.max(dirtThreshold, stoneThreshold);
                if (this.heightmap[x + z * this.levelWidth] > this.levelHeight - 2) {
                    this.heightmap[x + z * this.levelWidth] = this.levelHeight - 2;
                }
                if (this.heightmap[x + z * this.levelWidth] < 1) {
                    this.heightmap[x + z * this.levelWidth] = 1;
                }
                for (int y = 0; y < this.levelHeight; ++y) {
                    class_2248 block = class_2246.field_10124;
                    if (y <= dirtThreshold) {
                        block = class_2246.field_10566;
                    }
                    if (y <= stoneThreshold) {
                        block = class_2246.field_10340;
                    }
                    if (y == 1) {
                        block = class_2246.field_10164;
                    }
                    this.setLevelBlock(x, y, z, block);
                }
            }
        }
    }

    private void carveTerrain(FiniteCaveGeneration caveSettings) {
        if (!caveSettings.useCaves()) {
            return;
        }
        this.setPhase("Carving");
        int caveCount = this.levelWidth * this.levelLength * this.levelHeight / caveSettings.rarity();
        for (int i = 0; i < caveCount; ++i) {
            float caveX = this.random.nextFloat() * (float)this.levelWidth;
            float caveY = this.random.nextFloat() * (float)this.levelHeight;
            float caveZ = this.random.nextFloat() * (float)this.levelLength;
            int caveLen = (int)((this.random.nextFloat() + this.random.nextFloat()) * caveSettings.length());
            float theta = this.random.nextFloat() * (float)Math.PI * 2.0f;
            float deltaTheta = 0.0f;
            float phi = this.random.nextFloat() * (float)Math.PI * 2.0f;
            float deltaPhi = 0.0f;
            float caveRadius = this.random.nextFloat() * this.random.nextFloat() * this.caveRadius;
            for (int len = 0; len < caveLen; ++len) {
                caveX += class_3532.method_15374((float)theta) * class_3532.method_15362((float)phi);
                caveZ += class_3532.method_15362((float)theta) * class_3532.method_15362((float)phi);
                caveY += class_3532.method_15374((float)phi);
                theta += deltaTheta * 0.2f;
                deltaTheta = deltaTheta * 0.9f + (this.random.nextFloat() - this.random.nextFloat());
                if (caveSettings.use14aCaves()) {
                    phi = phi * 0.5f + deltaPhi * 0.5f;
                    deltaPhi = deltaPhi * 0.9f + (this.random.nextFloat() - this.random.nextFloat());
                    float radius = class_3532.method_15374((float)((float)len * (float)Math.PI / (float)caveLen)) * 2.5f + 1.0f;
                    this.fillOblateSpheroid(caveX, caveY, caveZ, radius, class_2246.field_10124);
                    continue;
                }
                phi = phi * 0.5f + deltaPhi * 0.25f;
                deltaPhi = deltaPhi * 0.75f + (this.random.nextFloat() - this.random.nextFloat());
                if (!(this.random.nextFloat() >= 0.25f)) continue;
                float centerX = caveX + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerY = caveY + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float centerZ = caveZ + (this.random.nextFloat() * 4.0f - 2.0f) * 0.2f;
                float radius = ((float)this.levelHeight - centerY) / (float)this.levelHeight;
                radius = 1.2f + (radius * 3.5f + 1.0f) * caveRadius;
                this.fillOblateSpheroid(centerX, centerY, centerZ, radius *= class_3532.method_15374((float)((float)len * (float)Math.PI / (float)caveLen)), class_2246.field_10124);
            }
        }
    }

    private void floodFluid(FinitePools poolSettings) {
        this.setPhase("Watering");
        class_2248 fluid = this.defaultFluid.method_26204();
        for (int x = 0; x < this.levelWidth; ++x) {
            this.flood(x, this.waterLevel - 1, 0, fluid);
            this.flood(x, this.waterLevel - 1, this.levelLength - 1, fluid);
        }
        for (int z = 0; z < this.levelLength; ++z) {
            this.flood(this.levelWidth - 1, this.waterLevel - 1, z, fluid);
            this.flood(0, this.waterLevel - 1, z, fluid);
        }
        int waterSourceCount = this.levelWidth * this.levelLength / poolSettings.waterRarity();
        for (int i = 0; i < waterSourceCount; ++i) {
            int randX = this.random.nextInt(this.levelWidth);
            int randZ = this.random.nextInt(this.levelLength);
            int randY = this.waterLevel - 1 - this.random.nextInt(poolSettings.uniformLavaHeights() ? 3 : 2);
            this.flood(randX, randY, randZ, fluid);
        }
    }

    private void floodLava(FinitePools poolSettings) {
        this.setPhase("Melting");
        int lavaSourceCount = this.levelWidth * this.levelLength / poolSettings.lavaRarity();
        for (int i = 0; i < lavaSourceCount; ++i) {
            int randX = this.random.nextInt(this.levelWidth);
            int randZ = this.random.nextInt(this.levelLength);
            int randY = poolSettings.uniformLavaHeights() ? this.random.nextInt(this.waterLevel - 4) : (int)((float)(this.waterLevel - 3) * this.random.nextFloat() * this.random.nextFloat());
            this.flood(randX, randY, randZ, class_2246.field_10164);
        }
    }

    private void growSurface(FiniteBeaches beachSettings) {
        this.setPhase("Growing");
        this.sandOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        this.gravelOctaveNoise = new PerlinOctaveNoise(this.random, 8, false);
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                boolean genSand = this.sandOctaveNoise.sampleXY(x, z) > (double)beachSettings.sandThreshold();
                boolean genGravel = this.gravelOctaveNoise.sampleXY(x, z) > (double)beachSettings.gravelThreshold();
                int heightResult = this.heightmap[x + z * this.levelWidth];
                class_2248 blockUp = this.getLevelBlock(x, heightResult + 1, z);
                genSand &= heightResult <= this.waterLevel - 1 && (beachSettings.sandUnderAir() && blockUp == class_2246.field_10124 || beachSettings.sandUnderFluid() && blockUp == this.defaultFluid.method_26204());
                if ((genGravel &= heightResult <= this.waterLevel - 1 && (beachSettings.gravelUnderAir() && blockUp == class_2246.field_10124 || beachSettings.gravelUnderFluid() && blockUp == this.defaultFluid.method_26204())) && beachSettings.prioritizeGravelBeaches()) {
                    genSand = false;
                }
                class_2248 surfaceBlock = genSand ? class_2246.field_10102 : (genGravel ? class_2246.field_10255 : (blockUp == this.defaultFluid.method_26204() ? class_2246.field_10566 : class_2246.field_10219));
                this.setLevelBlock(x, heightResult, z, surfaceBlock);
            }
        }
    }
}

