/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk.provider;

import java.util.Random;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_5138;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7138;

public class ChunkProviderSky
extends ChunkProviderNoise {
    private final PerlinOctaveNoise minLimitOctaveNoise;
    private final PerlinOctaveNoise maxLimitOctaveNoise;
    private final PerlinOctaveNoise mainOctaveNoise;
    private final PerlinOctaveNoise surfaceOctaveNoise;
    private final PerlinOctaveNoise forestOctaveNoise;

    public ChunkProviderSky(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        this.minLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.maxLimitOctaveNoise = new PerlinOctaveNoise(this.random, 16, true);
        this.mainOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
        new PerlinOctaveNoise(this.random, 4, true);
        this.surfaceOctaveNoise = new PerlinOctaveNoise(this.random, 4, true);
        new PerlinOctaveNoise(this.random, 10, true);
        new PerlinOctaveNoise(this.random, 16, true);
        this.forestOctaveNoise = new PerlinOctaveNoise(this.random, 8, true);
    }

    @Override
    public void provideSurface(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
        double scale = 0.03125;
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        class_2338.class_2339 pos = new class_2338.class_2339();
        double[] surfaceNoise = this.surfaceOctaveNoise.sampleBeta(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, scale * 2.0, scale * 2.0, scale * 2.0);
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = chunk.method_12032(class_2902.class_2903.field_13195).method_12603(localX, localZ) - 1;
                int surfaceDepth = (int)(surfaceNoise[localZ + localX * 16] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                int runDepth = -1;
                class_6880<class_1959> biome = biomeSource.getBiomeForSurfaceGen(region, (class_2338)pos.method_10103(x, surfaceTopY, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                class_2680 topBlock = surfaceConfig.normal().topBlock();
                class_2680 fillerBlock = surfaceConfig.normal().fillerBlock();
                for (int y = this.worldTopY - 1; y >= this.worldMinY; --y) {
                    pos.method_10103(localX, y, localZ);
                    class_2680 blockState = chunk.method_8320((class_2338)pos);
                    if (blockState.method_26215()) {
                        runDepth = -1;
                        continue;
                    }
                    if (!blockState.method_27852(this.defaultBlock.method_26204())) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = BlockStates.AIR;
                            fillerBlock = this.defaultBlock;
                        }
                        runDepth = surfaceDepth;
                        blockState = y >= 0 ? topBlock : fillerBlock;
                        VersionCompat.setBlockState(chunk, (class_2338)pos, blockState);
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    VersionCompat.setBlockState(chunk, (class_2338)pos, fillerBlock);
                    if (--runDepth == 0 && fillerBlock.method_27852(class_2246.field_10102)) {
                        runDepth = rand.nextInt(4);
                        fillerBlock = BlockStates.SANDSTONE;
                    }
                    if (runDepth != 0 || !fillerBlock.method_27852(class_2246.field_10534)) continue;
                    runDepth = rand.nextInt(4);
                    fillerBlock = BlockStates.RED_SANDSTONE;
                }
            }
        }
    }

    @Override
    public void provideSurfaceExtra(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
        double scale = 0.03125;
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        Random rand = this.createSurfaceRandom(chunkX, chunkZ);
        ChunkHeightmap heightmapChunk = this.hasNoisePostProcessor() ? this.getChunkHeightmap((class_5539)region, chunkX, chunkZ) : null;
        class_2338.class_2339 pos = new class_2338.class_2339();
        double[] surfaceNoise = this.surfaceOctaveNoise.sampleBeta(chunkX * 16, chunkZ * 16, 0.0, 16, 16, 1, scale * 2.0, scale * 2.0, scale * 2.0);
        for (int localZ = 0; localZ < 16; ++localZ) {
            for (int localX = 0; localX < 16; ++localX) {
                pos.method_10103(localX, 0, localZ);
                int x = startX + localX;
                int z = startZ + localZ;
                int surfaceTopY = heightmapChunk != null ? heightmapChunk.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR) : chunk.method_12032(class_2902.class_2903.field_13195).method_12603(localX, localZ);
                --surfaceTopY;
                int surfaceDepth = (int)(surfaceNoise[localZ + localX * 16] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
                if (surfaceDepth > 0) continue;
                int y = surfaceTopY;
                pos.method_33098(y);
                if (!this.isBlockSuitableForSurface(chunk.method_8320((class_2338)pos))) continue;
                VersionCompat.setBlockState(chunk, (class_2338)pos, y < this.seaLevel ? this.defaultFluid : BlockStates.AIR);
                pos.method_33098(--y);
                while (this.isBlockSuitableForSurface(chunk.method_8320((class_2338)pos))) {
                    VersionCompat.setBlockState(chunk, (class_2338)pos, this.defaultBlock);
                    pos.method_33098(--y);
                }
            }
        }
    }

    @Override
    protected void sampleNoiseColumn(double[] primaryBuffer, double[] heightmapBuffer, int startNoiseX, int startNoiseZ, int localNoiseX, int localNoiseZ) {
        int noiseX = startNoiseX + localNoiseX;
        int noiseZ = startNoiseZ + localNoiseZ;
        double coordinateScale = this.noiseScale.coordinate();
        double heightScale = this.noiseScale.height();
        double mainNoiseScaleX = this.noiseScale.mainNoiseX();
        double mainNoiseScaleY = this.noiseScale.mainNoiseY();
        double mainNoiseScaleZ = this.noiseScale.mainNoiseZ();
        double lowerLimitScale = this.noiseScale.lowerLimit();
        double upperLimitScale = this.noiseScale.upperLimit();
        boolean wrapped = !this.noiseScale.farlands();
        for (int y = 0; y < primaryBuffer.length; ++y) {
            double density;
            int noiseY = y + this.noiseMinY;
            double densityOffset = this.getOffset();
            double mainNoise = (this.mainOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale / mainNoiseScaleX, heightScale / mainNoiseScaleY, coordinateScale / mainNoiseScaleZ, wrapped) / 10.0 + 1.0) / 2.0;
            if (mainNoise < 0.0) {
                density = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale, wrapped) / lowerLimitScale;
            } else if (mainNoise > 1.0) {
                density = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale, wrapped) / upperLimitScale;
            } else {
                double minLimitNoise = this.minLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale, wrapped) / lowerLimitScale;
                double maxLimitNoise = this.maxLimitOctaveNoise.sample(noiseX, noiseY, noiseZ, coordinateScale, heightScale, coordinateScale, wrapped) / upperLimitScale;
                density = minLimitNoise + (maxLimitNoise - minLimitNoise) * mainNoise;
            }
            double heightmapDensity = density -= densityOffset;
            density = this.sampleNoisePostProcessor(density, noiseX, noiseY, noiseZ);
            density = this.applySlides(density, y);
            heightmapDensity = this.applySlides(heightmapDensity, y);
            primaryBuffer[y] = density;
            heightmapBuffer[y] = heightmapDensity;
        }
    }

    @Override
    protected PerlinOctaveNoise getForestOctaveNoise() {
        return this.forestOctaveNoise;
    }

    private double getOffset() {
        return 8.0;
    }
}

