/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.spawn;

import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import org.slf4j.event.Level;

public class SpawnLocatorRelease
implements SpawnLocator {
    private final Random rand;
    private final ChunkProvider chunkProvider;
    private final class_1966 biomeSource;

    public SpawnLocatorRelease(ChunkProvider chunkProvider, Random rand) {
        this.rand = rand;
        this.chunkProvider = chunkProvider;
        this.biomeSource = chunkProvider.getChunkGenerator().method_12098();
    }

    @Override
    public Optional<class_2338> locateSpawn(class_5539 world) {
        int n;
        ChunkProvider chunkProvider;
        ModernerBeta.log(Level.INFO, "Setting a grass spawn..");
        int x = 0;
        int z = 0;
        int attempts = 0;
        class_2338 suitableBiomeLocation = this.getSuitableBiomeLocation(0, 0, 256);
        if (suitableBiomeLocation != null) {
            x = suitableBiomeLocation.method_10263();
            z = suitableBiomeLocation.method_10260();
        } else {
            ModernerBeta.log(Level.INFO, "Unable to find spawn biome");
        }
        while (!this.isGrassAt(world, x, z)) {
            if (attempts > 10000) {
                ModernerBeta.log(Level.INFO, "Exceeded spawn attempts, spawning anyway at 0,0..");
                x = 0;
                z = 0;
                break;
            }
            x += this.rand.nextInt(64) - this.rand.nextInt(64);
            z += this.rand.nextInt(64) - this.rand.nextInt(64);
            ++attempts;
        }
        if ((chunkProvider = this.chunkProvider) instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(world, x, z, class_2902.class_2903.field_13194);
        }
        int y = n;
        return Optional.of(new class_2338(x, y, z));
    }

    private class_2338 getSuitableBiomeLocation(int x, int z, int radius) {
        int minX = x - radius >> 2;
        int minZ = z - radius >> 2;
        int maxX = x + radius >> 2;
        int maxZ = z + radius >> 2;
        int width = maxX - minX + 1;
        int length = maxZ - minZ + 1;
        class_2338 position = null;
        int choiceChance = 1;
        for (int i = 0; i < width * length; ++i) {
            int biomeX = minX + i % width;
            int biomeZ = minZ + i / width;
            class_6880 biome = this.biomeSource.method_38109(biomeX, 16, biomeZ, null);
            if (!biome.method_40220(ModernBetaBiomeTags.IS_RELEASE_SPAWN) || position != null && this.rand.nextInt(choiceChance) != 0) continue;
            position = new class_2338(biomeX << 2, 0, biomeZ << 2);
            ++choiceChance;
        }
        return position;
    }

    private boolean isGrassAt(class_5539 world, int x, int z) {
        int n;
        int seaLevel = this.chunkProvider.getSeaLevel();
        ChunkProvider chunkProvider = this.chunkProvider;
        if (chunkProvider instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(world, x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(world, x, z, class_2902.class_2903.field_13195);
        }
        int y = n;
        return y >= seaLevel;
    }
}

