/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoiseImitable;
import mod.bluestaggo.modernerbeta.api.world.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.FiniteLevelProperties;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaGenerationStep;
import mod.bluestaggo.modernerbeta.world.spawn.SpawnLocatorIndev;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5817;
import net.minecraft.class_6350;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import org.slf4j.event.Level;

public abstract class ChunkProviderFinite
extends ChunkProvider
implements ChunkProviderNoiseImitable {
    private static String levelPhase;
    protected final int worldMinY;
    protected final int worldHeight;
    protected final int worldTopY;
    protected final int seaLevel;
    protected final int bedrockFloor;
    protected final int bedrockCeiling;
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultFluid;
    protected final FiniteLevelProperties levelProperties;
    protected final int levelWidth;
    protected final int levelLength;
    protected final int levelHeight;
    protected final float caveRadius;
    protected final int[] heightmap;
    @Deprecated
    private final class_2248[][][] blockArr;
    private boolean pregenerated;

    public ChunkProviderFinite(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        class_5284 generatorSettings = (class_5284)chunkGenerator.getGeneratorSettings().comp_349();
        class_5309 shapeConfig = generatorSettings.comp_474();
        this.levelProperties = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FINITE_LEVEL_PROPERTIES);
        this.worldMinY = shapeConfig.comp_173();
        this.worldHeight = shapeConfig.comp_174();
        this.worldTopY = this.worldHeight + this.worldMinY;
        this.seaLevel = generatorSettings.comp_479() + this.getChunkSettings().getOrDefault(SettingsComponentTypes.SEA_LEVEL_OFFSET);
        this.bedrockFloor = 0;
        this.bedrockCeiling = Integer.MIN_VALUE;
        this.defaultBlock = generatorSettings.comp_475();
        this.defaultFluid = generatorSettings.comp_476();
        this.levelWidth = this.levelProperties.width();
        this.levelLength = this.levelProperties.length();
        this.levelHeight = class_3532.method_15340((int)this.levelProperties.height(), (int)0, (int)this.worldTopY);
        this.caveRadius = this.getChunkSettings().getOrDefault(SettingsComponentTypes.FINITE_CAVE_GENERATION).radius();
        this.heightmap = new int[this.levelWidth * this.levelLength];
        this.blockArr = new class_2248[this.levelWidth][this.levelHeight][this.levelLength];
        this.fillBlockArr(class_2246.field_10124);
        this.pregenerated = false;
    }

    @Override
    public SpawnLocator getSpawnLocator() {
        return new SpawnLocatorIndev(this);
    }

    @Override
    public CompletableFuture<class_2791> provideChunk(class_6748 blender, class_5138 structureAccessor, class_2791 chunk, class_7138 noiseConfig) {
        class_1923 pos = chunk.method_12004();
        if (this.inWorldBounds(pos.method_8326(), pos.method_8328())) {
            this.pregenerateTerrainOrWait();
            this.generateTerrain(chunk, structureAccessor);
        } else {
            this.generateBorder(chunk);
        }
        return CompletableFuture.supplyAsync(() -> chunk, class_156.method_18349());
    }

    @Override
    public void provideSurface(class_3233 region, class_5138 structureAccessor, class_2791 chunk, ModernBetaBiomeSource biomeSource, class_7138 noiseConfig) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        int startX = chunk.method_12004().method_8326();
        int startZ = chunk.method_12004().method_8328();
        int worldTopY = this.worldHeight + this.worldMinY;
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                ClimateSampler climateSampler;
                int x = startX + localX;
                int z = startZ + localZ;
                class_6880<class_1959> biome = biomeSource.getBiomeForSurfaceGen(region, (class_2338)pos.method_10103(x, 0, z));
                SurfaceConfig surfaceConfig = this.surfaceBuilder.getSurfaceConfig(biome);
                BiomeProvider biomeProvider = biomeSource.getBiomeProvider();
                boolean isCold = biomeProvider instanceof ClimateSampler && (climateSampler = (ClimateSampler)((Object)biomeProvider)).useBiomeFeature() ? climateSampler.sample(x, z).temp() < 0.5 : ((class_1959)biome.comp_349()).method_33599(pos.method_10087(this.seaLevel - 63));
                for (int y = worldTopY - 1; y >= this.worldMinY; --y) {
                    pos.method_10103(x, y, z);
                    class_2680 blockState = this.postProcessSurfaceState(chunk.method_8320((class_2338)pos), surfaceConfig, (class_2338)pos, isCold);
                    VersionCompat.setBlockState(chunk, (class_2338)pos, blockState);
                    if (!blockState.method_28498((class_2769)class_2741.field_12512) || !((Boolean)blockState.method_11654((class_2769)class_2741.field_12512)).booleanValue()) continue;
                    VersionCompat.setBlockState(chunk, pos.method_10084(), BlockStates.SNOW);
                }
            }
        }
    }

    @Override
    public int getHeight(int x, int z, class_2902.class_2903 type) {
        int seaLevel = this.getSeaLevel();
        if ((x += this.levelWidth / 2) < 0 || x >= this.levelWidth || (z += this.levelLength / 2) < 0 || z >= this.levelLength) {
            return seaLevel;
        }
        this.pregenerateTerrainOrWait();
        int height = this.getLevelHighestBlock(x, z, type);
        return height;
    }

    @Override
    public boolean skipChunk(int chunkX, int chunkZ, ModernBetaGenerationStep step) {
        boolean outOfBounds;
        boolean bl = outOfBounds = !this.inWorldBounds(chunkX << 4, chunkZ << 4);
        if (step == ModernBetaGenerationStep.FEATURES) {
            return outOfBounds;
        }
        if (step == ModernBetaGenerationStep.STRUCTURE_STARTS) {
            return outOfBounds;
        }
        if (step == ModernBetaGenerationStep.CARVERS) {
            return outOfBounds || this.skipCarvers;
        }
        if (step == ModernBetaGenerationStep.SURFACE) {
            return false;
        }
        if (step == ModernBetaGenerationStep.ENTITY_SPAWN) {
            return outOfBounds;
        }
        return false;
    }

    @Override
    public class_6350 getAquiferSampler(class_2791 chunk, class_7138 noiseConfig) {
        class_6350.class_6565 fluidLevelSampler = (x, y, z) -> new class_6350.class_6351(this.getSeaLevel(), this.getLevelFluidBlock().method_9564());
        return class_6350.method_36381((class_6350.class_6565)fluidLevelSampler);
    }

    public int getLevelWidth() {
        return this.levelWidth;
    }

    public int getLevelLength() {
        return this.levelLength;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public float getCaveRadius() {
        return this.caveRadius;
    }

    public class_2248 getLevelBlock(int x, int y, int z) {
        x = class_3532.method_15340((int)x, (int)0, (int)(this.levelWidth - 1));
        y = class_3532.method_15340((int)y, (int)0, (int)(this.levelHeight - 1));
        z = class_3532.method_15340((int)z, (int)0, (int)(this.levelLength - 1));
        return this.blockArr[x][y][z];
    }

    public void setLevelBlock(int x, int y, int z, class_2248 block) {
        x = class_3532.method_15340((int)x, (int)0, (int)(this.levelWidth - 1));
        y = class_3532.method_15340((int)y, (int)0, (int)(this.levelHeight - 1));
        z = class_3532.method_15340((int)z, (int)0, (int)(this.levelLength - 1));
        this.blockArr[x][y][z] = block;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public int getLevelHighestBlock(int x, int z, class_2902.class_2903 type) {
        x = class_3532.method_15340((int)x, (int)0, (int)(this.levelWidth - 1));
        z = class_3532.method_15340((int)z, (int)0, (int)(this.levelLength - 1));
        Predicate<class_2248> checkBlock = switch (type) {
            case class_2902.class_2903.field_13195 -> block -> block == class_2246.field_10124 || block == this.getLevelFluidBlock();
            case class_2902.class_2903.field_13194 -> block -> block == class_2246.field_10124;
            default -> block -> block == class_2246.field_10124;
        };
        int y = this.levelHeight;
        while (checkBlock.test(this.getLevelBlock(x, y - 1, z))) {
            if (y <= 0) return y;
            --y;
        }
        return y;
    }

    public class_2248 getLevelFluidBlock() {
        return this.defaultFluid.method_26204();
    }

    protected abstract void pregenerateTerrain();

    protected abstract void generateBorder(class_2791 var1);

    protected abstract class_2680 postProcessTerrainState(class_2248 var1, BlockSourceRules var2, TerrainState var3, class_2338 var4, int var5);

    protected abstract void generateBedrock(class_2791 var1, class_2248 var2, class_2338 var3);

    protected abstract class_2680 postProcessSurfaceState(class_2680 var1, SurfaceConfig var2, class_2338 var3, boolean var4);

    protected void generateTerrain(class_2791 chunk, class_5138 structureAccessor) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int offsetX = (chunkX + this.levelWidth / 16 / 2) * 16;
        int offsetZ = (chunkZ + this.levelLength / 16 / 2) * 16;
        class_2902 heightmapOcean = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmapSurface = chunk.method_12032(class_2902.class_2903.field_13194);
        class_5817 structureWeightSampler = class_5817.method_42695((class_5138)structureAccessor, (class_1923)chunk.method_12004());
        class_2338.class_2339 pos = new class_2338.class_2339();
        SimpleNoisePos noisePos = new SimpleNoisePos();
        ChunkProviderNoiseImitable.BlockHolder blockHolder = new ChunkProviderNoiseImitable.BlockHolder();
        BlockSource baseBlockSource = this.getBaseBlockSource(structureWeightSampler, noisePos, blockHolder, this.defaultBlock.method_26204(), this.getLevelFluidBlock());
        BlockSourceRules blockSources = new BlockSourceRules.Builder().add(baseBlockSource).add(this.getActualBlockSource(blockHolder)).build(this.defaultBlock);
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int x = localX + (chunkX << 4);
                int z = localZ + (chunkZ << 4);
                int topY = this.getHeight(x, z, class_2902.class_2903.field_13195);
                TerrainState terrainState = new TerrainState();
                for (int y = this.levelHeight - 1; y >= 0; --y) {
                    pos.method_10103(x, y, z);
                    class_2248 block = this.getLevelBlock(offsetX + localX, y, offsetZ + localZ);
                    blockHolder.setBlock(block);
                    class_2680 blockState = this.postProcessTerrainState(block, blockSources, terrainState, (class_2338)pos, topY);
                    VersionCompat.setBlockState(chunk, (class_2338)pos.method_10103(localX, y, localZ), blockState);
                    this.generateBedrock(chunk, block, (class_2338)pos);
                    heightmapOcean.method_12597(localX, y, localZ, block.method_9564());
                    heightmapSurface.method_12597(localX, y, localZ, block.method_9564());
                }
            }
        }
    }

    protected boolean inWorldBounds(int x, int z) {
        int halfWidth = this.levelWidth / 2;
        int halfLength = this.levelLength / 2;
        return x >= -halfWidth && x < halfWidth && z >= -halfLength && z < halfLength;
    }

    protected boolean inLevelBounds(int x, int y, int z) {
        return x >= 0 && x < this.levelWidth && y >= 0 && y < this.levelHeight && z >= 0 && z < this.levelLength;
    }

    protected void setPhase(String phase) {
        levelPhase = phase + "..";
        ModernerBeta.log(Level.INFO, levelPhase);
    }

    protected void fillOblateSpheroid(float centerX, float centerY, float centerZ, float radius, class_2248 fillBlock) {
        for (int x = (int)(centerX - radius); x < (int)(centerX + radius); ++x) {
            for (int y = (int)(centerY - radius); y < (int)(centerY + radius); ++y) {
                for (int z = (int)(centerZ - radius); z < (int)(centerZ + radius); ++z) {
                    class_2248 block;
                    float dx = (float)x - centerX;
                    float dy = (float)y - centerY;
                    float dz = (float)z - centerZ;
                    if (!(dx * dx + dy * dy * 2.0f + dz * dz < radius * radius) || !this.inLevelBounds(x, y, z) || (block = this.getLevelBlock(x, y, z)) != this.defaultBlock.method_26204()) continue;
                    this.setLevelBlock(x, y, z, fillBlock);
                }
            }
        }
    }

    protected void flood(int x, int y, int z, class_2248 fillBlock) {
        ArrayDeque<class_243> positions = new ArrayDeque<class_243>();
        positions.add(new class_243((double)x, (double)y, (double)z));
        while (!positions.isEmpty()) {
            class_243 curPos = (class_243)positions.poll();
            x = (int)curPos.field_1352;
            y = (int)curPos.field_1351;
            z = (int)curPos.field_1350;
            class_2248 block = this.getLevelBlock(x, y, z);
            if (block != class_2246.field_10124) continue;
            this.setLevelBlock(x, y, z, fillBlock);
            if (y - 1 >= 0) {
                this.tryFlood(x, y - 1, z, positions);
            }
            if (x - 1 >= 0) {
                this.tryFlood(x - 1, y, z, positions);
            }
            if (x + 1 < this.levelWidth) {
                this.tryFlood(x + 1, y, z, positions);
            }
            if (z - 1 >= 0) {
                this.tryFlood(x, y, z - 1, positions);
            }
            if (z + 1 >= this.levelLength) continue;
            this.tryFlood(x, y, z + 1, positions);
        }
    }

    private void tryFlood(int x, int y, int z, ArrayDeque<class_243> positions) {
        class_2248 block = this.getLevelBlock(x, y, z);
        if (block == class_2246.field_10124) {
            positions.add(new class_243((double)x, (double)y, (double)z));
        }
    }

    private synchronized void pregenerateTerrainOrWait() {
        if (!this.pregenerated) {
            this.pregenerateTerrain();
            this.pregenerated = true;
        }
    }

    private void fillBlockArr(class_2248 block) {
        for (int x = 0; x < this.levelWidth; ++x) {
            for (int z = 0; z < this.levelLength; ++z) {
                for (int y = 0; y < this.levelHeight; ++y) {
                    this.setLevelBlock(x, y, z, block);
                }
            }
        }
    }

    public static void resetPhase() {
        levelPhase = "";
    }

    public static String getPhase() {
        return levelPhase;
    }

    protected static class TerrainState {
        private int runDepth = 0;
        private boolean terrainModified = false;

        public int getRunDepth() {
            return this.runDepth;
        }

        public void incrementRunDepth() {
            ++this.runDepth;
        }

        public boolean isTerrainModified() {
            return this.terrainModified;
        }

        public void terrainModified() {
            this.terrainModified = true;
        }
    }
}

