/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.world.chunk;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.api.world.blocksource.BlockSource;
import mod.bluestaggo.modernerbeta.api.world.chunk.AquiferSamplerProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.noise.NoisePostProcessor;
import mod.bluestaggo.modernerbeta.api.world.chunk.noise.NoiseProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.noise.NoiseProviderBase;
import mod.bluestaggo.modernerbeta.api.world.chunk.noise.NoiseSampler;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveGeneration;
import mod.bluestaggo.modernerbeta.settings.component.IslesProperties;
import mod.bluestaggo.modernerbeta.settings.component.NoiseScale;
import mod.bluestaggo.modernerbeta.settings.component.NoiseSlide;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkCache;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.SimpleNoisePos;
import mod.bluestaggo.modernerbeta.util.noise.SimplexNoise;
import mod.bluestaggo.modernerbeta.world.blocksource.BlockSourceRules;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkNoiseSampler;
import mod.bluestaggo.modernerbeta.world.chunk.provider.island.IslandShape;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_5539;
import net.minecraft.class_5817;
import net.minecraft.class_6350;
import net.minecraft.class_6574;
import net.minecraft.class_6748;
import net.minecraft.class_6910;
import net.minecraft.class_7138;

public abstract class ChunkProviderNoise
extends ChunkProvider {
    protected final int worldMinY;
    protected final int worldHeight;
    protected final int worldTopY;
    protected final int seaLevel;
    protected final int bedrockFloor;
    protected final int bedrockCeiling;
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultFluid;
    protected final int noiseResolutionVertical;
    protected final int noiseResolutionHorizontal;
    protected final int noiseSizeX;
    protected final int noiseSizeZ;
    protected final int noiseSizeY;
    protected final int noiseMinY;
    protected final int noiseTopY;
    private final ChunkCache<NoiseProviderBase> chunkCacheNoise;
    private final ChunkCache<ChunkHeightmap> chunkCacheHeightmap;
    protected final List<NoisePostProcessor> noisePostProcessors = new ArrayList<NoisePostProcessor>();
    private final SimplexNoise islandNoise;
    private final IslesProperties islesProperties;
    protected final NoiseScale noiseScale;
    private final NoiseSlide noiseSlide;
    private final AtomicReference<class_7138> noiseConfig = new AtomicReference();

    public ChunkProviderNoise(ModernBetaChunkGenerator chunkGenerator, long seed) {
        super(chunkGenerator, seed);
        class_5284 generatorSettings = (class_5284)chunkGenerator.getGeneratorSettings().comp_349();
        class_5309 shapeConfig = generatorSettings.comp_474();
        this.islesProperties = this.getChunkSettings().getOrDefault(SettingsComponentTypes.ISLES_PROPERTIES);
        this.noiseScale = this.getChunkSettings().getOrDefault(SettingsComponentTypes.NOISE_SCALE);
        this.noiseSlide = this.getChunkSettings().getOrElse(SettingsComponentTypes.NOISE_SLIDE, NoiseSlide.DISABLED);
        this.worldMinY = shapeConfig.comp_173();
        this.worldHeight = shapeConfig.comp_174();
        this.worldTopY = this.worldHeight + this.worldMinY;
        this.seaLevel = generatorSettings.comp_479() + this.getChunkSettings().getOrDefault(SettingsComponentTypes.SEA_LEVEL_OFFSET);
        this.bedrockFloor = this.worldMinY;
        this.bedrockCeiling = this.worldTopY;
        this.defaultBlock = generatorSettings.comp_475();
        this.defaultFluid = generatorSettings.comp_476();
        this.noiseResolutionVertical = shapeConfig.comp_179() * 4;
        this.noiseResolutionHorizontal = shapeConfig.comp_178() * 4;
        this.noiseSizeX = 16 / this.noiseResolutionHorizontal;
        this.noiseSizeZ = 16 / this.noiseResolutionHorizontal;
        this.noiseSizeY = class_3532.method_48116((int)this.worldHeight, (int)this.noiseResolutionVertical);
        this.noiseMinY = class_3532.method_48116((int)this.worldMinY, (int)this.noiseResolutionVertical);
        this.noiseTopY = class_3532.method_48116((int)(this.worldMinY + this.worldHeight), (int)this.noiseResolutionVertical);
        this.chunkCacheNoise = new ChunkCache<NoiseProviderBase>("base_noise", (chunkX, chunkZ) -> {
            NoiseProviderBase noiseProviderBase = new NoiseProviderBase(this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ, this::sampleNoiseColumn);
            noiseProviderBase.sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ);
            return noiseProviderBase;
        });
        this.chunkCacheHeightmap = new ChunkCache<ChunkHeightmap>("heightmap", this::sampleHeightmap);
        this.islandNoise = new SimplexNoise(new Random(this.seed));
        CaveGeneration caveSettings = this.getChunkSettings().getOrDefault(SettingsComponentTypes.CAVE_GENERATION);
        if (caveSettings.useNoiseCaves()) {
            this.noisePostProcessors.add(NoisePostProcessor.NOISE_CAVES);
        }
    }

    @Override
    public CompletableFuture<class_2791> provideChunk(class_6748 blender, class_5138 structureAccessor, class_2791 chunk, class_7138 noiseConfig) {
        this.setNoiseConfig(noiseConfig);
        class_5309 shapeConfig = ((class_5284)this.generatorSettings.comp_349()).comp_474();
        int minY = Math.max(shapeConfig.comp_173(), chunk.method_31607());
        int topY = Math.min(shapeConfig.comp_173() + shapeConfig.comp_174(), VersionCompat.getTopYExclusive((class_5539)chunk));
        int noiseMinY = class_3532.method_48116((int)minY, (int)this.noiseResolutionVertical);
        int noiseTopY = class_3532.method_48116((int)(topY - minY), (int)this.noiseResolutionVertical);
        if (noiseTopY <= 0) {
            return CompletableFuture.completedFuture(chunk);
        }
        int sectionTopY = chunk.method_31602(noiseTopY * this.noiseResolutionVertical - 1 + minY);
        int sectionMinY = chunk.method_31602(minY);
        HashSet sections = Sets.newHashSet();
        for (int sectionNdx = sectionTopY; sectionNdx >= sectionMinY; --sectionNdx) {
            class_2826 section = chunk.method_38259(sectionNdx);
            section.method_16676();
            sections.add(section);
        }
        this.generateTerrain(chunk, structureAccessor, noiseConfig);
        return CompletableFuture.supplyAsync(() -> chunk, class_156.method_18349()).whenCompleteAsync((arg, throwable) -> {
            for (class_2826 section : sections) {
                section.method_16677();
            }
        }, (Executor)class_156.method_18349());
    }

    @Override
    public int getHeight(int x, int z, class_2902.class_2903 type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.chunkCacheHeightmap.get(chunkX, chunkZ).getHeight(x, z, type);
    }

    public int getHeight(int x, int z, ChunkHeightmap.Type type) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return this.chunkCacheHeightmap.get(chunkX, chunkZ).getHeight(x, z, type);
    }

    @Override
    public class_6350 getAquiferSampler(class_2791 chunk, class_7138 noiseConfig) {
        class_6574 randomDeriver = this.randomProvider.method_39006(this.seed).method_38421();
        ModernBetaChunkNoiseSampler noiseSampler = ModernBetaChunkNoiseSampler.create(chunk, noiseConfig, (class_5284)this.generatorSettings.comp_349(), this.getFluidLevelSampler(), this);
        AquiferSamplerProvider aquiferSamplerProvider = new AquiferSamplerProvider(((class_5284)this.generatorSettings.comp_349()).comp_477(), randomDeriver, noiseSampler, this.defaultFluid, this.seaLevel, this.worldMinY + 10, this.worldMinY, this.worldHeight, this.noiseResolutionVertical, ((class_5284)this.generatorSettings.comp_349()).comp_481());
        return aquiferSamplerProvider.provideAquiferSampler(chunk);
    }

    public void setNoiseConfig(class_7138 noiseConfig) {
        this.noiseConfig.set(noiseConfig);
    }

    protected abstract void sampleNoiseColumn(double[] var1, double[] var2, int var3, int var4, int var5, int var6);

    protected boolean hasNoisePostProcessor() {
        return !this.noisePostProcessors.isEmpty();
    }

    protected double sampleNoisePostProcessor(double noise, int noiseX, int noiseY, int noiseZ) {
        class_7138 noiseConfig = this.noiseConfig.get();
        if (!this.hasNoisePostProcessor() || noiseConfig == null) {
            return noise;
        }
        for (NoisePostProcessor noisePostProcessor : this.noisePostProcessors) {
            noise = noisePostProcessor.sample(noise, noiseX, noiseY, noiseZ, noiseConfig, (class_5284)this.generatorSettings.comp_349(), this.chunkSettings);
        }
        return noise;
    }

    protected double getIslandOffset(int noiseX, int noiseZ) {
        if (!this.islesProperties.useIslands()) {
            return 0.0;
        }
        Function<Integer, Integer> toNoiseCoord = chunkCoord -> chunkCoord * this.noiseSizeX;
        IslandShape islandShape = this.islesProperties.centerIslandShape();
        double distance = islandShape.getDistance(noiseX, noiseZ);
        double oceanSlideTarget = this.islesProperties.oceanSlideTarget();
        int centerIslandRadius = toNoiseCoord.apply(this.islesProperties.centerIslandRadius());
        int centerIslandFalloffDistance = toNoiseCoord.apply(this.islesProperties.centerIslandFalloffDistance());
        int centerOceanRadius = toNoiseCoord.apply(this.islesProperties.centerOceanRadius());
        int centerOceanFalloffDistance = toNoiseCoord.apply(this.islesProperties.centerOceanFalloffDistance());
        double outerIslandNoiseScale = this.islesProperties.outerIslandNoiseScale();
        double outerIslandNoiseOffset = this.islesProperties.outerIslandNoiseOffset();
        double islandDelta = (distance - (double)centerIslandRadius) / (double)centerIslandFalloffDistance;
        double islandOffset = class_3532.method_15390((double)0.0, (double)oceanSlideTarget, (double)islandDelta);
        if (this.islesProperties.useOuterIslands() && distance > (double)centerOceanRadius) {
            double islandAddition = (double)((float)this.islandNoise.sample((double)noiseX / outerIslandNoiseScale, (double)noiseZ / outerIslandNoiseScale, 1.0, 1.0)) + outerIslandNoiseOffset;
            islandAddition /= (double)0.8f;
            islandAddition = class_3532.method_15350((double)islandAddition, (double)0.0, (double)1.0);
            double oceanDelta = (distance - (double)centerOceanRadius) / (double)centerOceanFalloffDistance;
            islandAddition = class_3532.method_15390((double)0.0, (double)islandAddition, (double)oceanDelta);
            islandOffset += islandAddition * -oceanSlideTarget;
            islandOffset = class_3532.method_15350((double)islandOffset, (double)oceanSlideTarget, (double)0.0);
        }
        return islandOffset;
    }

    protected double applySlides(double density, int noiseY) {
        double delta;
        if (this.noiseSlide.topSize() > 0) {
            delta = ((double)(this.noiseSizeY - noiseY) - (double)this.noiseSlide.topOffset()) / (double)this.noiseSlide.topSize();
            density = class_3532.method_15390((double)this.noiseSlide.topTarget(), (double)density, (double)delta);
        }
        if (this.noiseSlide.bottomSize() > 0) {
            delta = ((double)noiseY - (double)this.noiseSlide.bottomOffset()) / (double)this.noiseSlide.bottomSize();
            density = class_3532.method_15390((double)this.noiseSlide.bottomTarget(), (double)density, (double)delta);
        }
        return density;
    }

    protected void scheduleFluidTick(class_2791 chunk, class_6350 aquiferSampler, class_2338 pos, class_2680 blockState) {
        if (aquiferSampler.method_33742() && !blockState.method_26227().method_15769()) {
            chunk.method_12039(pos);
        }
    }

    protected ChunkHeightmap getChunkHeightmap(int chunkX, int chunkZ) {
        return this.chunkCacheHeightmap.get(chunkX, chunkZ);
    }

    protected boolean isBlockSuitableForSurface(class_2680 blockState) {
        return blockState.method_26225() && !blockState.method_27852(this.defaultBlock.method_26204());
    }

    private void generateTerrain(class_2791 chunk, class_5138 structureAccessor, class_7138 noiseConfig) {
        class_1923 chunkPos = chunk.method_12004();
        int chunkX = chunkPos.field_9181;
        int chunkZ = chunkPos.field_9180;
        int startX = chunkPos.method_8326();
        int startZ = chunkPos.method_8328();
        class_2902 heightmapOcean = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmapSurface = chunk.method_12032(class_2902.class_2903.field_13194);
        class_5817 structureWeightSampler = class_5817.method_42695((class_5138)structureAccessor, (class_1923)chunkPos);
        class_6350 aquiferSampler = this.getAquiferSampler(chunk, noiseConfig);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        NoiseProvider noiseProvider = this.chunkCacheNoise.get(chunkX, chunkZ);
        NoiseSampler noiseSampler = noiseProvider.getSampler();
        BlockSource baseBlockSource = this.getBaseBlockSource(noiseSampler, structureWeightSampler, aquiferSampler);
        BlockSourceRules.Builder builder = new BlockSourceRules.Builder().add(baseBlockSource);
        this.blockSources.forEach(builder::add);
        BlockSourceRules blockSources = builder.build(this.defaultBlock);
        for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
            for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                int sections = chunk.method_32890() - 1;
                class_2826 section = chunk.method_38259(sections);
                for (int subChunkY = 0; subChunkY < this.noiseSizeY; ++subChunkY) {
                    noiseSampler.sampleNoiseCorners(subChunkX, subChunkY, subChunkZ);
                    for (int subY = 0; subY < this.noiseResolutionVertical; ++subY) {
                        int y = subY + (subChunkY + this.noiseMinY) * this.noiseResolutionVertical;
                        int localY = y & 0xF;
                        int sectionNdx = chunk.method_31602(y);
                        if (sections != sectionNdx) {
                            sections = sectionNdx;
                            section = chunk.method_38259(sectionNdx);
                        }
                        double deltaY = (double)subY / (double)this.noiseResolutionVertical;
                        noiseSampler.sampleNoiseY(deltaY);
                        for (int subX = 0; subX < this.noiseResolutionHorizontal; ++subX) {
                            int localX = subX + subChunkX * this.noiseResolutionHorizontal;
                            int x = startX + localX;
                            double deltaX = (double)subX / (double)this.noiseResolutionHorizontal;
                            noiseSampler.sampleNoiseX(deltaX);
                            for (int subZ = 0; subZ < this.noiseResolutionHorizontal; ++subZ) {
                                int localZ = subZ + subChunkZ * this.noiseResolutionHorizontal;
                                int z = startZ + localZ;
                                double deltaZ = (double)subZ / (double)this.noiseResolutionHorizontal;
                                noiseSampler.sampleNoiseZ(deltaZ);
                                class_2680 blockState = blockSources.apply(x, y, z);
                                if (blockState.equals(BlockStates.AIR)) continue;
                                section.method_12256(localX, localY, localZ, blockState, false);
                                heightmapOcean.method_12597(localX, y, localZ, blockState);
                                heightmapSurface.method_12597(localX, y, localZ, blockState);
                                this.scheduleFluidTick(chunk, aquiferSampler, (class_2338)mutable.method_10103(x, y, z), blockState);
                            }
                        }
                    }
                }
            }
        }
    }

    private ChunkHeightmap sampleHeightmap(int chunkX, int chunkZ) {
        short minHeight = 32;
        short worldMinY = (short)this.worldMinY;
        short worldTopY = (short)this.worldTopY;
        NoiseProviderBase noiseProvider = new NoiseProviderBase(this.noiseSizeX, this.noiseSizeY, this.noiseSizeZ, this::sampleNoiseColumn);
        noiseProvider.sampleInitialNoise(chunkX * this.noiseSizeX, chunkZ * this.noiseSizeZ);
        NoiseSampler noiseSampler = noiseProvider.getSamplerForHeightmap();
        short[] heightmapSurface = new short[256];
        short[] heightmapOcean = new short[256];
        short[] heightmapSurfaceFloor = new short[256];
        Arrays.fill(heightmapSurface, minHeight);
        Arrays.fill(heightmapOcean, minHeight);
        Arrays.fill(heightmapSurfaceFloor, worldMinY);
        for (int subChunkX = 0; subChunkX < this.noiseSizeX; ++subChunkX) {
            for (int subChunkZ = 0; subChunkZ < this.noiseSizeZ; ++subChunkZ) {
                for (int subChunkY = 0; subChunkY < this.noiseSizeY; ++subChunkY) {
                    noiseSampler.sampleNoiseCorners(subChunkX, subChunkY, subChunkZ);
                    for (int subY = 0; subY < this.noiseResolutionVertical; ++subY) {
                        int y = subY + subChunkY * this.noiseResolutionVertical;
                        y += this.worldMinY;
                        double deltaY = (double)subY / (double)this.noiseResolutionVertical;
                        noiseSampler.sampleNoiseY(deltaY);
                        for (int subX = 0; subX < this.noiseResolutionHorizontal; ++subX) {
                            int x = subX + subChunkX * this.noiseResolutionHorizontal;
                            double deltaX = (double)subX / (double)this.noiseResolutionHorizontal;
                            noiseSampler.sampleNoiseX(deltaX);
                            for (int subZ = 0; subZ < this.noiseResolutionHorizontal; ++subZ) {
                                int z = subZ + subChunkZ * this.noiseResolutionHorizontal;
                                double deltaZ = (double)subZ / (double)this.noiseResolutionHorizontal;
                                noiseSampler.sampleNoiseZ(deltaZ);
                                double density = noiseSampler.sample();
                                boolean isSolid = density > 0.0;
                                short height = (short)(y + 1);
                                int ndx = z + x * 16;
                                if (y < this.seaLevel || isSolid) {
                                    heightmapOcean[ndx] = height;
                                }
                                if (isSolid) {
                                    heightmapSurface[ndx] = height;
                                }
                                if (isSolid && heightmapSurfaceFloor[ndx] == worldMinY) {
                                    heightmapSurfaceFloor[ndx] = worldTopY;
                                }
                                if (isSolid || heightmapSurfaceFloor[ndx] != worldTopY) continue;
                                heightmapSurfaceFloor[ndx] = (short)(height - 1);
                            }
                        }
                    }
                }
            }
        }
        return new ChunkHeightmap(heightmapSurface, heightmapOcean, heightmapSurfaceFloor);
    }

    private BlockSource getBaseBlockSource(NoiseSampler noiseSampler, class_5817 weightSampler, class_6350 aquiferSampler) {
        SimpleNoisePos noisePos = new SimpleNoisePos();
        return (x, y, z) -> {
            double density = noiseSampler.sample();
            double clampedDensity = class_3532.method_15350((double)(density / 200.0), (double)-1.0, (double)1.0);
            clampedDensity = clampedDensity / 2.0 - clampedDensity * clampedDensity * clampedDensity / 24.0;
            return aquiferSampler.method_38317((class_6910.class_6912)noisePos, clampedDensity += weightSampler.method_40464((class_6910.class_6912)noisePos.set(x, y, z)));
        };
    }
}

