/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.client.color;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BlockColormap {
    private final int[] colormap = new int[65536];

    public void setColormap(int[] map) {
        if (map.length != 65536) {
            throw new IllegalArgumentException("[Modern Beta] Color map is an invalid size!");
        }
        System.arraycopy(map, 0, this.colormap, 0, this.colormap.length);
    }

    public int getColor(double temp, double rain) {
        int rainNdx = (int)((1.0 - rain * temp) * 255.0);
        int tempNdx = (int)((1.0 - temp) * 255.0);
        int ndx = rainNdx << 8 | tempNdx;
        if (ndx >= this.colormap.length) {
            return -65281;
        }
        return this.colormap[ndx];
    }
}

