/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverOcean;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSamplerSky;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import mod.bluestaggo.modernerbeta.settings.component.ClimateScale;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkCache;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkClimate;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkClimateSky;
import mod.bluestaggo.modernerbeta.util.noise.SimplexOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMap;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMapping;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateType;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7871;

public class BiomeProviderBeta
extends BiomeProvider
implements ClimateSampler,
ClimateSamplerSky,
BiomeResolverBlock,
BiomeResolverOcean {
    private final ClimateMap climateMap;
    private final BetaClimateSampler climateSampler;
    private final BetaClimateSamplerSky climateSamplerSky;
    private final ClimateDistribution distribution;

    public BiomeProviderBeta(ModernBetaSettings settings, class_7871<class_1959> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        ClimateScale climateScale = this.settings.getOrDefault(SettingsComponentTypes.CLIMATE_SCALE);
        Map<String, ClimateMapping> climateMappings = this.settings.getOrDefault(SettingsComponentTypes.CLIMATE_MAPPINGS);
        this.climateMap = new ClimateMap(climateMappings);
        this.climateSampler = new BetaClimateSampler(this.seed, climateScale.temp(), climateScale.rain(), climateScale.detail());
        this.climateSamplerSky = new BetaClimateSamplerSky(this.seed, climateScale.temp());
        this.distribution = settings.getOrDefault(SettingsComponentTypes.CLIMATE_DISTRIBUTION);
    }

    @Override
    public class_6880<class_1959> getBiome(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.LAND));
    }

    @Override
    public class_6880<class_1959> getOceanBiome(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.OCEAN));
    }

    @Override
    public class_6880<class_1959> getDeepOceanBiome(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.DEEP_OCEAN));
    }

    @Override
    public class_6880<class_1959> getBiomeBlock(int x, int y, int z) {
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.LAND));
    }

    @Override
    public List<class_6880<class_1959>> getBiomes() {
        return this.climateMap.getBiomeKeys().stream().map(arg_0 -> ((class_7871)this.biomeRegistry).method_46747(arg_0)).collect(Collectors.toList());
    }

    @Override
    public double sampleSky(int x, int z) {
        return this.climateSamplerSky.sample(x, z);
    }

    @Override
    public Clime sample(int x, int z) {
        return this.climateSampler.sample(x, z);
    }

    @Override
    public boolean useBiomeColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BETA_CLIMATIC_COLORS).vegetation();
    }

    @Override
    public boolean useSkyColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BETA_CLIMATIC_COLORS).sky();
    }

    @Override
    public boolean useWaterColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_BETA_CLIMATIC_COLORS).water();
    }

    @Override
    public ClimateDistribution getDistribution() {
        return this.distribution;
    }

    private static class BetaClimateSampler {
        private final SimplexOctaveNoise tempOctaveNoise;
        private final SimplexOctaveNoise rainOctaveNoise;
        private final SimplexOctaveNoise detailOctaveNoise;
        private final ChunkCache<ChunkClimate> chunkCacheClimate;
        private final double tempNoiseScale;
        private final double rainNoiseScale;
        private final double detailNoiseScale;

        public BetaClimateSampler(long seed, double tempNoiseScale, double rainNoiseScale, double detailNoiseScale) {
            this.tempOctaveNoise = new SimplexOctaveNoise(new Random(seed * 9871L), 4);
            this.rainOctaveNoise = new SimplexOctaveNoise(new Random(seed * 39811L), 4);
            this.detailOctaveNoise = new SimplexOctaveNoise(new Random(seed * 543321L), 2);
            this.chunkCacheClimate = new ChunkCache<ChunkClimate>("climate", (chunkX, chunkZ) -> new ChunkClimate((int)chunkX, (int)chunkZ, this::sampleNoise));
            this.tempNoiseScale = tempNoiseScale;
            this.rainNoiseScale = rainNoiseScale;
            this.detailNoiseScale = detailNoiseScale;
        }

        public Clime sample(int x, int z) {
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            return this.chunkCacheClimate.get(chunkX, chunkZ).sampleClime(x, z);
        }

        public Clime sampleNoise(int x, int z) {
            double temp = this.tempOctaveNoise.sample(x, z, this.tempNoiseScale, 0.25);
            double rain = this.rainOctaveNoise.sample(x, z, this.rainNoiseScale, 0.3333333333333333);
            double detail = this.detailOctaveNoise.sample(x, z, this.detailNoiseScale, 0.5882352941176471);
            detail = detail * 1.1 + 0.5;
            temp = (temp * 0.15 + 0.7) * 0.99 + detail * 0.01;
            rain = (rain * 0.15 + 0.5) * 0.998 + detail * 0.002;
            temp = 1.0 - (1.0 - temp) * (1.0 - temp);
            return new Clime(class_3532.method_15350((double)temp, (double)0.0, (double)1.0), class_3532.method_15350((double)rain, (double)0.0, (double)1.0));
        }
    }

    private static class BetaClimateSamplerSky {
        private final SimplexOctaveNoise tempOctaveNoise;
        private final ChunkCache<ChunkClimateSky> chunkCacheClimateSky;
        private final double tempNoiseScale;

        public BetaClimateSamplerSky(long seed, double tempNoiseScale) {
            this.tempOctaveNoise = new SimplexOctaveNoise(new Random(seed * 9871L), 4);
            this.chunkCacheClimateSky = new ChunkCache<ChunkClimateSky>("sky", (chunkX, chunkZ) -> new ChunkClimateSky((int)chunkX, (int)chunkZ, this::sampleNoise));
            this.tempNoiseScale = tempNoiseScale;
        }

        public double sample(int x, int z) {
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            return this.chunkCacheClimateSky.get(chunkX, chunkZ).sampleTemp(x, z);
        }

        private double sampleNoise(int x, int z) {
            return this.tempOctaveNoise.sample(x, z, this.tempNoiseScale, this.tempNoiseScale, 0.5);
        }
    }
}

