/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeProvider;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverBlock;
import mod.bluestaggo.modernerbeta.api.world.biome.BiomeResolverOcean;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSampler;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.ClimateSamplerSky;
import mod.bluestaggo.modernerbeta.api.world.biome.climate.Clime;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.ClimateDistribution;
import mod.bluestaggo.modernerbeta.settings.component.ClimateScale;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkCache;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkClimate;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.util.random.mersenne.MTRandom;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMap;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateMapping;
import mod.bluestaggo.modernerbeta.world.biome.provider.climate.ClimateType;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7871;

public class BiomeProviderPE
extends BiomeProvider
implements ClimateSampler,
ClimateSamplerSky,
BiomeResolverBlock,
BiomeResolverOcean {
    private final ClimateMap climateMap;
    private final PEClimateSampler climateSampler;
    private final ClimateDistribution distribution;

    public BiomeProviderPE(ModernBetaSettings settings, class_7871<class_1959> biomeRegistry, long seed) {
        super(settings, biomeRegistry, seed);
        ClimateScale climateScale = this.settings.getOrDefault(SettingsComponentTypes.CLIMATE_SCALE);
        Map<String, ClimateMapping> climateMappings = this.settings.getOrDefault(SettingsComponentTypes.CLIMATE_MAPPINGS);
        this.climateMap = new ClimateMap(climateMappings);
        this.climateSampler = new PEClimateSampler(this.seed, climateScale.temp(), climateScale.rain(), climateScale.detail());
        this.distribution = settings.getOrDefault(SettingsComponentTypes.CLIMATE_DISTRIBUTION);
    }

    @Override
    public class_6880<class_1959> getBiome(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.LAND));
    }

    @Override
    public class_6880<class_1959> getOceanBiome(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.OCEAN));
    }

    @Override
    public class_6880<class_1959> getDeepOceanBiome(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX << 2;
        int z = biomeZ << 2;
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.DEEP_OCEAN));
    }

    @Override
    public class_6880<class_1959> getBiomeBlock(int x, int y, int z) {
        Clime clime = this.climateSampler.sample(x, z);
        double temp = clime.temp();
        double rain = clime.rain();
        return this.biomeRegistry.method_46747(this.climateMap.getBiome(temp, rain, ClimateType.LAND));
    }

    @Override
    public List<class_6880<class_1959>> getBiomes() {
        return this.climateMap.getBiomeKeys().stream().map(i -> this.biomeRegistry.method_46747(i)).collect(Collectors.toList());
    }

    @Override
    public double sampleSky(int x, int z) {
        return this.climateSampler.sampleSky(x, z);
    }

    @Override
    public Clime sample(int x, int z) {
        return this.climateSampler.sample(x, z);
    }

    @Override
    public boolean useBiomeColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_PE_CLIMATIC_COLORS).vegetation();
    }

    @Override
    public boolean useSkyColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_PE_CLIMATIC_COLORS).sky();
    }

    @Override
    public boolean useWaterColor() {
        return ModernerBeta.config.getOrDefault(SettingsComponentTypes.CONFIG_PE_CLIMATIC_COLORS).water();
    }

    @Override
    public ClimateDistribution getDistribution() {
        return this.distribution;
    }

    private static class PEClimateSampler {
        private final PerlinOctaveNoise tempOctaveNoise;
        private final PerlinOctaveNoise rainOctaveNoise;
        private final PerlinOctaveNoise detailOctaveNoise;
        private final ChunkCache<ChunkClimate> chunkCacheClimate;
        private final double tempNoiseScale;
        private final double rainNoiseScale;
        private final double detailNoiseScale;

        public PEClimateSampler(long seed, double tempNoiseScale, double rainNoiseScale, double detailNoiseScale) {
            this.tempOctaveNoise = new PerlinOctaveNoise(new MTRandom(seed * 9871L), 4, true);
            this.rainOctaveNoise = new PerlinOctaveNoise(new MTRandom(seed * 39811L), 4, true);
            this.detailOctaveNoise = new PerlinOctaveNoise(new MTRandom(seed * 543321L), 2, true);
            this.chunkCacheClimate = new ChunkCache<ChunkClimate>("climate", (chunkX, chunkZ) -> new ChunkClimate((int)chunkX, (int)chunkZ, this::sampleNoise));
            this.tempNoiseScale = tempNoiseScale;
            this.rainNoiseScale = rainNoiseScale;
            this.detailNoiseScale = detailNoiseScale;
        }

        public Clime sample(int x, int z) {
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            return this.chunkCacheClimate.get(chunkX, chunkZ).sampleClime(x, z);
        }

        public double sampleSky(int x, int z) {
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            return this.chunkCacheClimate.get(chunkX, chunkZ).sampleClime(x, z).temp();
        }

        private Clime sampleNoise(int x, int z) {
            double temp = this.tempOctaveNoise.sampleXZ(x, z, this.tempNoiseScale, this.tempNoiseScale);
            double rain = this.rainOctaveNoise.sampleXZ(x, z, this.rainNoiseScale, this.rainNoiseScale);
            double detail = this.detailOctaveNoise.sampleXZ(x, z, this.detailNoiseScale, this.detailNoiseScale);
            detail = detail * 1.1 + 0.5;
            temp = (temp * 0.15 + 0.7) * 0.99 + detail * 0.01;
            rain = (rain * 0.15 + 0.5) * 0.998 + detail * 0.002;
            temp = 1.0 - (1.0 - temp) * (1.0 - temp);
            return new Clime(class_3532.method_15350((double)temp, (double)0.0, (double)1.0), class_3532.method_15350((double)rain, (double)0.0, (double)1.0));
        }
    }
}

