/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInTypes;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ConstantBiomeLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import net.minecraft.class_2960;

public class ConfiguredLayers {
    public static final Codec<ConfiguredLayers> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Layer.TYPE_CODEC.listOf().fieldOf("pipeline").forGetter(configuredLayers -> configuredLayers.pipeline), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.STRING).fieldOf("outputs").forGetter(configuredLayers -> configuredLayers.outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Layer)entry.getValue()).id)))).apply((Applicative)instance, ConfiguredLayers::new));
    public static final ConfiguredLayers DEFAULT = new ConfiguredLayers(List.of(new ConstantBiomeLayer("land", 0L, ExtendedBiomeId.PLAINS)), Map.of(ModernBetaBuiltInTypes.LayerOutput.BIOME.id, "land"));
    private final List<Layer> pipeline;
    private final Map<class_2960, Layer> outputs;

    public ConfiguredLayers(List<Layer> pipeline, Map<class_2960, String> outputs) {
        this.pipeline = Collections.unmodifiableList(pipeline);
        HashMap<String, Layer> layerMap = new HashMap<String, Layer>();
        AtomicInteger index = new AtomicInteger();
        Function<String, Layer> layerMapAccessor = id -> {
            Layer layer = (Layer)layerMap.get(id);
            if (layer != null) {
                return layer;
            }
            throw new IllegalArgumentException("Layer of id \"" + id + "\" not present at layer at index \"" + index.get() + "\"");
        };
        for (Layer layer : pipeline) {
            layer.configure(layerMapAccessor);
            layerMap.put(layer.id, layer);
            index.getAndIncrement();
        }
        this.outputs = outputs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Layer)layerMap.get(entry.getValue())));
    }

    public List<Layer> getPipeline() {
        return this.pipeline;
    }

    public Optional<Layer> getOutput(class_2960 output) {
        return Optional.ofNullable(this.outputs.get(output));
    }

    public Layer getOutputOrThrow(class_2960 output) {
        Layer layer = this.outputs.get(output);
        if (layer == null) {
            throw new IllegalArgumentException("No layer provided for required output \"" + String.valueOf(output) + "\"");
        }
        return layer;
    }

    public String toString() {
        return "ConfiguredLayers {" + this.pipeline.toString() + "}";
    }
}

