/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SingleParentLayer;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_5321;

public class ComputeRiverLayer
extends SingleParentLayer {
    public static final MapCodec<ComputeRiverLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> ComputeRiverLayer.fillSingleParentLayerFields(instance).and((App)Codec.BOOL.fieldOf("convertOceans").orElse((Object)false).forGetter(layer -> layer.convertOceans)).apply((Applicative)instance, ComputeRiverLayer::new));
    private final boolean convertOceans;

    public ComputeRiverLayer(String id, long seed, String parent, boolean convertOceans) {
        super(id, seed, parent);
        this.convertOceans = convertOceans;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.COMPUTE_RIVER;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        ExtendedBiomeId base = this.parentLayer.sample(x, z);
        ExtendedBiomeId[] neighbors = this.parentLayer.sampleNeighbors(x, z);
        return (!this.convertOceans ? ComputeRiverLayer.neighborsRiverBorder(neighbors, base) : base.isOf((class_5321<class_1959>)class_1972.field_9423) || ComputeRiverLayer.neighborsContain(neighbors, ExtendedBiomeId.OCEAN) || !ComputeRiverLayer.allNeighborsEqual(neighbors, base)) ? ExtendedBiomeId.RIVER : ExtendedBiomeId.NULL;
    }

    private static boolean neighborsRiverBorder(ExtendedBiomeId[] neighbors, ExtendedBiomeId match) {
        byte matchType = ComputeRiverLayer.getRiverType(match);
        for (ExtendedBiomeId neighbor : neighbors) {
            if (ComputeRiverLayer.getRiverType(neighbor) == matchType) continue;
            return true;
        }
        return false;
    }

    private static byte getRiverType(ExtendedBiomeId biome) {
        return (byte)(ExtendedBiomeId.RIVER_REGION_A.equals(biome) ? 1 : (ExtendedBiomeId.RIVER_REGION_B.equals(biome) ? 2 : (biome.isOf(ExtendedBiomeId.RANDOM.baseId()) ? (int)(1 + (biome.ext().charAt(biome.ext().length() - 1) & '\u0001')) : 0)));
    }
}

