/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongFunction;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.FuzzyZoomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.ModalZoomLayer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.SingleParentLayer;
import net.minecraft.class_3542;

public class StackedZoomLayer
extends SingleParentLayer {
    public static final MapCodec<StackedZoomLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> StackedZoomLayer.fillSingleParentLayerFields(instance).and(instance.group((App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(layer -> layer.level), (App)Codec.INT.fieldOf("seedModifier").orElse((Object)1).forGetter(layer -> layer.seedModifier), (App)class_3542.method_28140(Type::values).fieldOf("zoomType").orElse((Object)Type.MODAL).forGetter(layer -> layer.zoomType))).apply((Applicative)instance, StackedZoomLayer::new));
    private final int level;
    private final int seedModifier;
    private final Type zoomType;
    private transient Layer stackedLayer;

    public StackedZoomLayer(String id, long seed, String parent, int level, int seedModifier, Type zoomType) {
        super(id, seed, parent);
        this.level = level;
        this.seedModifier = seedModifier;
        this.zoomType = zoomType;
    }

    @Override
    public void configure(Function<String, Layer> layerMap) {
        super.configure(layerMap);
        Layer layer = this.parentLayer;
        for (int i = 0; i < this.level; ++i) {
            Layer zoomParent = layer;
            Layer zoomLayer = this.zoomType.constructor.apply(this.seed + (long)(i * this.seedModifier));
            zoomLayer.configure(key -> zoomParent);
            layer = zoomLayer;
        }
        this.stackedLayer = layer;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.STACKED_ZOOM;
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        return null;
    }

    @Override
    public ExtendedBiomeId sample(int x, int z) {
        return this.stackedLayer.sample(x, z);
    }

    @Override
    protected List<Layer> getParents() {
        return List.of(this.parentLayer, this.stackedLayer);
    }

    @Override
    protected String getName() {
        return super.getName() + "(" + this.zoomType.id + ")";
    }

    public static StackedZoomLayer modal(String id, long seed, String parent, int level) {
        return StackedZoomLayer.modal(id, seed, parent, level, 1);
    }

    public static StackedZoomLayer modal(String id, long seed, String parent, int level, int seedModifier) {
        return new StackedZoomLayer(id, seed, parent, level, seedModifier, Type.MODAL);
    }

    public static StackedZoomLayer fuzzy(String id, long seed, String parent, int level) {
        return StackedZoomLayer.fuzzy(id, seed, parent, level, 1);
    }

    public static StackedZoomLayer fuzzy(String id, long seed, String parent, int level, int seedModifier) {
        return new StackedZoomLayer(id, seed, parent, level, seedModifier, Type.FUZZY);
    }

    public static enum Type implements class_3542
    {
        MODAL("modal", seed -> new ModalZoomLayer("", seed, "")),
        FUZZY("fuzzy", seed -> new FuzzyZoomLayer("", seed, ""));

        public final String id;
        public final LongFunction<Layer> constructor;

        private Type(String id, LongFunction<Layer> constructor) {
            this.id = id;
            this.constructor = constructor;
        }

        public String method_15434() {
            return this.id;
        }
    }
}

