/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.ExtendedBiomeId;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.LayerTarget;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.Layer;
import mod.bluestaggo.modernerbeta.world.biome.provider.fractal.layers.LayerType;
import net.minecraft.class_6005;
import net.minecraft.class_6008;

public class WeightedPoolLayer
extends Layer {
    public static final MapCodec<WeightedPoolLayer> CODEC = VersionCompat.createMaybeMapCodec(instance -> WeightedPoolLayer.fillLayerFields(instance).and((App)class_6005.method_34972(LayerTarget.CODEC).fieldOf("targets").forGetter(layer -> layer.targets)).apply((Applicative)instance, WeightedPoolLayer::new));
    private final class_6005<LayerTarget> targets;
    private transient class_6005<LayerTarget.Configured> configuredTargets;

    public WeightedPoolLayer(String id, long seed, class_6005<LayerTarget> targets) {
        super(id, seed);
        this.targets = targets;
    }

    @Override
    public LayerType<?> getType() {
        return LayerType.WEIGHTED_POOL;
    }

    @Override
    public void configure(Function<String, Layer> layerMap) {
        class_6005.class_6006 poolBuilder = class_6005.method_34971();
        for (class_6008.class_6010 entry : this.targets.method_34994()) {
            poolBuilder.method_34975((Object)((LayerTarget)VersionCompat.getWeightedValue(entry)).configure(layerMap), entry.method_34979().method_34976());
        }
        this.configuredTargets = poolBuilder.method_34974();
    }

    @Override
    protected ExtendedBiomeId generate(int x, int z) {
        return VersionCompat.accessPool(this.configuredTargets, this.getRandom(x, z)).sample(x, z);
    }

    @Override
    protected List<Layer> getParents() {
        return this.configuredTargets.method_34994().stream().map(VersionCompat::getWeightedValue).map(LayerTarget.Configured::asLayer).flatMap(Optional::stream).toList();
    }

    @Override
    protected void addPossibleBiomes(Set<ExtendedBiomeId> biomes) {
        this.configuredTargets.method_34994().stream().map(VersionCompat::getWeightedValue).forEach(target -> target.addPossibleBiomes(biomes));
    }
}

