/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.provider.ChunkProviderType;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistryKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.settings.component.CaveGeneration;
import mod.bluestaggo.modernerbeta.util.BlockStates;
import mod.bluestaggo.modernerbeta.util.VersionCompat;
import mod.bluestaggo.modernerbeta.util.random.BedrockCheckedRandom;
import mod.bluestaggo.modernerbeta.util.random.BedrockChunkRandom;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.world.biome.injector.BiomeInjector;
import mod.bluestaggo.modernerbeta.world.carver.BetaCaveCarverConfig;
import mod.bluestaggo.modernerbeta.world.carver.configured.ModernBetaConfiguredCarvers;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaChunkNoiseSampler;
import mod.bluestaggo.modernerbeta.world.chunk.ModernBetaGenerationStep;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2839;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2922;
import net.minecraft.class_3233;
import net.minecraft.class_3754;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5463;
import net.minecraft.class_5485;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5871;
import net.minecraft.class_5873;
import net.minecraft.class_6350;
import net.minecraft.class_6544;
import net.minecraft.class_6568;
import net.minecraft.class_6575;
import net.minecraft.class_6643;
import net.minecraft.class_6673;
import net.minecraft.class_6748;
import net.minecraft.class_6780;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class ModernBetaChunkGenerator
extends class_3754 {
    public static final MapCodec<ModernBetaChunkGenerator> CODEC = VersionCompat.createMaybeMapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(generator -> generator.field_12761), (App)class_6903.method_46636(ModernBetaRegistryKeys.SETTINGS_PRESET), (App)class_5284.field_24781.fieldOf("settings").forGetter(generator -> generator.settings), (App)class_2487.field_25128.fieldOf("provider_settings").forGetter(generator -> generator.chunkSettings)).apply((Applicative)instance, instance.stable(ModernBetaChunkGenerator::new)));
    private final class_7871<ModernBetaSettingsPreset> presetRegistry;
    private final class_6880<class_5284> settings;
    private final class_2487 chunkSettings;
    private final Supplier<BiomeInjector> biomeInjector;
    private boolean useSurfaceRules;
    private CaveGeneration caveSettings = CaveGeneration.DEFAULT;
    private ChunkProvider chunkProvider;

    public ModernBetaChunkGenerator(class_1966 biomeSource, class_7871<ModernBetaSettingsPreset> presetRegistry, class_6880<class_5284> settings, class_2487 chunkProviderSettings) {
        super(biomeSource, settings);
        this.settings = settings;
        this.presetRegistry = presetRegistry;
        this.chunkSettings = chunkProviderSettings;
        this.biomeInjector = Suppliers.memoize(() -> {
            BiomeInjector biomeInjector;
            class_1966 patt0$temp = this.field_12761;
            if (patt0$temp instanceof ModernBetaBiomeSource) {
                ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)patt0$temp;
                biomeInjector = new BiomeInjector(this, modernBetaBiomeSource);
            } else {
                biomeInjector = null;
            }
            return biomeInjector;
        });
        class_1966 class_19662 = this.field_12761;
        if (class_19662 instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)class_19662;
            modernBetaBiomeSource.setChunkGenerator(this);
        }
    }

    public void initProvider(long seed) {
        ModernBetaSettings chunkSettings = ModernBetaSettings.fromCompound(this.chunkSettings).mapPreset(this.presetRegistry, ModernBetaSettingsPreset::chunkSettings);
        this.chunkProvider = ((ChunkProviderType)ModernBetaRegistries.CHUNK.method_10223(chunkSettings.getProvider())).apply(this, seed);
        this.chunkProvider.initForestOctaveNoise();
        this.useSurfaceRules = chunkSettings.getOrDefault(SettingsComponentTypes.USE_SURFACE_RULES);
        this.caveSettings = chunkSettings.getOrDefault(SettingsComponentTypes.CAVE_GENERATION);
    }

    public CompletableFuture<class_2791> method_38275(class_7138 noiseConfig, class_6748 blender, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.supplyAsync(class_156.method_41238(() -> {
            class_6568 noiseSampler = chunk.method_38255(c -> this.method_41537((class_2791)c, structureAccessor, blender, noiseConfig));
            chunk.method_38257((class_6780)this.field_12761, noiseSampler.method_40531(noiseConfig.method_42370(), ((class_5284)this.settings.comp_349()).comp_538()));
            return chunk;
        }, () -> "init_biomes"), class_156.method_18349());
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return this.chunkProvider.provideChunk(class_6748.method_39336(), structureAccessor, chunk, noiseConfig);
    }

    public void method_12110(class_3233 chunkRegion, class_5138 structureAccessor, class_7138 noiseConfig, class_2791 chunk) {
        this.injectBiomes(chunk, noiseConfig.method_42371(), BiomeInjector.BiomeInjectionStep.PRE);
        if (!this.chunkProvider.skipChunk(chunk.method_12004().field_9181, chunk.method_12004().field_9180, ModernBetaGenerationStep.SURFACE)) {
            class_1966 class_19662 = this.field_12761;
            if (class_19662 instanceof ModernBetaBiomeSource) {
                ModernBetaBiomeSource modernBetaBiomeSource = (ModernBetaBiomeSource)class_19662;
                if (this.useSurfaceRules) {
                    this.buildDefaultSurface(chunkRegion, structureAccessor, noiseConfig, chunk);
                    this.chunkProvider.provideSurfaceExtra(chunkRegion, structureAccessor, chunk, modernBetaBiomeSource, noiseConfig);
                } else {
                    this.chunkProvider.provideSurface(chunkRegion, structureAccessor, chunk, modernBetaBiomeSource, noiseConfig);
                }
            } else {
                super.method_12110(chunkRegion, structureAccessor, noiseConfig, chunk);
            }
        }
        this.injectBiomes(chunk, noiseConfig.method_42371(), BiomeInjector.BiomeInjectionStep.POST);
    }

    public void buildDefaultSurface(class_3233 chunkRegion, class_5138 structureAccessor, class_7138 noiseConfig, class_2791 chunk) {
        super.method_12110(chunkRegion, structureAccessor, noiseConfig, chunk);
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
        if (this.chunkProvider.skipChunk(chunk.method_12004().field_9181, chunk.method_12004().field_9180, ModernBetaGenerationStep.CARVERS)) {
            return;
        }
        class_4543 biomeAccessWithSource = biomeAccess.method_38107((biomeX, biomeY, biomeZ) -> this.field_12761.method_38109(biomeX, biomeY, biomeZ, noiseConfig.method_42371()));
        class_1923 chunkPos = chunk.method_12004();
        int mainChunkX = chunkPos.field_9181;
        int mainChunkZ = chunkPos.field_9180;
        class_6350 aquiferSampler = this.chunkProvider.getAquiferSampler(chunk, noiseConfig);
        class_6568 chunkNoiseSampler = chunk.method_38255(c -> this.method_41537((class_2791)c, structureAccessor, class_6748.method_39342((class_3233)chunkRegion), noiseConfig));
        class_2378 configuredCarverRegistry = chunkRegion.method_30349().method_30530(class_7924.field_41238);
        class_5873 carverContext = new class_5873((class_3754)this, chunkRegion.method_30349(), chunk.method_39460(), chunkNoiseSampler, noiseConfig, ((class_5284)this.settings.comp_349()).comp_478());
        class_6643 carvingMask = ((class_2839)chunk).method_28510(carverStep);
        CaveGeneration.SeedMethod seedMethod = this.caveSettings.seedMethod();
        class_2919 random = switch (seedMethod) {
            case CaveGeneration.SeedMethod.MODERN -> new class_2919((class_5819)new class_5820(class_6673.method_39001()));
            case CaveGeneration.SeedMethod.BEDROCK -> new BedrockChunkRandom((class_5819)new BedrockCheckedRandom((int)class_6673.method_39001()));
            default -> new class_6575(seed);
        };
        long saltX = switch (seedMethod) {
            default -> throw new MatchException(null, null);
            case CaveGeneration.SeedMethod.BETA -> random.method_43055() / 2L * 2L + 1L;
            case CaveGeneration.SeedMethod.EARLY_RELEASE -> random.method_43055();
            case CaveGeneration.SeedMethod.MODERN, CaveGeneration.SeedMethod.BEDROCK -> 0L;
        };
        long saltZ = switch (seedMethod) {
            default -> throw new MatchException(null, null);
            case CaveGeneration.SeedMethod.BETA -> random.method_43055() / 2L * 2L + 1L;
            case CaveGeneration.SeedMethod.EARLY_RELEASE -> random.method_43055();
            case CaveGeneration.SeedMethod.MODERN, CaveGeneration.SeedMethod.BEDROCK -> 0L;
        };
        for (int chunkX = mainChunkX - 8; chunkX <= mainChunkX + 8; ++chunkX) {
            for (int chunkZ = mainChunkZ - 8; chunkZ <= mainChunkZ + 8; ++chunkZ) {
                class_1923 carverPos = new class_1923(chunkX, chunkZ);
                class_2791 carverChunk = chunkRegion.method_8392(carverPos.field_9181, carverPos.field_9180);
                class_5485 genSettings = carverChunk.method_44214(() -> this.method_44216(this.field_12761.method_38109(class_5742.method_33100((int)carverPos.method_8326()), 0, class_5742.method_33100((int)carverPos.method_8328()), noiseConfig.method_42371())));
                Iterable carverList = genSettings.method_30976(carverStep);
                int salt = 0;
                for (class_6880 carverEntry : carverList) {
                    class_5321 carverKey;
                    class_2922 configuredCarver = (class_2922)carverEntry.comp_349();
                    if (random instanceof class_2919) {
                        class_2919 chunkRandom = random;
                        chunkRandom.method_12663(seed + (long)salt, chunkX, chunkZ);
                    } else {
                        random.method_43052((long)chunkX * saltX + (long)chunkZ * saltZ ^ seed);
                    }
                    if ((this.caveSettings.forceBetaCaves() || this.caveSettings.forceBetaCanyons()) && (carverKey = (class_5321)carverEntry.method_40230().orElse(null)) != null) {
                        class_2922 replacementCarver = null;
                        if (this.caveSettings.forceBetaCaves()) {
                            if (carverKey.equals(class_5463.field_33119)) {
                                replacementCarver = (class_2922)configuredCarverRegistry.method_29107(ModernBetaConfiguredCarvers.BETA_CAVE);
                            } else if (carverKey.equals(class_5463.field_34968)) {
                                replacementCarver = (class_2922)configuredCarverRegistry.method_29107(ModernBetaConfiguredCarvers.BETA_CAVE_DEEP);
                            }
                        }
                        if (this.caveSettings.forceBetaCanyons() && carverKey.equals(class_5463.field_33120)) {
                            replacementCarver = (class_2922)configuredCarverRegistry.method_29107(ModernBetaConfiguredCarvers.BETA_CANYON);
                        }
                        if (replacementCarver != null) {
                            configuredCarver = replacementCarver;
                        }
                    }
                    if (configuredCarver.method_12669((class_5819)random)) {
                        class_5871 class_58712 = configuredCarver.comp_331();
                        if (class_58712 instanceof BetaCaveCarverConfig) {
                            BetaCaveCarverConfig betaCaveCarverConfig = (BetaCaveCarverConfig)class_58712;
                            betaCaveCarverConfig.useFixedCaves = Optional.of(this.caveSettings.fixCaveBorders());
                        }
                        configuredCarver.method_12668(carverContext, chunk, arg_0 -> ((class_4543)biomeAccessWithSource).method_22393(arg_0), (class_5819)random, aquiferSampler, carverPos, carvingMask);
                    }
                    if (seedMethod == CaveGeneration.SeedMethod.BEDROCK) continue;
                    ++salt;
                }
            }
        }
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        class_1923 pos = chunk.method_12004();
        if (this.chunkProvider.skipChunk(pos.field_9181, pos.field_9180, ModernBetaGenerationStep.FEATURES)) {
            return;
        }
        super.method_12102(world, chunk, structureAccessor);
    }

    public void method_12107(class_3233 region) {
        class_1923 pos = region.method_33561();
        if (this.chunkProvider.skipChunk(pos.field_9181, pos.field_9180, ModernBetaGenerationStep.ENTITY_SPAWN)) {
            return;
        }
        super.method_12107(region);
    }

    public int method_16397(int x, int z, class_2902.class_2903 type, class_5539 world, class_7138 noiseConfig) {
        return this.chunkProvider.getHeight(x, z, type);
    }

    public int getHeight(int x, int z, class_2902.class_2903 type) {
        return this.chunkProvider.getHeight(x, z, type);
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        int height = this.chunkProvider.getHeight(x, z, class_2902.class_2903.field_13195);
        int worldHeight = this.chunkProvider.getWorldHeight();
        int minY = this.chunkProvider.getWorldMinY();
        class_2680[] column = new class_2680[worldHeight];
        for (int y = worldHeight - 1; y >= 0; --y) {
            int worldY = y + minY;
            if (worldY > height) {
                if (worldY > this.method_16398()) {
                    column[y] = BlockStates.AIR;
                    continue;
                }
                column[y] = ((class_5284)this.settings.comp_349()).comp_476();
                continue;
            }
            column[y] = ((class_5284)this.settings.comp_349()).comp_475();
        }
        return new class_4966(minY, column);
    }

    public int method_12104() {
        if (this.chunkProvider == null) {
            return ((class_5284)this.getGeneratorSettings().comp_349()).comp_474().comp_174();
        }
        return this.chunkProvider.getWorldHeight();
    }

    public int method_33730() {
        if (this.chunkProvider == null) {
            return ((class_5284)this.getGeneratorSettings().comp_349()).comp_474().comp_173();
        }
        return this.chunkProvider.getWorldMinY();
    }

    public int method_16398() {
        return this.chunkProvider.getSeaLevel();
    }

    protected class_6568 method_41537(class_2791 chunk, class_5138 world, class_6748 blender, class_7138 noiseConfig) {
        return ModernBetaChunkNoiseSampler.create(chunk, noiseConfig, (class_5284)this.settings.comp_349(), this.chunkProvider.getFluidLevelSampler(), this.chunkProvider);
    }

    public class_6880<class_5284> getGeneratorSettings() {
        return this.settings;
    }

    public class_7871<ModernBetaSettingsPreset> getPresetRegistry() {
        return this.presetRegistry;
    }

    public ChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public class_2487 getChunkSettings() {
        return this.chunkSettings;
    }

    public BiomeInjector getBiomeInjector() {
        return this.biomeInjector.get();
    }

    public boolean allowSurfaceRules() {
        return this.useSurfaceRules;
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    private void injectBiomes(class_2791 chunk, class_6544.class_6552 noiseSampler, BiomeInjector.BiomeInjectionStep step) {
        BiomeInjector biomeInjector = this.biomeInjector.get();
        if (biomeInjector != null) {
            biomeInjector.injectBiomes(chunk, noiseSampler, step);
        }
    }

    public static void register(IRegistryHandler<?> handler) {
        IRegistryHandler<?> registryHandler = handler;
        registryHandler.register(ModernerBeta.createId("moderner_beta"), CODEC);
    }
}

