/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.spawn;

import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProvider;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderNoise;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import mod.bluestaggo.modernerbeta.tags.ModernBetaBiomeTags;
import mod.bluestaggo.modernerbeta.util.chunk.ChunkHeightmap;
import mod.bluestaggo.modernerbeta.util.noise.PerlinOctaveNoise;
import mod.bluestaggo.modernerbeta.world.biome.ModernBetaBiomeSource;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import org.slf4j.event.Level;

public class SpawnLocatorBeta
implements SpawnLocator {
    private final Random rand;
    private final ChunkProvider chunkProvider;
    private final PerlinOctaveNoise beachOctaveNoise;

    public SpawnLocatorBeta(ChunkProvider chunkProvider, PerlinOctaveNoise beachOctaveNoise, Random rand) {
        this.rand = rand;
        this.chunkProvider = chunkProvider;
        this.beachOctaveNoise = beachOctaveNoise;
    }

    @Override
    public Optional<class_2338> locateSpawn() {
        int n;
        ChunkProvider chunkProvider;
        ModernerBeta.log(Level.INFO, "Setting a beach spawn..");
        int x = 0;
        int z = 0;
        int attempts = 0;
        while (!this.isSandAt(x, z, null)) {
            if (attempts > 10000) {
                ModernerBeta.log(Level.INFO, "Exceeded spawn attempts, spawning anyway at 0,0..");
                x = 0;
                z = 0;
                break;
            }
            x += this.rand.nextInt(64) - this.rand.nextInt(64);
            z += this.rand.nextInt(64) - this.rand.nextInt(64);
            ++attempts;
        }
        if ((chunkProvider = this.chunkProvider) instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(x, z, class_2902.class_2903.field_13194);
        }
        int y = n;
        return Optional.of(new class_2338(x, y, z));
    }

    private boolean isSandAt(int x, int z, class_5539 world) {
        class_6880<class_1959> class_68802;
        int n;
        double eighth = 0.03125;
        int seaLevel = this.chunkProvider.getSeaLevel();
        ChunkProvider chunkProvider = this.chunkProvider;
        if (chunkProvider instanceof ChunkProviderNoise) {
            ChunkProviderNoise noiseChunkProvider = (ChunkProviderNoise)chunkProvider;
            n = noiseChunkProvider.getHeight(x, z, ChunkHeightmap.Type.SURFACE_FLOOR);
        } else {
            n = this.chunkProvider.getHeight(x, z, class_2902.class_2903.field_13195);
        }
        int y = n;
        class_1966 class_19662 = this.chunkProvider.getChunkGenerator().method_12098();
        if (class_19662 instanceof ModernBetaBiomeSource) {
            ModernBetaBiomeSource oldBiomeSource = (ModernBetaBiomeSource)class_19662;
            class_68802 = oldBiomeSource.getBiomeForSpawn(x, y, z);
        } else {
            class_68802 = this.chunkProvider.getBiome(x >> 2, y >> 2, z >> 2, null);
        }
        class_6880<class_1959> biome = class_68802;
        return biome.method_40220(ModernBetaBiomeTags.SURFACE_CONFIG_SAND) && y >= seaLevel || this.beachOctaveNoise.sample((double)x * eighth, (double)z * eighth, 0.0) > 0.0 && y >= seaLevel && y <= seaLevel + 2;
    }
}

