/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.world.spawn;

import java.util.Optional;
import java.util.Random;
import mod.bluestaggo.modernerbeta.ModernerBeta;
import mod.bluestaggo.modernerbeta.api.world.chunk.ChunkProviderFinite;
import mod.bluestaggo.modernerbeta.api.world.spawn.SpawnLocator;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import org.slf4j.event.Level;

public class SpawnLocatorIndev
implements SpawnLocator {
    private final ChunkProviderFinite chunkProvider;

    public SpawnLocatorIndev(ChunkProviderFinite chunkProvider) {
        this.chunkProvider = chunkProvider;
    }

    @Override
    public Optional<class_2338> locateSpawn() {
        int spawnZ;
        int spawnX;
        int spawnY;
        Random random = new Random();
        int attempts = 0;
        int width = this.chunkProvider.getLevelWidth();
        int length = this.chunkProvider.getLevelLength();
        do {
            spawnX = random.nextInt(width / 2) + width / 4;
            spawnZ = random.nextInt(length / 2) + length / 4;
            spawnY = this.chunkProvider.getHeight(spawnX - width / 2, spawnZ - length / 2, class_2902.class_2903.field_13195) + 1;
            if (attempts >= 1000000) {
                ModernerBeta.log(Level.INFO, "[Indev] Exceeded spawn attempts, spawning anyway..");
                break;
            }
            ++attempts;
        } while (spawnY < 4 || spawnY <= this.chunkProvider.getSeaLevel() || this.nearSolidBlocks(spawnX, spawnY, spawnZ) || this.nearSolidBlocks2(spawnX, spawnY, spawnZ));
        return Optional.of(new class_2338(spawnX - width / 2, spawnY - 1, spawnZ - length / 2));
    }

    private boolean nearSolidBlocks(int spawnX, int spawnY, int spawnZ) {
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int y = spawnY - 1; y <= spawnY + 2; ++y) {
                for (int z = spawnZ - 3 - 2; z <= spawnZ + 3; ++z) {
                    class_2248 block = this.chunkProvider.getLevelBlock(x, y, z);
                    if (block.equals(class_2246.field_10124) || block.equals(this.chunkProvider.getLevelFluidBlock())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean nearSolidBlocks2(int spawnX, int spawnY, int spawnZ) {
        int y = spawnY - 2;
        for (int x = spawnX - 3; x <= spawnX + 3; ++x) {
            for (int z = spawnZ - 3 - 2; z <= spawnZ + 3; ++z) {
                class_2248 block = this.chunkProvider.getLevelBlock(x, y, z);
                if (!block.equals(class_2246.field_10124) && !block.equals(this.chunkProvider.getLevelFluidBlock())) continue;
                return true;
            }
        }
        return false;
    }
}

