/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import mod.bluestaggo.modernerbeta.ModernBetaBuiltInProviders;
import mod.bluestaggo.modernerbeta.api.level.chunk.surface.SurfaceConfig;
import mod.bluestaggo.modernerbeta.level.biome.ModernBetaBiomeSource;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.ConfiguredLayers;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.layers.LayerType;
import mod.bluestaggo.modernerbeta.level.biome.provider.fractal.predicates.BiomePredicateType;
import mod.bluestaggo.modernerbeta.level.carver.ModernBetaCarvers;
import mod.bluestaggo.modernerbeta.level.chunk.ModernBetaChunkGenerator;
import mod.bluestaggo.modernerbeta.level.feature.ModernBetaFeatures;
import mod.bluestaggo.modernerbeta.level.feature.ModernBetaFoliagePlacers;
import mod.bluestaggo.modernerbeta.level.feature.ModernBetaTrunkPlacers;
import mod.bluestaggo.modernerbeta.level.feature.placement.ModernBetaPlacementTypes;
import mod.bluestaggo.modernerbeta.level.structure.ModernBetaStructurePieceTypes;
import mod.bluestaggo.modernerbeta.level.structure.ModernBetaStructureTypes;
import mod.bluestaggo.modernerbeta.network.INetworkHelper;
import mod.bluestaggo.modernerbeta.registry.IRegistryHandler;
import mod.bluestaggo.modernerbeta.registry.ModernBetaRegistries;
import mod.bluestaggo.modernerbeta.registry.ModernBetaResourceKeys;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPreset;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettingsPresetCategory;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import mod.bluestaggo.modernerbeta.util.CodecUtil;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ModernerBeta {
    public static final String MOD_ID = "moderner_beta";
    public static final String MOD_NAME = "Moderner Beta";
    public static boolean DEV_ENV;
    public static boolean GENERATING_DATA;
    private static final Logger LOGGER;
    public static final List<String> BUILT_IN_PACKS;
    public static final List<Tuple<Registry<?>, Consumer<IRegistryHandler<?>>>> REGISTRY_HANDLERS;
    public static List<Tuple<Registry<?>, Consumer<IRegistryHandler<?>>>> CUSTOM_REGISTRY_HANDLERS;
    public static List<CustomDynamicRegistry<?>> CUSTOM_DYNAMIC_REGISTRIES;
    public static INetworkHelper networkHelper;
    public static ModernBetaSettings config;

    public static void init() {
        ModernerBeta.log(Level.INFO, "Initializing Moderner Beta...");
    }

    public static void setupCustomRegistryHandlers() {
        CUSTOM_REGISTRY_HANDLERS = List.of(new Tuple(ModernBetaRegistries.SETTINGS_COMPONENT_TYPE, SettingsComponentTypes::init), new Tuple(ModernBetaRegistries.CHUNK, ModernBetaBuiltInProviders::registerChunkProviders), new Tuple(ModernBetaRegistries.BIOME, ModernBetaBuiltInProviders::registerBiomeProviders), new Tuple(ModernBetaRegistries.CAVE_BIOME, ModernBetaBuiltInProviders::registerCaveBiomeProviders), new Tuple(ModernBetaRegistries.HEIGHT_CONFIG, ModernBetaBuiltInProviders::registerHeightConfigs), new Tuple(ModernBetaRegistries.BLOCKSOURCE, ModernBetaBuiltInProviders::registerBlockSources), new Tuple(ModernBetaRegistries.FRACTAL_LAYER, LayerType::init), new Tuple(ModernBetaRegistries.BIOME_PREDICATE, BiomePredicateType::init));
    }

    public static void setupCustomDynamicRegistries() {
        CUSTOM_DYNAMIC_REGISTRIES = List.of(new CustomDynamicRegistry<ModernBetaSettingsPreset>(ModernBetaResourceKeys.SETTINGS_PRESET, Registries.NOISE_SETTINGS, ModernBetaSettingsPreset.CODEC), new CustomDynamicRegistry<ModernBetaSettingsPresetCategory>(ModernBetaResourceKeys.SETTINGS_PRESET_CATEGORY, ModernBetaSettingsPresetCategory.CODEC), new CustomDynamicRegistry<SurfaceConfig>(ModernBetaResourceKeys.SURFACE_CONFIG, SurfaceConfig.CODEC));
    }

    public static ResourceLocation createId(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void log(Level level, String message) {
        LOGGER.atLevel(level).log("[Moderner Beta] {}", (Object)message);
    }

    public static void log(String message) {
        ModernerBeta.log(Level.INFO, message);
    }

    public static GsonBuilder getSettingsGson() {
        GsonBuilder gson = new GsonBuilder();
        CodecUtil.registerTypeAdapter(gson, ConfiguredLayers.class, ConfiguredLayers.CODEC);
        CodecUtil.registerTypeAdapter(gson, ResourceLocation.class, ResourceLocation.CODEC);
        return gson;
    }

    public static void loadConfig(Path configDir) {
        Path configFile = configDir.resolve("moderner_beta.json");
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            config = (ModernBetaSettings)ModernBetaSettings.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)ModernerBeta.getSettingsGson().create().fromJson((Reader)reader, JsonElement.class))).result().orElseGet(() -> Pair.of((Object)ModernBetaSettings.empty(), null)).getFirst();
        }
        catch (NoSuchFileException exception) {
            config = ModernBetaSettings.builder().addDefault(SettingsComponentTypes.CONFIG_BETA_CLIMATIC_COLORS, SettingsComponentTypes.CONFIG_PE_CLIMATIC_COLORS, SettingsComponentTypes.CONFIG_BETA_FRACTAL_CLIMATIC_COLORS, SettingsComponentTypes.CONFIG_BIOME_PREVIEW_COLORS, SettingsComponentTypes.CONFIG_MISCELLANEOUS).build();
            ModernerBeta.saveConfig(configDir);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            config = ModernBetaSettings.empty();
        }
    }

    public static void saveConfig(Path configDir) {
        Path configFile = configDir.resolve("moderner_beta.json");
        DataResult encodedConfig = ModernBetaSettings.CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject());
        if (encodedConfig.result().isEmpty()) {
            ModernerBeta.log(Level.WARN, "Failed to serialize config to JSON: " + String.valueOf(encodedConfig));
            return;
        }
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                ModernerBeta.getSettingsGson().setPrettyPrinting().create().toJson((JsonElement)encodedConfig.result().get(), (Appendable)writer);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)MOD_NAME);
        BUILT_IN_PACKS = List.of("reduced_height", "deepslate_blobs");
        REGISTRY_HANDLERS = List.of(new Tuple((Object)BuiltInRegistries.FOLIAGE_PLACER_TYPE, ModernBetaFoliagePlacers::register), new Tuple((Object)BuiltInRegistries.TRUNK_PLACER_TYPE, ModernBetaTrunkPlacers::register), new Tuple((Object)BuiltInRegistries.PLACEMENT_MODIFIER_TYPE, ModernBetaPlacementTypes::register), new Tuple((Object)BuiltInRegistries.STRUCTURE_TYPE, ModernBetaStructureTypes::register), new Tuple((Object)BuiltInRegistries.STRUCTURE_PIECE, ModernBetaStructurePieceTypes::register), new Tuple((Object)BuiltInRegistries.FEATURE, ModernBetaFeatures::register), new Tuple((Object)BuiltInRegistries.CARVER, ModernBetaCarvers::register), new Tuple((Object)BuiltInRegistries.BIOME_SOURCE, ModernBetaBiomeSource::register), new Tuple((Object)BuiltInRegistries.CHUNK_GENERATOR, ModernBetaChunkGenerator::register));
    }

    public record CustomDynamicRegistry<T>(ResourceKey<? extends Registry<T>> key, ResourceKey<? extends Registry<?>> insertAfter, Codec<T> codec) {
        public CustomDynamicRegistry(ResourceKey<? extends Registry<T>> key, Codec<T> codec) {
            this(key, null, codec);
        }
    }
}

