/*
 * Decompiled with CFR 0.152.
 */
package mod.bluestaggo.modernerbeta.api.level.biome;

import java.util.List;
import mod.bluestaggo.modernerbeta.api.level.biome.climate.TemperatureHeightScaling;
import mod.bluestaggo.modernerbeta.settings.ModernBetaSettings;
import mod.bluestaggo.modernerbeta.settings.SettingsComponentTypes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.biome.Biome;

public abstract class BiomeProvider {
    protected final ModernBetaSettings settings;
    protected final HolderGetter<Biome> biomeRegistry;
    protected final long seed;
    private final TemperatureHeightScaling temperatureHeightScaling;

    public BiomeProvider(ModernBetaSettings settings, HolderGetter<Biome> biomeRegistry, long seed) {
        this.settings = settings;
        this.biomeRegistry = biomeRegistry;
        this.seed = seed;
        this.temperatureHeightScaling = settings.getOrDefault(SettingsComponentTypes.TEMPERATURE_HEIGHT_SCALING);
    }

    public abstract Holder<Biome> getBiome(int var1, int var2, int var3);

    public List<Holder<Biome>> getBiomes() {
        return List.of();
    }

    public ModernBetaSettings getSettings() {
        return this.settings;
    }

    public TemperatureHeightScaling getTemperatureHeightScaling() {
        return this.temperatureHeightScaling;
    }

    public Component getBiomeName(int biomeX, int biomeY, int biomeZ) {
        return (Component)this.getBiome(biomeX, biomeY, biomeZ).unwrapKey().map(key -> Component.translatable((String)key.location().toLanguageKey("biome"))).orElse(Component.literal((String)"[unregistered]"));
    }
}

